#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<sys/types.h>
#include<sys/fcntl.h>
#include<string.h>
#include "bitmap.h"

#define MESSAGE_LENGTH 65536

int main(int argc,char *argv[])
{
  bmpheader bmph;
  FILE* fsrc,*fdest;

  char buffer[54];
  static char message[MESSAGE_LENGTH];
  int tempval=0;
  int offset=0;

  if(argc < 3)
    {
      printf("usage: ./encrypt <source-bitmap-filename> <encrypted-bitmap-filename\n");
      printf("eg:./encrypt GNU.bmp GNUenc.bmp\n");
      printf("This isto encode some data into the image file \"GNU.bmp\" and \n");
      printf("save the new image in a file \"GNUenc.bmp\" use it like\n\n");
      printf("(C) 2004 Muthiah Annmalai. GPL'ed\n");
      return -1;
    }

  fsrc=fopen(argv[1],"rb");
  fdest=fopen(argv[2],"wb");

  if ((fsrc != NULL) && (fdest != NULL))
    {
#ifdef DEBUG_BMP
      printf("File %s opened\n",name);
#endif
    }
  else
    {
      printf("Cannot Open one/both of the files\n");
      return -2;
    }

  fread(buffer,54,1,fsrc);
  fseek(fsrc,0,SEEK_SET);
  
  // strcpy(message,"I Love India");
  //   fgets(message,MESSAGE_LENGTH,stdin);
  tempval=0;
  while(!feof(stdin) && tempval<MESSAGE_LENGTH)
    {
      message[tempval++]=fgetc(stdin);
    }

  bmp_read_header(fsrc,&bmph);
  fwrite(&buffer,54,1,fdest);
  
  tempval=8*strlen(message);
  /*  printf("strlen=%d pixelsize=%d\n",tempval,bmph.pixelsize*3 ); */
  if (tempval > (3*bmph.pixelsize))
    {
      printf("Image File is too small to fit your data\n");
      fclose(fsrc);
      return -1;
    }

  /* encode the message. */
  offset=54+encode_message_to_file(fdest,fsrc,message);
  /*  printf("File Copy\n"); */
  file_copy(fdest,fsrc,offset);

  fclose(fsrc);
  fclose(fdest);
  return 0;
}
/* //gcc -Wall encrypt.c -o ./encrypt */
