#include "support.h"
#include "connect.h"

#define _ 



GtkWidget* create_window(void)
{
  GtkWidget *window1;
  GtkWidget *vbox1;

  GtkWidget *hbox1;
  GtkWidget *hbox2;
  GtkWidget *hbox3;
  
  GtkTargetEntry t={"string",GTK_DEST_DEFAULT_ALL,1};
  GtkWidget *src_file_btn;
  GtkWidget *src_file_entry;
  GtkWidget *des_file_btn;
  GtkWidget *des_file_entry;

  // menu item.
  GtkWidget *mbar;
  GtkWidget *menu;
  GtkWidget *file;
  GtkWidget *help;
  GtkWidget *it;

  //accelerator.
  GtkAccelGroup *g;
  guint key;
  GdkModifierType mask;

  //Tool bar.
  GtkWidget *tbar;

  //Status bar
  GtkWidget *sbar;

  GSList *g1_group = NULL;

  GtkWidget *radiobutton2;
  GtkWidget *radiobutton3;

  GtkWidget *scrolledwindow1;
  GtkWidget *text;
  GtkTextBuffer *textbuffer1;

  GtkWidget *encrypt_btn;
  GtkWidget *decrypt_btn;
  GtkWidget *src_image_btn;
  GtkWidget *des_image_btn;
  
  GtkTextIter start;

  GtkWidget *hzline=NULL;

  window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (window1), "window1", window1);
  gtk_container_set_border_width (GTK_CONTAINER (window1), 2);
  gtk_window_set_title (GTK_WINDOW (window1), _("Steganography"));
  gtk_window_set_position (GTK_WINDOW (window1), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (window1), FALSE);


  /*

  GtkMenuBar *menu;
  GtkWidget *file;
  GtkWidget *help;
  GtkWidget *it;

  */

  g=gtk_accel_group_new();
  mbar=gtk_menu_bar_new();
  menu=gtk_menu_new();
  gtk_widget_ref(GTK_WIDGET(mbar));
  gtk_object_set_data_full (GTK_OBJECT (window1), "mbar", mbar,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_window_add_accel_group(GTK_WINDOW(window1),g);

  file=gtk_menu_item_new_with_mnemonic("_File");    
  
  /*
    File
    +-Close
    +-Quit
  */

  it=gtk_image_menu_item_new_from_stock(GTK_STOCK_CLOSE,g);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu),it);
  gtk_signal_connect(GTK_OBJECT(it),
		     "activate",
		     GTK_SIGNAL_FUNC(gtk_main_quit),
		     NULL);

  it=gtk_image_menu_item_new_from_stock(GTK_STOCK_QUIT,g);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu),it);
  gtk_signal_connect(GTK_OBJECT(it),
		     "activate",
		     GTK_SIGNAL_FUNC(gtk_main_quit),
		     NULL);

  gtk_menu_item_set_submenu(GTK_MENU_ITEM(file),menu);
  gtk_menu_shell_append(GTK_MENU_SHELL(mbar),file);
  
  /*
    Help
    +-Tutorial
    +-About.
  */  
    
  help=gtk_menu_item_new_with_mnemonic("_Help");
  menu=gtk_menu_new();

  it=gtk_image_menu_item_new_from_stock(GTK_STOCK_HELP,g);  //life saver icon! huh..
  gtk_menu_shell_append(GTK_MENU_SHELL(menu),it);
  gtk_signal_connect(GTK_OBJECT(it),
		     "activate",
		     GTK_SIGNAL_FUNC(stego_help_contents),
		     NULL);

  key=0;
  it=gtk_image_menu_item_new_with_mnemonic("_About");
  gtk_accelerator_parse("<ctrl><shift>A",&key,&mask); //following GNOME funda's
  gtk_widget_add_accelerator(it,"activate",
			     g,
			     key,
			     mask,
			     GTK_ACCEL_MASK);

  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(it),
				gtk_image_new_from_file( STEGO_IMAGE_DIR "/gnome-default-dlg.png"));

  gtk_menu_shell_append(GTK_MENU_SHELL(menu),it);
  gtk_signal_connect(GTK_OBJECT(it),
		     "activate",
		     GTK_SIGNAL_FUNC(stego_about),
		     NULL);
    
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(help),menu);
  gtk_menu_shell_append(GTK_MENU_SHELL(mbar),help);  

#if 0
  //older way of adding accelerators to menu items.
  gtk_accelerator_parse("<ctrl>Q",&key,&mask); //following GNOME funda's
  gtk_widget_add_accelerator(it,"activate",
			     g,
			     key,
			     mask,
			     GTK_ACCEL_MASK);
#endif

  /*

  GtkToolbar *tbar;
  */
  tbar=gtk_toolbar_new();
  gtk_widget_ref(GTK_WIDGET(tbar));
  gtk_object_set_data_full (GTK_OBJECT (window1), "tbar", tbar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_toolbar_append_item(GTK_TOOLBAR(tbar),
			  "Encrypt",
			  "Encrypts the message into the BMP file",
			  NULL,
			  gtk_image_new_from_file(STEGO_IMAGE_DIR "/gdict.png"),
			  (GtkSignalFunc )on_encrypt_toolbar_clicked,
			  NULL);
			  
  gtk_toolbar_append_item(GTK_TOOLBAR(tbar),
			  "Decrypt",
			  "Decrypts the message from  the BMP file, and displays it",
			  NULL,
			  gtk_image_new_from_file( STEGO_IMAGE_DIR "/gabber.png"),
			  (GtkSignalFunc )on_decrypt_toolbar_clicked,
			  NULL);
			  
  gtk_icon_size_register("__ArbuTAcc",32,32);
  gtk_toolbar_append_item(GTK_TOOLBAR(tbar),
			  "Tutorial",
			  "Click to see Tutorial",
			  NULL,
			  gtk_image_new_from_stock(GTK_STOCK_HELP,					
						   gtk_icon_size_from_name("__ArbuTAcc")),
			  (GtkSignalFunc )stego_help_contents,
			  NULL);
    
    gtk_toolbar_append_item(GTK_TOOLBAR(tbar),
			  "About",
			  "About Stego",
			  NULL,
			  gtk_image_new_from_file(STEGO_IMAGE_DIR "/gnome-default-dlg.png"),
			  (GtkSignalFunc )stego_about,
			  NULL);
  
  gtk_toolbar_append_item(GTK_TOOLBAR(tbar),
			  "Quit",
			  "Quits the Program",
			  NULL,
			  gtk_image_new_from_stock(GTK_STOCK_QUIT,
						   gtk_icon_size_from_name("__ArbuTAcc")),
			  (GtkSignalFunc )gtk_main_quit,
			  NULL);


  /*
    Status Bar.
  */
  sbar=gtk_statusbar_new();
  gtk_statusbar_push(GTK_STATUSBAR(sbar),
		     0,
		     "Hello World!");

  gtk_widget_ref(GTK_WIDGET(sbar));
  gtk_object_set_data_full (GTK_OBJECT (window1), "sbar",sbar,
                            (GtkDestroyNotify) gtk_widget_unref);


  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (window1), vbox1);

  gtk_widget_show_all(mbar);
  gtk_widget_show_all(tbar);
  gtk_box_pack_start (GTK_BOX (vbox1), mbar, FALSE, FALSE, 0);//menu bar.
  gtk_box_pack_start (GTK_BOX (vbox1), tbar, FALSE, FALSE, 0);//tool bar.

  /*
    Add the buttons one by one.

    1.Encrypt
    2.Decrypt
    3.Show Src Image
    4.Show Des Image
  */


  encrypt_btn = gtk_button_new_with_label (_("Encrypt"));
  gtk_widget_ref (encrypt_btn);
  gtk_object_set_data_full (GTK_OBJECT (window1), "encrypt_btn", encrypt_btn,
                            (GtkDestroyNotify) gtk_widget_unref);
  /*  gtk_container_add (GTK_CONTAINER (vbox1), encrypt_btn); */
  GTK_WIDGET_SET_FLAGS (encrypt_btn, GTK_CAN_DEFAULT);



  decrypt_btn = gtk_button_new_with_label (_("Decrypt"));
  gtk_widget_ref (decrypt_btn);
  gtk_object_set_data_full (GTK_OBJECT (window1), "decrypt_btn", decrypt_btn,
                            (GtkDestroyNotify) gtk_widget_unref);
  /*  gtk_container_add (GTK_CONTAINER (vbox1), decrypt_btn); */
  GTK_WIDGET_SET_FLAGS (decrypt_btn, GTK_CAN_DEFAULT);



  src_image_btn = gtk_button_new_with_label (_("Show Src Image"));
  gtk_widget_ref (src_image_btn);
  gtk_object_set_data_full (GTK_OBJECT (window1), "src_image_btn", src_image_btn,
                            (GtkDestroyNotify) gtk_widget_unref);
  /*  gtk_container_add (GTK_CONTAINER (vbox1), src_image_btn); */
  GTK_WIDGET_SET_FLAGS (src_image_btn, GTK_CAN_DEFAULT);




  des_image_btn = gtk_button_new_with_label (_("Show Des Image"));
  gtk_widget_ref (des_image_btn);
  gtk_object_set_data_full (GTK_OBJECT (window1), "des_image_btn", des_image_btn,
                            (GtkDestroyNotify) gtk_widget_unref);
  /*  gtk_container_add (GTK_CONTAINER (vbox1), des_image_btn); */
  GTK_WIDGET_SET_FLAGS (des_image_btn, GTK_CAN_DEFAULT);


  /*
    Make Radio Buttons
  */
  hbox2 = gtk_hbox_new (TRUE, 0);
  radiobutton2 = gtk_radio_button_new_with_label (g1_group, _("Encrypt"));
  g1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton2));
  gtk_widget_ref (radiobutton2);
  gtk_object_set_data_full (GTK_OBJECT (hbox2), "radiobutton2", radiobutton2,
                            (GtkDestroyNotify) gtk_widget_unref);  
  gtk_box_pack_start (GTK_BOX (hbox2), radiobutton2, !FALSE, !FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox2), encrypt_btn, !FALSE, !FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox2), decrypt_btn, !FALSE, !FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, FALSE, 0);

  hbox3 = gtk_hbox_new (TRUE, 0);
  radiobutton3 = gtk_radio_button_new_with_label (g1_group, _("Decrypt"));
  g1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton3));
  gtk_widget_ref (radiobutton3);
  gtk_object_set_data_full (GTK_OBJECT (hbox3), "radiobutton3", radiobutton3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox3), radiobutton3, !FALSE, !FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox3), src_image_btn, !FALSE, !FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox3), des_image_btn, !FALSE, !FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, FALSE, 0);




  /*
    Add the first entry & buttons
  */
  hbox1 = gtk_hbox_new (TRUE, TRUE);
  gtk_widget_ref (hbox1);

  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);

  hzline = gtk_hseparator_new();
  gtk_box_pack_start (GTK_BOX (vbox1), hzline, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 0);




  src_file_btn = gtk_button_new_with_label (_("Src Image File"));
  gtk_widget_ref (src_file_btn);
  gtk_object_set_data_full (GTK_OBJECT (window1), "src_file_btn", src_file_btn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox1), src_file_btn, !FALSE, !FALSE, 0);


  src_file_entry = gtk_entry_new ();
  gtk_widget_ref (src_file_entry);
  gtk_object_set_data_full (GTK_OBJECT (window1), "src_file_entry", src_file_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox1), src_file_entry, FALSE, FALSE, 0);

  gtk_drag_dest_set (src_file_entry,
		     GTK_DEST_DEFAULT_ALL,
		     &t , 1, GDK_ACTION_COPY);



  /*
    Add the next entry& buttons
  */

  hbox1 = gtk_hbox_new (TRUE, TRUE);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 0);
  

  des_file_btn = gtk_button_new_with_label (_("Des Image File"));
  gtk_widget_ref (des_file_btn);
  gtk_object_set_data_full (GTK_OBJECT (window1), "des_file_btn", des_file_btn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox1), des_file_btn, !FALSE, !FALSE, 0);

  des_file_entry = gtk_entry_new ();
  gtk_widget_ref (des_file_entry);
  gtk_object_set_data_full (GTK_OBJECT (window1), "des_file_entry", des_file_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox1), des_file_entry, FALSE, FALSE, 0);




  /*
    Add the  Text box
  */
  hzline = gtk_hseparator_new();
  gtk_box_pack_start (GTK_BOX (vbox1), hzline, FALSE, FALSE, 0);
  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);

  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_container_add (GTK_CONTAINER (vbox1), scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  
  textbuffer1 = gtk_text_buffer_new(NULL);
  text = gtk_text_view_new_with_buffer(GTK_TEXT_BUFFER(textbuffer1));

  gtk_text_buffer_create_tag(GTK_TEXT_BUFFER(textbuffer1),
			     "ThemeFgBg",
			     "foreground","DarkRed",//Coffee!
			     "background","#f0f0f0",//and something light.
			     "wrap_mode",TRUE,
			     "justification",GTK_JUSTIFY_LEFT,
			     "pixels_above_lines",10,
			     "pixels_below_lines",10,
			     "underline",TRUE,
			     NULL);

			     
  gtk_widget_ref (text);

  gtk_object_set_data_full (GTK_OBJECT (window1), "text", text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), text);
  gtk_text_buffer_get_start_iter(GTK_TEXT_BUFFER(textbuffer1),&start);

  gtk_text_buffer_create_tag(GTK_TEXT_BUFFER(textbuffer1),"bg_red",
			     "background","red",NULL);
			      
  gtk_text_buffer_create_tag(GTK_TEXT_BUFFER(textbuffer1),"bg_green",
			     "background","green",NULL);

  gtk_text_buffer_create_tag(GTK_TEXT_BUFFER(textbuffer1),"fg_yellow",
			     "foreground","yellow",NULL);

  gtk_text_buffer_create_tag(GTK_TEXT_BUFFER(textbuffer1),"fg_red",
			     "foreground","red",NULL);



  gtk_container_add (GTK_CONTAINER (vbox1),sbar);//statusbar in the end.

  /*
    signal connects
  */



  /*
    src_file & des_file buttons
  */
  
  gtk_signal_connect (GTK_OBJECT (src_file_btn), "clicked",
                      GTK_SIGNAL_FUNC (on_srcfile_clicked),
                      src_file_entry);

  gtk_signal_connect (GTK_OBJECT (des_file_btn), "clicked",
                      GTK_SIGNAL_FUNC (on_desfile_clicked),
                      des_file_entry);

  /*
    radio button
  */
  gtk_signal_connect (GTK_OBJECT (radiobutton3), "toggled",
                      GTK_SIGNAL_FUNC (on_encrypt_decrypt_toggled),
                      NULL);


  /*
    Add the buttons one by one.

    1.Encrypt
    2.Decrypt

  */
  gtk_signal_connect (GTK_OBJECT (encrypt_btn), "clicked",
                      GTK_SIGNAL_FUNC (on_encrypt_btn_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (decrypt_btn), "clicked",
                      GTK_SIGNAL_FUNC (on_decrypt_btn_clicked),
                      NULL);

  /*
    src_image & des_image buttons
  */
  gtk_signal_connect (GTK_OBJECT (src_image_btn), "clicked",
                      GTK_SIGNAL_FUNC (on_srcimage_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (des_image_btn), "clicked",
                      GTK_SIGNAL_FUNC (on_destimage_clicked),
                      NULL);
  /*
    src_file_entry & dest_file_entry
  */
  gtk_signal_connect (GTK_OBJECT (src_file_entry), "changed",
                      GTK_SIGNAL_FUNC (on_srcfile_changed),
                      NULL);

  gtk_signal_connect (GTK_OBJECT (des_file_entry), "changed",
                      GTK_SIGNAL_FUNC (on_destfile_changed),
                      NULL);



  /*
    making a text callback
  */
  g_signal_connect (G_OBJECT (textbuffer1),"changed",
		    GTK_SIGNAL_FUNC (on_text_changed),
		    text);

  /*
    Drag & Drop  facility for text.
    drag & drop for the src_file_entry, des_file_entry.
  */
  {
    static const GtkTargetEntry targets[] = {
      { "UTF8_STRING", 0, 0 },
      { "STRING", 0, 0 },
      { "TEXT",   0, 0 }, 
      { "COMPOUND_TEXT", 0, 0 },
      { "text/plain",0,0},
      { "text/uri-list",0,1}};
    
  //src file entry
  gtk_drag_dest_set (src_file_entry,
		     GTK_DEST_DEFAULT_HIGHLIGHT |
		     GTK_DEST_DEFAULT_MOTION |
		     GTK_DEST_DEFAULT_DROP,
		     targets, 6,
		     GDK_ACTION_COPY);

  g_signal_connect (src_file_entry,
		    "drag_drop",
		    G_CALLBACK (entry_drop),
		    NULL);    


  g_signal_connect (src_file_entry,
		    "drag_data_received",
		    G_CALLBACK (entry_drop_handle),
		    NULL);    


  //dest file entry
  gtk_drag_dest_set (des_file_entry,
		     GTK_DEST_DEFAULT_HIGHLIGHT |
		     GTK_DEST_DEFAULT_MOTION |
		     GTK_DEST_DEFAULT_DROP,
		     targets, 6,
		     GDK_ACTION_COPY);


  g_signal_connect (des_file_entry,
		    "drag_drop",
		    G_CALLBACK (entry_drop),
		    NULL);    

  g_signal_connect (des_file_entry,
		    "drag_data_received",
		    G_CALLBACK (entry_drop_handle),
		    NULL);    


  //text file drop.
  gtk_drag_dest_set (text,
		     GTK_DEST_DEFAULT_HIGHLIGHT |
		     GTK_DEST_DEFAULT_MOTION |
		     GTK_DEST_DEFAULT_DROP,
		     targets, 6,
		     GDK_ACTION_COPY);

  g_signal_connect (text,
		    "drag_drop",
		    G_CALLBACK (entry_drop),
		    NULL);    


  g_signal_connect (text,
		    "drag_data_received",
		    G_CALLBACK (text_drop_handle),
		    NULL);    

  }    
  
  /*
    window1 
  */  
  gtk_signal_connect (GTK_OBJECT (window1), "destroy",
                      GTK_SIGNAL_FUNC (gtk_main_quit),
                      NULL);
  

  return window1;
}

GtkWidget*
lookup_widget                          (GtkWidget       *widget,
                                        const gchar     *widget_name)
{
  GtkWidget *parent, *found_widget;

  for (;;)
    {
      if (GTK_IS_MENU (widget))
        parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
      else
        parent = widget->parent;
      if (parent == NULL)
        break;
      widget = parent;
    }

  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
                                                   widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}

//#define DEBUG_STEGO
gboolean stego_change_state(StegoState *s,GtkWidget *root)
{

  GtkWidget *w;

#ifdef DEBUG_STEGO 
  g_printf("Here I am\n");
#endif

#ifdef DEBUG_STEGO 
  g_printf("Looking to Set State s->state=%c\n",s->state);
#endif

  if (s->state == 'E')
    {

      /*
	disable  'Decrypt' & 'show dest'.
	Enable 'show dest' after you have 
	completed encrypting the file.
      */


      w=lookup_widget(root,"des_file_btn");
      if(w!=NULL)
	gtk_widget_set_sensitive(w,TRUE);
      else {
#ifdef DEBUG_STEGO 
	g_printf("NULL==Des_file_btn");
#endif 
      }
      
      w=lookup_widget(root,"des_file_entry");
      if(w!=NULL)
	gtk_widget_set_sensitive(w,TRUE);
      else {	
#ifdef DEBUG_STEGO 
	g_printf("NULL==Des_file_entry");
#endif 
      }


      w=lookup_widget(root,"decrypt_btn");
      if(w!=NULL)
	gtk_widget_set_sensitive(w,FALSE);
      else {
#ifdef DEBUG_STEGO 
	g_printf("NULL==Dencrypt_btn");
#endif 
      }

      w=lookup_widget(root,"encrypt_btn");
      if(w!=NULL)
	gtk_widget_set_sensitive(w,TRUE);
      else {
#ifdef DEBUG_STEGO 
	g_printf("NULL==Encrypt_btn");
#endif 
      }
	  
     
      w=lookup_widget(root,"text");
      if(w!=NULL)
	gtk_widget_set_sensitive(w,TRUE);
      else {
#ifdef DEBUG_STEGO 
	g_printf("NULL==Text");
#endif 
      }

      w=lookup_widget(root,"src_image_btn");
      if(w!=NULL)
	gtk_widget_set_sensitive(w,TRUE);      
      else {
#ifdef DEBUG_STEGO 
	g_printf("src_image==NULL");
#endif 

      }
      
      w=lookup_widget(root,"des_image_btn");
      if(w!=NULL)
	gtk_widget_set_sensitive(w,FALSE);
      else {	
#ifdef DEBUG_STEGO 
	g_printf("dest_image==NULL");
#endif 
      }

      w=lookup_widget(root,"text");
      if(w!=NULL)
	{
	  gtk_widget_set_sensitive(w,TRUE);
	  gtk_text_view_set_editable(GTK_TEXT_VIEW(w),TRUE);
	}

            
    }
  else if(s->state == 'D')
    {
      /*
	disable  'Encrypt' & 'show_src' & 'show dest' & 'text'.
	Enable 'text' after you have 
	completed decrypting the file.
	set text to Read Only , non-editable
      */
      
      
      w=lookup_widget(root,"decrypt_btn");
      if(w!=NULL)
	gtk_widget_set_sensitive(w,TRUE);
      else {
#ifdef DEBUG_STEGO 
	g_printf("NULL==Dencrypt_btn");
#endif 
      }

      w=lookup_widget(root,"des_file_btn");
      if(w!=NULL)
	gtk_widget_set_sensitive(w,FALSE);
      else {
#ifdef DEBUG_STEGO 
	g_printf("NULL==Des_file_btn");
#endif
      }
      
      w=lookup_widget(root,"des_file_entry");
      if(w!=NULL)
	gtk_widget_set_sensitive(w,FALSE);
      else {
#ifdef DEBUG_STEGO 
	g_printf("NULL==Des_file_entry");
#endif
      }
      
      w=lookup_widget(root,"encrypt_btn");
      if(w!=NULL)
	gtk_widget_set_sensitive(w,FALSE);
      else {
#ifdef DEBUG_STEGO 
	g_printf("NULL==Encrypt_btn");
#endif
      }

     
      w=lookup_widget(root,"text");
      if(w!=NULL)
	gtk_widget_set_sensitive(w,FALSE);
      else {
#ifdef DEBUG_STEGO 
	g_printf("text==NULL");
#endif
      }
      
      
      w=lookup_widget(root,"src_image_btn");
      if(w!=NULL)
	gtk_widget_set_sensitive(w,TRUE);      
      else {
#ifdef DEBUG_STEGO 
	g_printf("src_image==NULL");
#endif
      }
      
      
      w=lookup_widget(root,"des_image_btn");
      if(w!=NULL)
	gtk_widget_set_sensitive(w,FALSE);
      else {
#ifdef DEBUG_STEGO 
	g_printf("dest_image==NULL");
#endif
      }
      
      
      w=lookup_widget(root,"text");
      if(w!=NULL)
	{
	  gtk_widget_set_sensitive(w,TRUE);
	  gtk_text_view_set_editable(GTK_TEXT_VIEW(w),FALSE);
	}
      else     
	return FALSE;
    }  

#ifdef DEBUG_STEGO 
  g_printf("Later I am\n");
#endif
  
  return TRUE;      
}

/*
  Modal, and Blocks.
*/
gboolean stego_report_dialog(gchar *str)
{
  GtkWidget *w;
  w= gtk_message_dialog_new(NULL,
			    GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
			    GTK_MESSAGE_WARNING,
			    GTK_BUTTONS_OK,
			    str);
  gtk_window_set_position(&GTK_DIALOG(w)->window,GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_dialog_run(GTK_DIALOG(w));
  gtk_widget_destroy(w);
  return 0;
}

/*
  Modal, and Blocks
  please g_free the pointer returned
*/
gchar *stego_get_file(const gchar *title)
{
  GtkWidget *w;
  gchar *str;

  w=gtk_file_selection_new (title);
  gtk_window_set_modal(GTK_WINDOW(w),TRUE);  
  /*Make use of inheritance! fileselection inherits from dialog from window.*/

  gtk_file_selection_set_select_multiple(GTK_FILE_SELECTION(w),FALSE);
  
  if(gtk_dialog_run(GTK_DIALOG(w))!=GTK_RESPONSE_OK)
    {
      gtk_widget_destroy(w);
      return NULL;
    }

  str=(gchar *)gtk_file_selection_get_filename(GTK_FILE_SELECTION(w));
  str=g_strdup(str);

  gtk_window_set_position(&GTK_DIALOG(w)->window,GTK_WIN_POS_CENTER_ON_PARENT);

  /*delete the file dialog box*/
  gtk_widget_destroy(w);

  return str;
}

/*
  Modal, and Blocks
  please g_free the pointer returned
*/
gchar  *stego_get_file_ensure(const gchar *title,const gchar *type)
{
  gchar *w,*r;
  gboolean flag=TRUE;
  w=g_strconcat(title,": choose only .",type," files",NULL);

  r=stego_get_file(w);
  if(!r)
      return NULL;

  //check if the returned string has a ".type" 
  if(g_str_has_suffix(r,type)==TRUE)
    {
#ifdef DEBUG_STEGO 
      g_printf("correct file : %s of type %s\n",r,type);
#endif
      flag=FALSE;
    }
  else
    {
      //user chose some other type of file.
      g_free(r);
      stego_report_dialog(w);
    }

  if(flag==FALSE)
    return r;

  return (gchar *)NULL;
}
