 /*  $Id: lside.c, 16/01/08

    Copyright (C) 2008 Salvatore Santagati <salvatore.santagati@gmail.com>

    This program is free software; you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version. 

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the
    Free Software Foundation, Inc.,
    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h> 
#include <getopt.h>
#include "lside.h"
#include "./config.h"

int n_device = 0;
int arg_version = 0;

typedef struct device{	
	char dev[14]; 		/* /dev/hd* */
	char model[28];		/* model name 	 */
	char media[8];		/* media type 	 */
	char driver[23];	/* media driver	 */ 
	char dummy [7];
	char version[4];
	int  capacity;		
	} device;

typedef struct partitions{
	int  major;
	int  minor;
	int  block;
	char dev[14];
	} partitions;

typedef struct fstab {
	char dev[14];
	char mnt[14];
	char fs[8];
	char opt[30];
	int  dump_freq;
	int  pass_num;
	} fstab;


void
usage ()
{
  printf ("lside v%s by Salvatore Santagati\n", VERSION);
  printf ("Web     : http//lside.berlios.de\n");
  printf ("Email   : salsan@users.berlios.de\n");
  printf ("License : released under the GNU GPL v2 or later\n\n");
  printf ("Usage :\n");
  printf ("lside [OPTION]\n\n");
  printf ("OPTION\n");
  printf ("\t-v --version display version\n");
  printf ("\t-h --help    display this notice\n\n");
}


void parse_options(int argc, char ** argv)
{
  int c = 0; 
  int option_index = 0;
  
 
  
   while (1)
        {
         static struct option long_options[] =
             {
               {"help",        no_argument,       0, 'h'},
               {"version",     no_argument,       0, 'i'}, 
               {0, 0, 0, 0}
             };    

           c = getopt_long (argc, argv, OPTIONS_LIST,
                            long_options, &option_index);

           /* Detect the end of the options. */
           if (c == -1)
             break;
                switch(c)
             {
              case 'h': case '?':
                   usage();		   
		   exit(0);
		   break;
              case 'v': 
		   printf ("lside v%s by Salvatore Santagati\n", VERSION);
		   exit(0);
                   break;

              default:
                      fprintf (stderr, "?? getopt returned character code 0%o ??\n", c);

                      }

             }
}


/* check info on fstab */

int check_info_fstab (char *dev)
{
 fstab fstab_device;

 char fstab_line[70];

 FILE *fopen_fstab;

	
		
	if ((fopen_fstab = fopen (DEVICE_FSTAB, "r")) != NULL)
		{
		
			while (fgets(fstab_line, 70, fopen_fstab))
				{
					fscanf(fopen_fstab, "%s%s%s%s%d%d",
							fstab_device.dev,
							fstab_device.mnt,
							fstab_device.fs,
							fstab_device.opt,
							&fstab_device.dump_freq,
							&fstab_device.pass_num);
												
					
					if ((strstr(fstab_device.dev, dev) != NULL))
						{								
							printf("\t\t\t\t   | Mount   : %s\n",fstab_device.mnt);
							printf("\t\t\t\t   | FS	     : %s\n",fstab_device.fs);
							printf("\t\t\t\t   | Options : %s\n",fstab_device.opt);
							printf("\t\t\t\t   | Dump Fr.: %d\n",fstab_device.dump_freq);
							printf("\t\t\t\t   | Pass Num: %d\n",fstab_device.pass_num);
							
						};				

				};
			fclose(fopen_fstab);
		};

	return 1;

}

		

/* check info of partitions */
int check_partition(char *dev)
{

 partitions device;

 char partition[28];
 int i = 0;


 FILE *fopen_partition;

		
	if ((fopen_partition = fopen (DEVICE_PARTITIONS, "r")) != NULL)
		{
		
			while (fgets(partition, 27, fopen_partition))
				{
					fscanf(fopen_partition, "%d%d%d%s",
							&device.major,
							&device.minor,
							&device.block,
							device.dev);	
												
		
					if ((strstr(dev, device.dev) != NULL))
						{
							if (i == 0) i++;
							
							else 		
								{
				
									printf("\t\t\t\t   | Capacity: %d byte\n",device.block);
							
									check_info_fstab(device.dev);
								}
						};				

				};
			fclose(fopen_partition);
		};

	
	
	return 1;
	
}

int check_unit_logic(device *wDevice)
{

 char device1[14];
 char string_error[30]; 
 int j=1 ;


 FILE *fopen_device;

	printf("\t | Unit Logic-\n");

 	do	{	
			 
			sprintf(device1, "%s%d", wDevice[n_device].dev, j);			
			
			if((fopen_device = fopen(device1, "r")) != NULL)
				{
					printf("\t\t     |-->%s\n", device1);
					fclose(fopen_device);
				}

			else 
				{
					sprintf(string_error , "%s", strerror(errno));				
								
					if (strcmp(LINUX_PERMISSION_DENIED, string_error) == 0)
						{
							printf("\t\t     |-->%s -\n", device1);
							check_partition(device1);
							
						}
				
				}
			j++;
			
		     }
	while ((strcmp(LINUX_PERMISSION_DENIED, string_error) == 0));
	

 return 1;
}


int check_ide_device (device *wDevice)
{
 
 char device1[16]; 


 char ide [25];
 
  
 int i;
 int j = 0;

 FILE *fopen_device; 

 	/* Check from hda (96 in ASCII) at 122 hdz (122 in ASCII) */
	for (i = 97 ; i < 123; i++)
		{	
	
			sprintf(device1, "%s%c", DEVICE_IDE_DIR, i);			
		
			sprintf(ide, "%s%s", device1, DEVICE_IDE_MODEL);

			/* Check model of device */
			if ((fopen_device = fopen (ide, "r")) != NULL)
				{
	
					sprintf(wDevice[j].dev, "/dev/hd%c", i);				
				
					fgets(wDevice[j].model, 28, fopen_device);
					
					printf("%s - %s", wDevice[j].dev,wDevice[j].model);
					

					fclose(fopen_device);
				}	
			
			
			
			sprintf(ide, "%s%s", device1, DEVICE_IDE_MEDIA);
			
			
			/* Check media type */
			if ((fopen_device = fopen(ide, "r")) != NULL)
				{									
					fgets(wDevice[j].media, 8, fopen_device);
					printf("\t | Media   : %s" , wDevice[j].media);

					fclose(fopen_device);
				};
			
			sprintf(ide, "%s%s", device1, DEVICE_IDE_DRIVER);

			/* Check media driver */			
			if((fopen_device = fopen(ide, "r")) != NULL)
				{
					
					fscanf(fopen_device, "%s%s%s", wDevice[j].driver, wDevice[j].dummy , 					       wDevice[j].version);

					printf("\t | Driver  : %s v.%s\n", wDevice[j].driver, wDevice[j].version);
					
					fclose(fopen_device);	
				}

			sprintf(ide, "%s%s", device1, DEVICE_IDE_CAPACITY);
			
			/* Check capacity of driver */
			if((fopen_device = fopen(ide, "r")) != NULL)
				{
					fscanf(fopen_device, "%d", &wDevice[j].capacity);
					
					wDevice[j].capacity = wDevice[j].capacity / PROC_GB;
					printf("\t | Capacity: %d GB\n", wDevice[j].capacity);
					
					if(strstr(wDevice[j].media,"cdrom") != 0) 
							{
								check_info_fstab (wDevice[j].dev);			
							}

						else
							{
								check_unit_logic(wDevice);
							}
	
					j++;		
					fclose(fopen_device);					
					n_device++;
				}
		};	

	if(j>0) 
		{
		  j--;
		  n_device = j;
		  return 1;
		}
	
	else	return 0;

	
			
}


int main (int argc, char **argv)
{
 device wDevice[NUM_MAX];

 parse_options(argc, argv); 

 check_ide_device(wDevice);

return 1;

}



