/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl							   *
 *   k.zawadyl@gmail.com												   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "configgeneral.h"
#include "mconfiguration.h"

#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>

#include <kurlrequester.h>
#include <knuminput.h>

ConfigGeneral::ConfigGeneral(QWidget *parent, const char *name)
    :ConfigGeneralBase(parent, name)
{
	updateValues();
}

void ConfigGeneral::updateValues()
{
	QString fileName = Config().logFile;
	if( fileName == "/var/log/messages" )
		mRadio1->setChecked( true );
	else
		if( fileName == "/var/log/everything/current" )
			mRadio2->setChecked( true );
	else
	{
		mRadio3->setChecked( true );
		customFile->setURL( fileName );
	}
	
	mUpdateInterval->setValue( Config().updateInterval/1000 );
	mPopupsLifetime->setValue( Config().popupsLifetime/1000 );
	
	if( Config().groupMessages )
		groupMessagesBox->setChecked( true );
	
	resetPopupsTimersBox->setChecked( Config().resetPopupsTimers );
	maxMessagesBox->setValue( Config().maxMessages );
}

void ConfigGeneral::updateConfig()
{
	QString str;
	if( mRadio1->isChecked() )
		str = "/var/log/messages";
	else
	if( mRadio2->isChecked() )
		str = "/var/log/everything/current";
	else
		str = customFile->url();
	Config().logFile = str;
	
	Config().updateInterval = mUpdateInterval->value()*1000;
	Config().popupsLifetime = mPopupsLifetime->value()*1000;

	Config().groupMessages = groupMessagesBox->isChecked();
	Config().resetPopupsTimers = resetPopupsTimersBox->isChecked();
	Config().maxMessages = maxMessagesBox->value();
}
#include "configgeneral.moc"
