/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl							   *
 *   k.zawadyl@gmail.com												   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CONFIGTHEMES_H
#define CONFIGTHEMES_H

#include "configthemesbase.h"
#include "popuptheme.h"

#include <qptrlist.h>

#include <kio/job.h>

class ConfigThemes: public Form1
{
Q_OBJECT
public:
	ConfigThemes(QWidget *parent = 0, const char *name = 0);
	void			updateValues();
	void			updateConfig();
	
public slots:
	void			showThemeInfo(int);
	void			loadTheme();
	void			scanForThemes();
	void			deleteTheme();

private slots:
	void 			deleteThemeFinished( KIO::Job *j );
		
private:
	QPtrList<PopupTheme> themesList;	
};

#endif
