/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl                               *
 *   k.zawadyl@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "configure.h"
#include "triggeredit.h"

#include "configgeneral.h"
#include "configtriggers.h"
#include "configadvanced.h"
#include "configthemes.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qframe.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kglobal.h>

/**
 * @brief Constructor
 * 
 * Sets the configure window defaults
 * 
 * @param parent pointer to MetaMonitor
 * @param name window object name
 */
Configure::Configure( QWidget *parent, const char *name )
	: KDialogBase(IconList, i18n("Configure"), Ok|Apply|Cancel, Ok, parent, name)
{
	QVBoxLayout *frameLayout;
	QFrame *frame;
	
	frame = addPage(i18n("General"), i18n("Basic configuration"),
	                        KGlobal::iconLoader()->loadIcon("metamonitor",KIcon::Panel,0,false) );
	frameLayout = new QVBoxLayout( frame, 0, 0 );
	mConfigGeneral = new ConfigGeneral(frame);
	frameLayout->addWidget(mConfigGeneral);
	
	frame = addPage(i18n("Triggers"), i18n("Triggers configuration"),
	                KGlobal::iconLoader()->loadIcon("find",KIcon::Panel,0,false) );
	frameLayout = new QVBoxLayout( frame, 0, 0 );
	mConfigTriggers = new ConfigTriggers(frame);
	frameLayout->addWidget(mConfigTriggers);
	
	frame = addPage(i18n("Themes"), i18n("Themes configuration"),
	                KGlobal::iconLoader()->loadIcon("colorize",KIcon::Panel,0,false) );
	frameLayout = new QVBoxLayout( frame, 0, 0 );
	mConfigThemes = new ConfigThemes(frame);
	frameLayout->addWidget(mConfigThemes);
	
	frame = addPage(i18n("Advanced"), i18n("Advanced configuration"),
	                KGlobal::iconLoader()->loadIcon("configure",KIcon::Panel,0,false) );
	frameLayout = new QVBoxLayout( frame, 0, 0 );
	mConfigAdvanced = new ConfigAdvanced(frame);
	frameLayout->addWidget(mConfigAdvanced);
}

/**
 * @brief Descructor
 */
Configure::~Configure()
{
}

void Configure::updateDialog()
{
	mConfigGeneral->updateValues();
	mConfigTriggers->updateValues();
	mConfigAdvanced->updateValues();
	mConfigThemes->updateValues();
}

void Configure::updateConfig()
{
	mConfigGeneral->updateConfig();
	mConfigTriggers->updateConfig();
	mConfigAdvanced->updateConfig();
	mConfigThemes->updateConfig();
}
#include "configure.moc"
