/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl							   *
 *   k.zawadyl@gmail.com												   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MCONFIGURATION_H
#define MCONFIGURATION_H

#include "mtrigger.h"
#include "popuptheme.h"

#include <qstring.h>
#include <qptrlist.h>
#include <kio/job.h>

class KConfig;
class MetaMonitor;

/**
	@author Krzysztof Zawadyl <thanek@o2.pl>
*/
class MConfiguration{

public:
	enum LogDaemonType { NoLog = 0,	MetaLog = 1, SysLog = 2	};
	
	void				read();
	void				write();
	void				scanForThemes();
	KIO::Job*			deleteTheme( QString name );
	PopupTheme* 		getTheme( QString name );
	
	int					updateInterval;
	int					popupsLifetime;
	QString				logFile;
	QString				customRegExp;
	LogDaemonType		defaultRegExp;
	bool				groupMessages;
	bool				pausePopups;
	int					maxMessages;
	bool				soundEnabled;
	QString				soundPlayerCmd;
	bool				resetPopupsTimers;
	QPtrList<MTrigger>  triggerList;
	bool				themesEnabled;
	PopupTheme * 		currentTheme;
	QString				currentThemeName;
	QPtrList<PopupTheme> themesList;
	MetaMonitor *		mm;

private:
    MConfiguration();
	MConfiguration(const MConfiguration&);
    ~MConfiguration();

	void				writeTriggers( KConfig *cfg );
	void				loadTriggers( KConfig *cfg );
	
	friend MConfiguration& Config();
};

MConfiguration& Config();
#endif
