/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl                               *
 *   k.zawadyl@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "message.h"

#include <qdatetime.h>

#include <kglobal.h>
#include <klocale.h>
/**
 * @brief Constructor
 * 
 * @param from Message's sender name
 * @param txt Message's text
 */
Message::Message( const QString &from, const QString &txt ) : mColor()
{
	mFrom = from;
	mText = txt;
	QDateTime d = QDateTime::currentDateTime();
	mTime = d.toString( Qt::TextDate );
	mPopup = true;
	mIcon = "metamonitor";
	mLifetime = -1;
	mCommand = QString::null;
}

/**
 * @brief Destructor
 */
Message::~Message()
{
	if( mColor )
		delete mColor;
}

/**
 * @brief Returns the sender's name
 * @return sender's name
 */
QString Message::getFrom()
{
	return mFrom;
}

/**
 * @brief Returns the message text
 * @return the message text
 */
QString Message::getText()
{
	return mText;
}

/**
 * @brief Returns the time of message
 * @return Time of message
 */
QString Message::getTime()
{
	return mTime;
}

/**
 * @brief Sets the time of message
 * @param d Date's string
 */
void Message::setDate( const QString &d )
{
	mTime = d;
}

QString Message::getCommand()
{
	return mCommand;
}

QString Message::getButtonsLabel()
{
	return mButtonsLabel;
}

void Message::setCommand( QString cmd, QString button )
{
	mCommand = cmd;
	mButtonsLabel = button;
}

void Message::setTextColor( QColor c )
{
	mColor = new QColor(c);
}

QColor * Message::getTextColor()
{
	if( mColor && mColor->isValid() )
		return mColor;
	
	return 0;
}