//
// C++ Implementation: mfile
//
// Description: This is the modified code of klogtail.cpp from klogwatch-1.8.3 (GPL)
//
// Original author(s):
// Nick Battle <nick.battle@freeuk.com> - Original author
// John Stamp <jstamp@users.sourceforge.net> - Enhancements in 1.7 and 1.8
//
// Added to MetaMonitor by Krzysztof Zawadyl <kzawadyl@gmail.com>
//

namespace std 
{
	extern "C" 
	{
		int open(const char *pathname, int flags);
		int close(int fd);
	}
}

#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>

#include "mfile.h"

#include <qobject.h>

MFile::MFile(QString fname) : QObject()
{
	path = fname;
	fd = 0;
	inode = 0;
	size = 0;
	mfopen = false;
	error = "";
}


MFile::~MFile()
{
	close();
}

bool MFile::open()
{
	if( !statFile() )
	{
		error = strerror(errno);
		return false;	
	}
	
	error = "";
	mfopen = true;
	return true;
}

void MFile::close()
{
	if( mfopen || fd )
		std::close( fd );
}

void MFile::goToEnd()
{
	fdatasync( fd );
	lseek(fd, 0, SEEK_END);
}

QString MFile::getLogLine()
{
	QString s;
	int retries = 3;
	
	while (true)
	{
		char c;
		int n;
		
		n = read(fd, &c, 1);
		
		if (n < 0)
		{
			error = strerror( errno );
			return 0;
		}
		
		if (n == 0)
		{
			if (s.isEmpty())
			{
				if (statFile())
				{
		            // We want to continue to examine the new log file
					continue;
				}
				
				return 0;    // Nothing new
			}
			
			if (retries--)
			{
				//qDebug("Read partial line?\n");
				sleep(1);
			}
			else
			{
				//qDebug("Returning partial line\n");
				s.append('\n');
				return s;
			}
		}
		else if (c == '\n')
		{
			return s;
		}
		else
		{
			s.append(c);
		}
	}
}

bool MFile::statFile(void)
{
	struct stat sb;
	
	if( stat( path.latin1(), &sb ) < 0)
	{
		return false;
	}
	else
	{
		if( (sb.st_ino != inode) || (sb.st_size < size) )
		{
			if( fd )
				std::close(fd);
			
			const char *p = path.latin1();
			fd = std::open(p, O_RDONLY);

			if( fd == -1 )
			{
				error = strerror(errno);
				
				if( mfopen )
					emit lost();
				
				return false;
			}
			
			
			//qDebug("Tailing file <%s>\n", p);
			
			inode = sb.st_ino;
			size = sb.st_size;
			
			//qDebug("New inode %d, size = %d\n", (int)inode, (int)size);
			
			emit reOpened();
			return true;
		}
		
		size = sb.st_size;
		
		return false;   // Same file
	}
}

