/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl                               *
 *   k.zawadyl@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "mtrigger.h"
#include "metamonitor.h"

#include <qregexp.h>
#include <qstringlist.h>

#include <kiconloader.h>
#include <klocale.h>

MTrigger::MTrigger() : QObject()
{
	// default event settings
	checkSenderName 	= true;
	senderName = QString::null;
	checkMessageText 	= false;
	messageText = QString::null;
	
	// default action settings
	setPopupsTextColor 	= false;
	setPopupsLifeTime 	= false;
	setPopupsFont 		= false;
	setCustomIcon		= false;
	dontShowPopups 		= false;
	runCommand			= false;
	
	customIcon			= QString::null;
	soundFile			= QString::null;
	command				= QString::null;
	buttonsLabel		= QString::null;
	popupsLifeTime 		= Config().popupsLifetime;
}


MTrigger::~MTrigger()
{
}

QString MTrigger::getSenderName()
{
	if( checkSenderName && senderName && !senderName.isEmpty() )
		return senderName;
	
	return QString::null;
}

QString MTrigger::getMessageText()
{
	if( checkMessageText && messageText && !messageText.isEmpty() )
		return messageText;
	
	return QString::null;
}

QString MTrigger::title()
{
	QString sn = getSenderName();
	if( !sn )
		sn = i18n( "any" );
	QString mt = getMessageText();
	if( !mt )
		mt = i18n( "any " );
	return i18n( "Sender: %1 Message: %2" ).arg( sn, mt );
}

QPixmap MTrigger::getPixmap()
{
	if( !setCustomIcon || !customIcon || customIcon == "" || customIcon.isEmpty() )
		return MainBarIcon( "metamonitor" );
	
	return MainBarIcon( customIcon );
}

bool MTrigger::check( Message *m )
{
	bool checkResult = true;
	
	if( checkSenderName )
	{
		switch( senderCompType )
		{
			case ExactComp:
				if( senderName != m->getFrom() )
					checkResult = false;
				break;
			
			case ContainComp:
				if( !m->getFrom().contains( senderName ) )
					checkResult = false;
				break;
			
			case RegExp:
				QRegExp rx( senderName );
				if( !rx.exactMatch( m->getFrom() ) )
			    	checkResult = false;
				break;
		}
	}
	
	if( checkMessageText )
	{
		switch( messageCompType )
		{
			case ExactComp:
				if( messageText != m->getText() )
					checkResult = false;
				break;
			
			case ContainComp:
				if( !m->getText().contains( messageText ) )
					checkResult = false;
				break;
			
			case RegExp:
				QRegExp rx( messageText );
				if( !rx.exactMatch( m->getText() ) )
					checkResult = false;
				break;
		}
	}
	
	return checkResult;
}

void MTrigger::perform( Message *m )
{
	m->setShowPopup( !dontShowPopups );
	
	if( setPopupsTextColor )
		m->setTextColor( popupsTextColor );
	
	if( setPopupsLifeTime )
		m->setLifetime( popupsLifeTime );
	
	if( setPopupsFont )
		m->setFont( popupsFont );
	
	if( setCustomIcon )
		m->setIcon( customIcon );
	
	if( playSound )
		playSoundFile();
	
	if( runCommand )
		m->setCommand( command, buttonsLabel );
}

void MTrigger::playSoundFile()
{
	if( !playSound || !soundFile || soundFile.isEmpty() )
		return;
	
	Config().mm->playSoundFile(soundFile);
}
#include "mtrigger.moc"
