/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl                               *
 *   k.zawadyl@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef POPUP_H
#define POPUP_H

#include "popupmessage.h"
#include "popuptheme.h"

#include <qpixmap.h>
#include <qbitmap.h>
#include <qimage.h>
#include <qlayout.h>

#include <kpassivepopup.h>
#include <kpixmap.h>
#include <krootpixmap.h>

class QPaintEvent;
class QColor;
class QBoxLayout;
class KActiveLabel;
class Message;

/**
 * @class Popup
 * @brief Generates a KPassivePopup with rounded corners
 * 
 * @author Krzysztof Zawadyl
 */
class Popup : public KPassivePopup
{
Q_OBJECT

public:
	Popup( QWidget *parent );
	~Popup();
	
	static Popup * 	message( QWidget *parent, Message *m );
	
public slots:
	void			removeMessage(PopupMessage *pm);
	void  			addMessage( Message *m, int max, bool resetTimers );
	void			updateBg();
	void			render(PopupTheme *theme);
	void 			showPopup();

public:
	int				getMargin() { return topLayout ? topLayout->margin() : 15; };
	QString			getTextColor(Message *m=0);
	QString			getSenderColor(Message *m=0);
	QString			getBody();
	
public:
	QPixmap 		mIcon;
	QPixmap 		sshIcon;
	QPixmap 		kernelIcon;
	
	QPixmap 		m_screenshot;
	QPixmap 		m_pixmap;
	QImage			m_image;

protected:
	void 			paintEvent( QPaintEvent *e );
	virtual void	positionSelf();
	
private:
	WId 			window;
	QBoxLayout *	topLayout;
	QTimer *		hideTimer;
	QColor			bgColor;
	QPtrList<PopupMessage>	messageQueue;
	QBitmap 		m_mask;
};

#endif
