/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl                               *
 *   k.zawadyl@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "triggeredit.h"

#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qcheckbox.h>

#include <klineedit.h>
#include <knuminput.h>
#include <kcolorbutton.h>
#include <kfontrequester.h>
#include <kicondialog.h>
#include <kaudioplayer.h>
#include <kurlrequester.h>
#include <kmessagebox.h>
#include <klocale.h>

TriggerEdit::TriggerEdit(QWidget *parent, MTrigger *mt ) : TriggerEditBase(parent, "TriggerEdit")
{
	trigger = mt;
	init();
	connect( playSoundButton, SIGNAL( clicked() ), this, SLOT( playSound() ) );
	connect( dontPopupCheckBox, SIGNAL( toggled(bool)), this, SLOT( setPopupProperties(bool) ) );
}

TriggerEdit::~ TriggerEdit()
{
}

void TriggerEdit::init()
{
	if( !trigger )
		return;
	
	// Event
	if( trigger->getSenderName() )
	{
		senderButtonGroup->setChecked( true );
		senderNameEdit->setText( trigger->senderName );
		senderCompTypeCombo->setCurrentItem( trigger->senderCompType );
	}
	else
		senderButtonGroup->setChecked( false );
	
	if( trigger->getMessageText() )
	{
		messageTextButtonGroup->setChecked( true );
		messageTextEdit->setText( trigger->messageText );
		messageTextCompTypeCombo->setCurrentItem( trigger->messageCompType );
	}
	else
		messageTextButtonGroup->setChecked( false );
	
	// Action
	dontPopupCheckBox->setChecked( trigger->dontShowPopups );
	
	setFontColorCheckBox->setChecked( trigger->setPopupsTextColor );
	changeFontCheckBox->setChecked( trigger->setPopupsFont );
	popupsLifeTimeCheckBox->setChecked( trigger->setPopupsLifeTime );
	setCustomIconCheckBox->setChecked( trigger->setCustomIcon );
	playSoundCheckBox->setChecked( trigger->playSound );
	runCommandCheckBox->setChecked( trigger->runCommand );
	
	popupsLifeTimeBox->setValue( trigger->popupsLifeTime/1000 );
	fontColorChooser->setColor( trigger->popupsTextColor );
	fontRequester->setFont( trigger->popupsFont );
	customIconButton->setIcon( trigger->customIcon );
	soundFileRequester->setURL( trigger->soundFile );
	commandEdit->setText( trigger->command );
	cmdButtonsLabelEdit->setText( trigger->buttonsLabel );
}

void TriggerEdit::setTrigger(MTrigger *mt)
{
	// event
	mt->checkSenderName = senderButtonGroup->isChecked();
	if( senderButtonGroup->isChecked() && !senderNameEdit->text().isEmpty() )
		mt->senderName = senderNameEdit->text();
	else
		mt->senderName = "";
	mt->senderCompType = (MTrigger::CompType)senderCompTypeCombo->currentItem();
	
	mt->checkMessageText = messageTextButtonGroup->isChecked();
	if( messageTextButtonGroup->isChecked() && !messageTextEdit->text().isEmpty() )
		mt->messageText = messageTextEdit->text();
	else
		mt->messageText = "";
	mt->messageCompType = (MTrigger::CompType)messageTextCompTypeCombo->currentItem();
	
	// action
	mt->dontShowPopups = dontPopupCheckBox->isChecked();
	mt->setPopupsLifeTime = popupsLifeTimeCheckBox->isChecked();
	mt->setPopupsFont = changeFontCheckBox->isChecked();
	mt->setPopupsTextColor = setFontColorCheckBox->isChecked();
	mt->setCustomIcon = setCustomIconCheckBox->isChecked();
	mt->playSound = playSoundCheckBox->isChecked();
	mt->runCommand = runCommandCheckBox->isChecked();
	
	mt->popupsLifeTime = (int)popupsLifeTimeBox->value()*1000;
	mt->popupsFont = fontRequester->font();
	mt->popupsTextColor = fontColorChooser->color();
	mt->customIcon = customIconButton->icon();
	mt->soundFile = soundFileRequester->url();
	mt->command = commandEdit->text();
	mt->buttonsLabel = cmdButtonsLabelEdit->text();
}

void TriggerEdit::playSound()
{
	bool playSound = trigger->playSound;
	QString soundFile = trigger->soundFile;
	
	QString url = soundFileRequester->url();
	if( url.isEmpty() )
	{
		KMessageBox::error( this, i18n("You have to select a sound file"), i18n("MetaMonitor") );
		return;
	}
	
	trigger->playSound = true;
	trigger->soundFile = url;
	
	trigger->playSoundFile();

	trigger->playSound = playSound;
	trigger->soundFile = soundFile;
}

void TriggerEdit::setPopupProperties( bool chk )
{
	setCustomIconCheckBox->setEnabled( !chk );
	changeFontCheckBox->setEnabled( !chk );
	setFontColorCheckBox->setEnabled( !chk );
	popupsLifeTimeCheckBox->setEnabled( !chk );
	
	customIconButton->setEnabled( !chk & setCustomIconCheckBox->isChecked() );
	fontRequester->setEnabled( !chk & changeFontCheckBox->isChecked() );
	fontColorChooser->setEnabled( !chk & setFontColorCheckBox->isChecked() );
	popupsLifeTimeBox->setEnabled( !chk & popupsLifeTimeCheckBox->isChecked() );
}
#include "triggeredit.moc"
