/***************************************************************************
 *   Copyright (C) 2004 by Dominik Seichter                                *
 *   domseichter@web.de                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "preferencesdlg.h"

#include <klocale.h>
#include <knuminput.h>

#include <qlayout.h>
#include <qtooltip.h>

#define SEC_MS 1000

PreferencesDlg::PreferencesDlg(QWidget *parent, const char *name)
    : KDialogBase( KDialogBase::Plain, i18n("KCpuSpeed Preferences"),
        KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, parent,name)
{
    QVBoxLayout* box = new QVBoxLayout( plainPage() );
    
    m_spinFrequency = new KIntNumInput( plainPage(), "m_spinFrequency" );
    m_spinFrequency->setLabel( i18n("&Update Frequency:"), Qt::AlignLeft | Qt::AlignVCenter );
    // Range from 10seconds to 10 minutes
    m_spinFrequency->setRange( 10, 60*10, 1, false );
    m_spinFrequency->setSuffix( i18n("sec") );
    
    box->addWidget( m_spinFrequency );
    
    enableButtonSeparator( true );
    
    QToolTip::add( m_spinFrequency, i18n("The frequency at which KCpuSpeed updates the displayed cpu speed. 30 seconds is a good default value for most cases.") );
}


PreferencesDlg::~PreferencesDlg()
{
}

void PreferencesDlg::setUpdateFrequency( const unsigned int f )
{
    m_spinFrequency->setValue( f / SEC_MS );
}

unsigned int PreferencesDlg::updateFrequency() const
{
    return m_spinFrequency->value() * SEC_MS;
}

#include "preferencesdlg.moc"
