TEMPLATE = subdirs

VERSION = 0.43

MIN_QT_VERSION = 4.3.2

!contains(QT_VERSION, $$MIN_QT_VERSION){
  warning("You need Qt version $$MIN_QT_VERSION or higher for full support")
}

CONFIG *= warn_on \
          qt \
          thread \
          ordered \
          debug_and_release


SUBDIRS += src/lib \
           src

DESTDIR = ./

MAKEFILE = makefile

# these makefile target rules will give the option to build the debug and
# release from outside the src/ folder (need Qt 4.3.2 or higher for this)
release-install.target = release-install
release-install.commands = $$escape_expand("cd src/lib/ && $(MAKE) release-install\n\tcd src/ && $(MAKE) release-install")
release-install.depends = "src/lib\/$(MAKEFILE) src\/$(MAKEFILE)"

debug-install.target = debug-install
debug-install.commands = $$escape_expand("cd src/lib/ && $(MAKE) debug-install\n\tcd src/ && $(MAKE) debug-install")
debug-install.depends = "src/lib\/$(MAKEFILE) src\/$(MAKEFILE)"

QMAKE_EXTRA_TARGETS += release-install \
                       debug-install
