/* This file is part of the KDE project
   Copyright (C) 2006 Tom Albers <tomalbers@kde.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <qfile.h>

#include <kdebug.h>
#include <klocale.h>
#include <kprocess.h>

#include "ktufetch.h"

KTUFetch::KTUFetch( QObject * parent )
  : QObject(parent,"KTUFetch")
{
}

KTUFetch::~KTUFetch()
{
}

bool KTUFetch::fetch(const QString& src, const QString& dst,
                     QString& output)
{
    bool exe = executeCommand( QString("svn cat %1 > %2")
            .arg(KProcess::quote(src),KProcess::quote(dst)));
    output = m_output;

    if (!QFile::exists(dst))
        return false;

    return exe;
}

bool KTUFetch::diff(const QString& src, const QString& orig,
                    QString& output)
{
    bool exe = executeCommand( QString("svn cat %1 | diff -u - %2")
            .arg(KProcess::quote(src),KProcess::quote(orig)));
    output = m_output;
    return exe;
}

bool KTUFetch::fetchDir(const QString& src, const QString& dst,
                        QString& output)
{
    bool exe = executeCommand(QString("svn co %1 %2")
            .arg(KProcess::quote(src),KProcess::quote(dst)));
    output = m_output;
    return exe;
}

bool KTUFetch::fetchDirContents(const QString& src, const QString& dst,
                                QString& output)
{
    bool exe = executeCommand(QString("svn ls -R %1 > %2")
            .arg(KProcess::quote(src),KProcess::quote(dst)));
    output = m_output;
    return exe;
}

/* ****************************************************************************
 * Below code is largely copied from KBabel

   Copyright (C) 2002-2003 by Marco Wegner <mail@marcowegner.de>
   Copyright (C) 2005, 2006 by Nicolas GOUTTE <goutte@kde.org>
   **************************************************************************** */

bool KTUFetch::executeCommand(const QString& src)
{
    if ( src.isEmpty( ) )
        return false;
    kdDebug() << "Preparing KProcess for: " << src << endl;

    // Create a new shell process
    KProcess* p = new KProcess;
    p->setUseShell( true, "/bin/sh" );
    *p << src;

    connect( p, SIGNAL( receivedStdout( KProcess*, char*, int ) ),
             this, SLOT ( slotProcessStderr( KProcess*, char*, int ) ) );
    connect( p, SIGNAL( receivedStderr( KProcess*, char*, int ) ),
        this, SLOT ( slotProcessStderr( KProcess*, char*, int ) ) );

    if ( !p->start( KProcess::Block, KProcess::Communication( KProcess::AllOutput ) ) )
    {
        delete p;
        m_output = i18n("Process could not be started.");
        return false;
    }

    if (p->exitStatus( ))
    {
        delete p;
        return false;
    } else {
        delete p;
        return true;
    }
}

void KTUFetch::slotProcessStderr( KProcess*, char * buffer, int len )
{
    m_output += QString::fromLocal8Bit( buffer, len );
}

#include "ktufetch.moc"

