/* This file is part of the KDE project

   Copyright (C) 2006 Tom Albers <tomalbers@kde.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef KTUFETCH_H
#define KTUFETCH_H

class KProcess;

/**
 * @class KTUFetch
 * This class is responsible forgetting files from svn and
 * placing it somewhere
 * @author Tom Albers <tomalbers@kde.nl>
 */
class KTUFetch : public QObject
{
  Q_OBJECT

  public:
    /**
     * Contructor
     * @param parent the parent
     */
      KTUFetch(  QObject * parent );

    /**
     * Destructor
     */
    ~KTUFetch();

    /**
     * With this function you can fetch a file and place it somewhere.
     * @param src the full url to the file to fetch
     * @param dest the full url to place that file
     */
    bool fetch(const QString& src, const QString& dest, QString& output);

    /**
     * With this function you can get a diff between the src and orig
     * Connect to finished(QString) to get the diff.
     * @param src the full url to the modified file
     * @param orig the full url to the original file
     */
    bool diff(const QString& src, const QString& orig, QString& output);

    /**
     * With this function you can fetch a dir and place it somewhere.
     * @param src the full url to the dir to fetch
     * @param dest the full url to place that dir
     */
    bool fetchDir(const QString& src, const QString& dest, QString& output);

    /**
     * With this function you can fetch a directory overview and place it
     * somewhere.
     * @param src the full url to the dir to fetch the content from
     * @param dest the full url to place that dir
     */
    bool fetchDirContents(const QString& src, const QString& dest, QString& output);

  private:
    bool executeCommand(const QString&);
    QString     m_output;

  private slots:
    void slotProcessStderr( KProcess*, char * buffer, int len );
};

#endif // KTUFETCH_H

