/* This file is part of the KDE project

   Copyright (C) 2006 Tom Albers <tomalbers@kde.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef KTUFIRSTRUNWIDGET_H
#define KTUFIRSTRUNWIDGET_H

#include <kdialogbase.h>

class KProgress;

/**
 * @class KTUFirstRunWidget
 * This is het main class to setup KTU, it is shown on the first run
 * and fetches the applications and languages.
 * @author Tom Albers <tomalbers@kde.nl>
 */
class KTUFirstRunWidget : public KDialogBase
{
  Q_OBJECT

    public:
      /**
      * Contructor
      */
        KTUFirstRunWidget(QWidget* parent);

      /**
      * Destructor
      */
      ~KTUFirstRunWidget();

    protected slots:
        void slotOk();

    private:
        void languagesFinished();
        void appsFinished();

        QMap<QString,QString>   m_languages;
        QComboBox*              m_selectLang;
        QPushButton*            m_fetchButton;
        QLabel*                 m_labelLang;
        QLabel*                 m_labelApp;
        QTime*                  m_timer;
        QTimer*                 m_ticking;
        KProgress*               m_progress;
        int                     m_ready;

    private slots:
        void slotFetchedClicked();
        void slotUpdateProgress();
};

#endif // KTUFIRSTRUNWIDGET_H

