/* This file is part of the KDE project

   Copyright (C) 2006 Tom Albers <tomalbers@kde.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef KTUINCLUDES_H
#define KTUINCLUDES_H

/**
 * @class KTUIncludes
 * This is a collection of some static methods
 * @author Tom Albers <tomalbers@kde.nl>
 */
class KTUIncludes
{
    public:
      /**
       * This returns a list of the current languages
       * @param list returns a QMap<short,language> where language
       *             is localized, and short the shortcode.
       * @param langSorted returns a stringlist which is on sorted, so it
       *                   is ready to insert en masse to a combobox for example
       * @param defaultLangIndex retuns the number of the item in langSorted
       *                         which is the default language.
       */
      static void getLanguageList(QMap<QString,QString>& list,
                                    QStringList& langSorted,
                                    int& defaultLangIndex);
      /**
       * Converts a full text language to the shortcode. In fact it will
       * search the values of @p map which is a map <short,language> force
       * @p lang, and returns the key.
       */
      static QString findShortCode(QMap<QString,QString>& map,
                                  const QString& lang);

      /**
       * Returns the right branch to get the app from. Usefull when user has set
       * KTU to 'automatic'.
       * @param branch the branch
       * @param name the application name
       * @return the resolved branch.
       */
      static int getRealBranch(int branch, const QString& name);

      /**
       * Checks for the svn and msgfmt binaries, shows a dialog when missing
       * and aborts KTU.
       */
      static void checkRequirements();
};

#endif // KTUINCLUDES_H

