/* This file is part of the KDE project
   Copyright (C) 2006 Tom Albers <tomalbers@kde.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <qregexp.h>

#include <kdebug.h>
#include <kprocess.h>

#include <ktustats.h>

KTUStats::KTUStats(QObject * parent)
  : QObject(parent,"KTUStats")
{
}

KTUStats::~KTUStats()
{
}

/* ****************************************************************************
 * Some of the code below is copied from KBabel

   Copyright (C) 2002-2003 by Marco Wegner <mail@marcowegner.de>
   Copyright (C) 2005, 2006 by Nicolas GOUTTE <goutte@kde.org>
   **************************************************************************** */

void KTUStats::getStats(const QString& src, int& translated,
                              int& untranslated )
{
    if ( src.isEmpty( ) ) return;

    QString command = QString("LC_ALL=C LANGUAGE=en "
            "msgfmt --statistics %1").arg(KProcess::quote(src));

    kdDebug() << "Preparing KProcess for: " << command << endl;

    // Create a new shell process
    KProcess* p = new KProcess;
    p->setUseShell( true, "/bin/sh" );
    *p << command;

    connect( p, SIGNAL( receivedStderr( KProcess*, char*, int ) ),
        this, SLOT ( slotProcessStderr( KProcess*, char*, int ) ) );

    if ( !p->start( KProcess::Block, KProcess::Communication( KProcess::AllOutput ) ) )
        kdError() << "Process could not be started." << endl;

    if ( p->exitStatus( ) )
        kdDebug() << "Exited with error " <<  p->exitStatus( ) << endl;
    else
    {
        uint fuzzy=0;
        translated=0;untranslated=0;

        QRegExp re("^([0-9]+) translated message",false);
        if (re.search(m_result) >= 0)
            translated = re.cap(1).toUInt();

        re.setPattern(" ([0-9]+) fuzzy translation");
        if (re.search(m_result) >= 0)
            fuzzy = re.cap(1).toUInt();

        re.setPattern(" ([0-9]+) untranslated message");
        if (re.search(m_result) >= 0)
            untranslated = re.cap(1).toUInt();

        untranslated += fuzzy;
    }

    delete p;
}

void KTUStats::slotProcessStderr( KProcess*, char * buffer, int len )
{
    m_result += QString::fromLocal8Bit( buffer, len );
}

#include "ktustats.moc"

