/* This file is part of the KDE project

   Copyright (C) 2006 Tom Albers <tomalbers@kde.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef KTUSTATS_H
#define KTUSTATS_H

class KProcess;

/**
 * @class KTUStats
 * This class is responsible for reporting stats on a file. Pass the filename
 * of the file to the constructor, and a signal gets emitted when done.
 *
 * @author Tom Albers <tomalbers@kde.nl>
 */
class KTUStats : public QObject
{
    Q_OBJECT

    public:
        /**
        * Contructor. It will emit finished, with the stats as soon as the
        * stats are available.
        * @param parent the parent
        */
        KTUStats(QObject * parent);

        /**
        * Destructor
        */
        ~KTUStats();

        /**
         * Get the stats.
         * @param file the complete filename
         * @param trans will be filled with the amount of translated messages
         * @param untrans will be filled with the amount of untranslated
         * messages, including the fuzzies.
         */
        void getStats(const QString& file, int& trans, int& untrans );

    private:
        QString     m_result;

    private slots:
        void slotProcessStderr( KProcess*, char * buffer, int len );
};

#endif // KTUSTATS_H

