/* This file is part of the KDE project

   Copyright (C) 2006 Tom Albers <tomalbers@kde.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef KTUWIDGET_H
#define KTUWIDGET_H

#include <kmainwindow.h>

class QListViewItem;
class QPushButton;

class KDirWatch;
class KListView;
class KProcess;
class KSelectAction;

class KTUDB;
class KTUStatItem;
class KTUWidgetPriv;

/**
 * @class KTUWidget
 * This is het main class
 * @author Tom Albers <tomalbers@kde.nl>
 */
class KTUWidget : public KMainWindow
{
  Q_OBJECT

  public:
    /**
     * Contructor
     */
      KTUWidget();

    /**
     * Destructor
     */
    ~KTUWidget();

    /**
     * convenience to get to the db.
     */
    static KTUWidget* i();

    /**
     * convenience to get to the db.
     */
    KTUDB* dbI();

    private:
        void getTeamnames(bool force=false);
        void readTeamnames();
        void getApplications(bool force=false);
        void readApplications();
        QString currentLanguage();
        void checkRequirements();
        void getInstalledApplications();
        void installAllApps();
        void installAllAppsInModule(const QString& module);
        void removeInstallation(KTUStatItem* statItem);

        static KTUWidget*                       m_instance;
        KTUWidgetPriv*                          d;

        QString                                 m_edit;
        QString                                 m_dataDir;
        QString                                 m_currentLang;
        int                                     m_currentBranch;
        QWidget*                                m_box;

        QComboBox*                              m_mod;
        QComboBox*                              m_app;
        QPushButton*                            m_fetch;
        KListView*                              m_table;
        KSelectAction*                          m_typeMenuList;
        KSelectAction*                          m_langMenuList;
        KAction*                                m_delete;
        KDirWatch*                              m_dir;
        QMap<QString, QString>                  m_languages;
        QMap< int,QString >                     m_modcomboitems;

        /* all applications that exist*/
        QMap< int,QPair<QString,QString> >      m_appcomboitems;

        /* all applications currently in the pulldown */
        QMap< int,QPair<QString,QString> >      m_appcomboitemsshown;

        /* All statitems;*/
        QValueList< KTUStatItem* >               m_statItems;

        /* All statitems visible;*/
        QValueList< KTUStatItem* >               m_statItemsVisible;

        /* Stats needed */
        QValueList< KTUStatItem* >               m_needStat;

    protected:
        virtual void timerEvent( QTimerEvent* );

    private slots:
        void slotGetTeamnames();
        void slotGetApplications();
        void slotUpdateTeamnames();
        void slotUpdateApplications();
        void slotPullDownChanged();
        void slotEnableDeleteAllTranslations();
        void slotDeleteAllTranslations();
        void slotFetchClicked();
        void slotTableContext(QListViewItem*, const QPoint&);
        void slotRemoveItem(KTUStatItem* statItem);
        void slotChangeLang();
        void slotTypeChanged(int);
        void slotStatusbarBusy(const QString&);
        void slotStatusbarReady();
        void slotFinished(KProcess *p);
        void slot_exit();
};

#endif // KTUSWIDGET_H

