/* This file is part of the KDE project
   Copyright (C) 2006 Tom Albers <tomalbers@kde.nl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <stdio.h>

#include <qfile.h>

#include <kuniqueapplication.h>
#include <kstandarddirs.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kconfig.h>

#include "ktuwidget.h"
#include "ktufirstrunwidget.h"
#include "likeback.h"

int main( int argc, char *argv[] )
{
    KAboutData aboutData( "ktu",
                          I18N_NOOP("KTU"),
                          "0.0.3",
                          I18N_NOOP("Fetch translations straight from KDE"),
                          KAboutData::License_GPL,
                          "(c) 2006, Tom Albers" );

    aboutData.addAuthor( "Tom Albers", I18N_NOOP("Maintainer and Author"),
                         "tomalbers@kde.nl", "http://www.omat.nl");

    KCmdLineArgs::init( argc, argv, &aboutData );

    if (!KUniqueApplication::start())
    {
        fprintf(stderr, "KTU is already running!\n");
        exit(0);
    }

    KUniqueApplication a;

    LikeBack::init(true);
    LikeBack::setServer("toma.kovoks.nl", "/send.php");
    LikeBack::setCustomLanguageMessage(i18n("Only english and dutch languages are accepted."));
    LikeBack::setAllowFeatureWishes(true);
    LikeBack::setWindowNamesListing(LikeBack::AllWindows);

    kapp->config()->setGroup("General");
    QString currentLang = kapp->config()->readEntry("Lang");
    QFile f(locateLocal("appdata","") + "unstabletemplates");
    QFile g(locateLocal("appdata","") + "teamnames");
    if ( !f.exists() || !g.exists() || currentLang.isEmpty())
    {
        KTUFirstRunWidget* t = new KTUFirstRunWidget(0);
        a.setMainWidget(t);
        t->show();
        return a.exec();
    }

    KTUWidget* ktuapp = new KTUWidget();
    a.setMainWidget(ktuapp);
    ktuapp->show();

    return a.exec();
}
