/***************************************************************************
 *   Copyright (C) 2003 by Martin Galpin                                   *
 *   martin@nemohackers.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "kuake.h"

#include <qwidget.h>
#include <qwidgetstack.h>
#include <qevent.h>
#include <qtoolbutton.h>
#include <knuminput.h>
#include <qapplication.h>

#include <kwin.h>
#include <kwinmodule.h>
#include <kurl.h>
#include <klibloader.h>
#include <klocale.h>
#include <kaboutapplication.h>
#include <kpopupmenu.h>
#include <klocale.h>
#include <kshortcut.h>
#include <kaction.h>
#include <kstdaccel.h>
#include <kmessagebox.h>
#include <kstartupinfo.h>
#include <kconfig.h>
#include <kglobalaccel.h>
#include <kkeydialog.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <ktabwidget.h>
#include <ktabbar.h>
#include <math.h>
#include <kde_terminal_interface.h>

#include "kuakepushbutton.h"
#include "kuakecustomsize.h"


// Main constructor for this class. Embeds the KPart konsole into a KParts::MainWindow and
// initialises any varibles needed for the class.
Kuake::Kuake()
    : DCOPObject("KuakeIface"),
      KMainWindow(0, "Kuake")
    //KParts::MainWindow(0, "Kuake", WStyle_Customize|WStyle_NoBorder)
{
    QWidget* tmp = QApplication::desktop();
    screenWidth = tmp->width();
    screenHeight = tmp->height();
    setGeometry(0, 0, screenWidth, _BUTTON_SIZE);
    tabCount = 1;


    stack = new QWidgetStack(this);
    stack->hide();


//We will create a KTabWidget that will contain the kparts

    tabwidget = new KTabWidget(this);
    tabwidget->setTabReorderingEnabled(true);
    tabwidget->setAutomaticResizeTabs(true);
    tabwidget->setHoverCloseButtonDelayed(false);
    //tabwidget->setHoverCloseButton(true);
    connect( tabwidget, SIGNAL( closeRequest( QWidget* ) ), this, SLOT( removeTab( QWidget * ) ) );
    connect( tabwidget, SIGNAL( contextMenu ( const QPoint & ) ), this, SLOT(slotTabbarContextMenu(const QPoint &) ) );
    connect( tabwidget, SIGNAL( contextMenu (QWidget *, const QPoint &) ), this, SLOT(slotTabContextMenu(QWidget *, const QPoint &) ) );
    //connect( tabwidget, SIGNAL( contextMenu (QWidget *, const QPoint &) ), this, SLOT(removeTab(QWidget * ) ) );


//----------------------------------------------------------//

//2  Buttons to add and remove tabs

    QToolButton *addTabButton = new QToolButton(tabwidget);
    addTabButton->setIconSet( SmallIcon( "tab_new" ) );
    addTabButton->adjustSize();
    connect(addTabButton, SIGNAL(clicked()),this, SLOT(slotCreateKonsoleWidget()));

    tabwidget->setCornerWidget(addTabButton, Qt::TopLeft);

    removeTabButton = new QToolButton(tabwidget);
    removeTabButton->setIconSet( SmallIcon( "tab_remove" ) );
    removeTabButton->adjustSize();
    removeTabButton->setEnabled(false);
    connect(removeTabButton, SIGNAL(clicked()),this, SLOT(partDestroyed()));

    tabwidget->setCornerWidget(removeTabButton, Qt::TopRight);

/*This should bring up the frist tab with a konsole*/

    CreateKonsoleWidget();

    pbResize = new KuakePushButton(this, "resize");

    tabctx = new KPopupMenu( this );
    tabctxCloseThisTab = tabctx->insertItem(SmallIcon( "tab_remove" ), "Close this Tab", this, SLOT(ctxremoveTab() ) );
    tabctx->insertItem(SmallIcon( "tab_new" ), "Add Tab", this, SLOT(slotCreateKonsoleWidget()));
    tabctx->setItemEnabled(tabctxCloseThisTab, false);

    tabbarctx = new KPopupMenu( this );
    tabbarctxCloseTab = tabbarctx->insertItem(SmallIcon( "tab_remove" ), "Close this Tab", this, SLOT(partDestroyed()));
    tabbarctx->insertItem(SmallIcon( "tab_new" ), "Add Tab", this, SLOT(slotCreateKonsoleWidget()));
    tabbarctx->setItemEnabled(tabbarctxCloseTab, false);

    ctx = new KPopupMenu( this );
    actionCollection = new KActionCollection(this, "action");
    ctxSizeRatio = new KPopupMenu(ctx);
    ctxSizeRatio->insertItem("100%", 100);
    ctxSizeRatio->insertItem("50%", 50);
    ctxSizeRatio->insertItem("33%", 33);
    ctxSizeRatio->insertItem("25%", 25);
    ctxSizeRatio->insertItem("Custom...", 0);
    connect( ctxSizeRatio, SIGNAL( activated( int ) ), this, SLOT( setSizeRatio( int ) ) );

    ctxAlignment = new KPopupMenu(ctx);
    ctxAlignment->insertItem ("Top", 0 );
    ctxAlignment->insertItem ("Bottom", 1 );
    ctxAlignment->insertItem ("Left", 2 );
    ctxAlignment->insertItem ("Right", 3 );
    connect( ctxAlignment, SIGNAL( activated( int ) ), this, SLOT( setAlignment( int ) ) );

    ctxAnimation = new KPopupMenu(ctx);
    ctxAnimation->insertItem ("None", 1 );
    ctxAnimation->insertItem ("Slow", 100 );
    ctxAnimation->insertItem ("Medium", 50 );
    ctxAnimation->insertItem ("Fast", 10 );
    connect( ctxAnimation, SIGNAL( activated( int ) ), this, SLOT( setAnimation( int ) ) );

    ctxTabCounter = new KPopupMenu(ctx);
    ctxTabCounter->insertItem ("Normal", 1 );
    ctxTabCounter->insertItem ("Smart", 2);
    connect (ctxTabCounter, SIGNAL( activated ( int ) ), this, SLOT( setTabCounter( int ) ) );

    ctxTabAlignment = new KPopupMenu(ctx);
    ctxTabAlignment->insertItem ("Top", 1 );
    ctxTabAlignment->insertItem ("Bottom", 2);
    connect (ctxTabAlignment, SIGNAL( activated ( int ) ), this, SLOT ( setTabAlignment( int ) ) );

    ctx->insertItem("Si&ze", ctxSizeRatio);
    ctx->insertItem("&Alignment", ctxAlignment);
    ctx->insertItem("A&nimation", ctxAnimation);
    ctx->insertItem("&TabCounter", ctxTabCounter);
    ctx->insertItem("Ta&bAlignment", ctxTabAlignment);
    ctx->insertItem("Toggle key...", this, SLOT(slotToggleKeyDialog()));
    ctxToggleAutoCollapseID = ctx->insertItem("Collapse kuake when focus lost", this, SLOT(slotToggleAutoCollapse()));
    ctxToggleButtonID = ctx->insertItem("Toggle Button", this, SLOT(slotToggleButton()));
    ctxToggleStartMinimizedID = ctx->insertItem("Start minimized", this,SLOT(slotToggleStartMinimized()));

    //ctxEnableTabsID = ctx->insertItem("&Enable Tabs");
    KAction* actAbout = KStdAction::aboutApp(this, SLOT(slotAbout()), actionCollection);
    KAction* actQuit = KStdAction::quit(this, SLOT(slotQuit()), actionCollection);
    ctx->insertSeparator();
    actAbout->plug(ctx);
    actQuit->plug(ctx);

    KConfig config( "kuakerc" );

    globalAccel = new KGlobalAccel(this);
    globalAccel->insert("ToggleState", i18n("Toggle State"), i18n("Toggles the state of Kuake"), ALT+Key_AsciiTilde, 0, this, SLOT(slotToggleKey()));
    globalAccel->readSettings( &config );
    globalAccel->updateConnections();

    // Correct calls to the window manager 

    KWin::setState (winId(), NET::StaysOnTop | NET::Sticky | NET::SkipTaskbar);  
    KWin::setType(winId(), NET::Dock);
    KWin::setOnAllDesktops(winId(), true);

    

    oldActiveWindow = 0;
    kwinmodule = new KWinModule(this);
    // Added by Said LANKRI
    // When using auto mouse focus : the old window might not
    // be the one that has the focus when activating kuake
    // so be aware of any focus change

    connect(kwinmodule,SIGNAL(activeWindowChanged(WId)),
         this, SLOT(slotActiveWindowChanged(WId)));

    readConfig();

    KStartupInfoId id;
    id.initId(kapp->startupId());
    KStartupInfo::sendFinish(id);

    //minimize( true );
    //if( config.readEntry("state" ) == "true" ) expand( true );

    if (toggleStartMinimized) 
    {
        isShown=true;
        minimize(true);
    }
    else 
    {
        isShown=false;
        expand(true);
    }
    
}

Kuake::~Kuake()
{
}

void Kuake::CreateKonsoleWidget()
{
    QWidget *konsolewidget = new QWidget(this);
    KLibFactory *fact = KLibLoader::self()->factory("libkonsolepart");
    k_part = (KParts::ReadOnlyPart *) fact->create(konsolewidget);


    konsolewidgetslist.append ( new konsolewidgets( k_part->widget() ));

    

    if (!k_part) return;
    if (!fact) return;

    k_part->widget()->setFocusPolicy(QWidget::WheelFocus);
    setFocusProxy(k_part->widget());
    k_part->widget()->setFocus();
    
    TerminalInterface* terminal = static_cast<TerminalInterface*>( k_part->qt_cast( "TerminalInterface" ));


    setGeo();

    //terminal->showShellInDir("/opt/");

    connect(k_part, SIGNAL(destroyed()), this, SLOT(partDestroyed()));
    //connect(k_part, SIGNAL(receivedData(const QString&)), this, SLOT(slotCreateKonsoleWidget()));

    QString newlabel = getTabNumber();

    QString text = "Konsole: "+newlabel;
    tabwidget->addTab (konsolewidget, SmallIconSet( "konsole" ) ,text);
    tabwidget->setCurrentPage(tabwidget->count()-1);
    if( tabwidget->count() == 2 )
    {
        tabwidget->setHoverCloseButton(true);
        removeTabButton->setEnabled(true);
        tabctx->setItemEnabled(tabctxCloseThisTab, true);
        tabbarctx->setItemEnabled(tabbarctxCloseTab, true);
    }
}
//----------------------------------------------------------------//

void Kuake::setGeo()
{
konsolewidgets *konsolewidgetspointer;
switch (alignment)
    {
    case _ALIGN_TOP:
        tabwidget->setGeometry(0, tabwidgetoffset, screenWidth, size);
        //tabwidget->setTabPosition(QTabWidget::Bottom);
        for(konsolewidgetspointer = konsolewidgetslist.first();konsolewidgetspointer;konsolewidgetspointer = konsolewidgetslist.next())
            {
            konsolewidgetspointer->konsolewidgetnumber()->setGeometry(0, _BUTTON_SIZE - tabwidgetoffset, screenWidth, size - 30 - _BUTTON_SIZE);
            }
    break;

    case _ALIGN_BOTTOM:
        tabwidget->setGeometry(0, - _BUTTON_SIZE + tabwidgetoffset, screenWidth, size);
        //tabwidget->setTabPosition(QTabWidget::Bottom);
        for(konsolewidgetspointer = konsolewidgetslist.first();konsolewidgetspointer;konsolewidgetspointer = konsolewidgetslist.next())
            {
            konsolewidgetspointer->konsolewidgetnumber()->setGeometry(0, _BUTTON_SIZE - tabwidgetoffset, screenWidth, size - 30 - _BUTTON_SIZE);
            }
    break;

    case _ALIGN_LEFT:
        tabwidget->setGeometry(_BUTTON_SIZE, 0, size - _BUTTON_SIZE, screenHeight);
        //tabwidget->setTabPosition(QTabWidget::Top);
        for(konsolewidgetspointer = konsolewidgetslist.first();konsolewidgetspointer;konsolewidgetspointer = konsolewidgetslist.next())
            {
            konsolewidgetspointer->konsolewidgetnumber()->setGeometry(0, 0, size - _BUTTON_SIZE - 2, screenHeight - 30);
            }
    break;

    case _ALIGN_RIGHT:
        tabwidget->setGeometry(0, 0, size - _BUTTON_SIZE, screenHeight);
        //tabwidget->setTabPosition(QTabWidget::Top);
        for (konsolewidgetspointer = konsolewidgetslist.first();konsolewidgetspointer;konsolewidgetspointer = konsolewidgetslist.next())
            {
            konsolewidgetspointer->konsolewidgetnumber()->setGeometry(0, 0, size - _BUTTON_SIZE - 2, screenHeight - 30);
            }
    break;

    default:
        tabwidget->setGeometry(0, 0, screenWidth, size);
        tabwidget->setTabPosition(QTabWidget::Bottom);
        for (konsolewidgetspointer = konsolewidgetslist.first();konsolewidgetspointer;konsolewidgetspointer = konsolewidgetslist.next())
            {
            konsolewidgetspointer->konsolewidgetnumber()->setGeometry(0, 0, screenWidth, size - 35);
            }
    break;
    }
}

QString Kuake::getTabNumber()
{
int number = 0;
int labelsuggestion = 1;
int labelint = 0;
QString label;
switch (tabcounter)
    {
        case _TABCOUNT_SMART:

            while(number<=((tabwidget->count())+1))
            {
                label = tabwidget->tabLabel(tabwidget->page(number));
                labelint = label.remove( "Konsole: " ).toInt();
            if (labelint != labelsuggestion)
                {
                number = number + 1;
                }
            else
                {
                labelsuggestion = labelsuggestion + 1;
                number = 0;
                }
            }
        break;

        case _TABCOUNT_NORMAL:
            labelsuggestion = tabCount;
            tabCount = tabCount + 1;
        break;

        default:
            labelsuggestion = tabCount;
            tabCount = tabCount + 1;
        break;
    }
    return QString::number(labelsuggestion);
}

void Kuake::setKuakeState()
{
    emit slotChangeState();
}

void Kuake::partDestroyed()
{
    if( tabwidget->count() == 1 )
        emit slotQuit();
    else
        {
        konsolewidgetslist.remove(tabwidget->currentPageIndex());
        tabwidget->removePage(tabwidget->currentPage());
        disableremoveTabButtons();
        }
}

void Kuake::removeTab( QWidget* widget )
{
    konsolewidgetslist.remove(tabwidget->indexOf(widget));
    tabwidget->removePage( widget );
    disableremoveTabButtons();
}

void Kuake::ctxremoveTab()
{
    konsolewidgetslist.remove(tabwidget->indexOf(globalctxtabwidget));
    tabwidget->removePage(globalctxtabwidget);
    disableremoveTabButtons();
}

void Kuake::slotTabbarContextMenu(const QPoint & position)
{
    tabbarctx->popup( position );
}

void Kuake::slotTabContextMenu(QWidget* ctxtabwidget, const QPoint & position)
{
    tabctx->popup( position );
    globalctxtabwidget = ctxtabwidget;
}

void Kuake::disableremoveTabButtons()
{
    if( tabwidget->count() == 1 )
    { 
        tabwidget->setHoverCloseButton(false);
        removeTabButton->setEnabled(false);
        tabctx->setItemEnabled(tabctxCloseThisTab, false);
        tabbarctx->setItemEnabled(tabbarctxCloseTab, false);
    }
}

void Kuake::slotCreateKonsoleWidget()
{
	CreateKonsoleWidget();
}

void Kuake::slotChangeState()
{
    changeState( false );
}

void Kuake::slotToggleKey()
{
    changeState( true );
}

void Kuake::changeState( bool handleOldActiveWindow )
{
    kdDebug() << "[ !!! ] ChangeState" << endl;
    if( !isShown ) expand( handleOldActiveWindow );
    else minimize( handleOldActiveWindow );
}

void Kuake::expand( bool handleOldActiveWindow )
{
    kdDebug() << "[ !!! ] Expanding kuake" << endl;
    //if( handleOldActiveWindow ) oldActiveWindow = kwinmodule->activeWindow();
    stack->show();
    raise();
    resizeKuake();
    KWin::forceActiveWindow( winId() );
    isShown = true;
}

void Kuake::minimize( bool handleOldActiveWindow )
{
    kdDebug() << "[ !!! ] Minimizing kuake" << endl;
    resizeKuake();
    stack->hide();
    if( handleOldActiveWindow && oldActiveWindow ) KWin::forceActiveWindow( oldActiveWindow );
    isShown = false;
}

void Kuake::resizeKuake()
{
    if ( !isShown )
    {

        switch (alignment)
        {
            case _ALIGN_TOP:

                for(int s = 0; s <= animation_steps; s++) 
                {
                    int i = animate(0, size, s, animation_steps);
                    setGeometry(0, 0, screenWidth, i);
                }

                pbResize->setGeometry(0, 0, screenWidth, _BUTTON_SIZE);
                stack->setGeometry(0, 0, screenWidth, size - _BUTTON_SIZE);
                KWin::setStrut(winId(), 0, 0, (toggleButton)?_BUTTON_SIZE:0, 0);
		//setGeo();

            break;
	
            case _ALIGN_BOTTOM:

                for(int s = 0; s <= animation_steps; s++)
                {
                    int i = animate(0, size, s, animation_steps);
                    setGeometry(0, screenHeight - i, screenWidth, i);
                }

                pbResize->setGeometry(0, size - _BUTTON_SIZE, screenWidth, _BUTTON_SIZE);
                stack->setGeometry(0, _BUTTON_SIZE, screenWidth, size - _BUTTON_SIZE);
                KWin::setStrut(winId(), 0, 0, 0, (toggleButton)?_BUTTON_SIZE:0);
		//setGeo();

            break;

            case _ALIGN_LEFT:

                for(int s = 0; s <= animation_steps; s++) 
                {
                    int i = animate(0, size, s, animation_steps);
                    setGeometry(0, 0, i, screenHeight);
                }

                pbResize->setGeometry(0, 0, _BUTTON_SIZE, screenHeight);
                stack->setGeometry(0, 0, size - _BUTTON_SIZE, screenHeight);
                KWin::setStrut(winId(), (toggleButton)?_BUTTON_SIZE:0, 0, 0, 0);
		//setGeo();
            break;

            case _ALIGN_RIGHT:

                for(int s = 0; s <= animation_steps; s++) 
                {
                    int i = animate(0, size, s, animation_steps);
                    setGeometry(screenWidth - i, 0, i, screenHeight);
                }

                pbResize->setGeometry(size - _BUTTON_SIZE, 0, _BUTTON_SIZE, screenHeight);
                stack->setGeometry(_BUTTON_SIZE, 0, size, screenHeight);
                KWin::setStrut(winId(), 0, (toggleButton)?_BUTTON_SIZE:0, 0, 0);
		//setGeo();

            break;
        }

    } else {

        switch (alignment)
        {
            case _ALIGN_TOP:

                for(int s = 0; s <= animation_steps; s++) 
                {
                    int i = animate(size, _BUTTON_SIZE, s, animation_steps);
                    setGeometry(0, (toggleButton)?0:-_BUTTON_SIZE, screenWidth, i);
                }

                pbResize->setGeometry(0, 0, screenWidth, _BUTTON_SIZE);
                KWin::setStrut(winId(), 0, 0, (toggleButton)?_BUTTON_SIZE:0, 0);
		//setGeo();

            break;

            case _ALIGN_BOTTOM:

                for(int s = 0; s <= animation_steps; s++) 
                {
                    int i = animate(size, _BUTTON_SIZE, s, animation_steps);
                    setGeometry(0, (toggleButton)?screenHeight-i:(screenHeight-i)+_BUTTON_SIZE, screenWidth, i);
                }

                pbResize->setGeometry(0, 0, screenWidth, _BUTTON_SIZE);
                KWin::setStrut(winId(), 0, 0, 0, (toggleButton)?_BUTTON_SIZE:0);
		//setGeo();

            break;

            case _ALIGN_LEFT:

                for(int s = 0; s <= animation_steps; s++) 
                {
                    int i = animate(size, _BUTTON_SIZE, s, animation_steps);
                    setGeometry((toggleButton)?0:-_BUTTON_SIZE, 0, i, screenHeight);
                }

                pbResize->setGeometry(0, 0, _BUTTON_SIZE, screenHeight);
                KWin::setStrut(winId(), (toggleButton)?_BUTTON_SIZE:0, 0, 0, 0);
		//setGeo();

            break;

            case _ALIGN_RIGHT:

                for(int s = 0; s <= animation_steps; s++) 
                {
                    int i = animate(size, _BUTTON_SIZE, s, animation_steps);
                    setGeometry((toggleButton)?(screenWidth-i):(screenWidth-i)+_BUTTON_SIZE, 0, i, screenHeight);
                }

                pbResize->setGeometry(0, 0, _BUTTON_SIZE, screenHeight);
                KWin::setStrut(winId(), 0, (toggleButton)?_BUTTON_SIZE:0, 0, 0);
		//setGeo();

            break;
        }
    }
}

void Kuake::resizeKeepingState()
{
    if ( isShown )
    {

        switch ( alignment )
        {

            case _ALIGN_TOP:

                setGeometry(0, 0, screenWidth, size);
                pbResize->setGeometry(0, 0, screenWidth, _BUTTON_SIZE);
                stack->setGeometry(0, 0, screenWidth, size - _BUTTON_SIZE);
                KWin::setStrut(winId(), 0, 0, _BUTTON_SIZE, 0);
		//setGeo();

            break;

            case _ALIGN_BOTTOM:

                setGeometry(0, screenHeight - size, screenWidth, size);
                pbResize->setGeometry(0, size - _BUTTON_SIZE, screenWidth, _BUTTON_SIZE);
                stack->setGeometry(0, _BUTTON_SIZE, screenWidth, size - _BUTTON_SIZE);
                KWin::setStrut(winId(), 0, 0, 0, _BUTTON_SIZE);
		//setGeo();

            break;

            case _ALIGN_LEFT:

                setGeometry(0, 0, size, screenHeight);
                pbResize->setGeometry(0, 0, _BUTTON_SIZE, screenHeight);
                stack->setGeometry(0, 0, size - _BUTTON_SIZE, screenHeight);
                KWin::setStrut(winId(), _BUTTON_SIZE, 0, 0, 0);
		//setGeo();

            break;

            case _ALIGN_RIGHT:

                setGeometry(screenWidth - size, 0, size, screenHeight);
                pbResize->setGeometry(size - _BUTTON_SIZE, 0, _BUTTON_SIZE, screenHeight);
                stack->setGeometry(_BUTTON_SIZE, 0, size, screenHeight);
                KWin::setStrut(winId(), 0, _BUTTON_SIZE, 0, 0);
		//setGeo();

            break;
        }

    } else {

        switch ( alignment )
        {

            case _ALIGN_TOP:

                setGeometry(0, (toggleButton)?0:-_BUTTON_SIZE, screenWidth, _BUTTON_SIZE);
                pbResize->setGeometry(0, 0, screenWidth, _BUTTON_SIZE);
                KWin::setStrut(winId(), 0, 0, (toggleButton)?_BUTTON_SIZE:0, 0);
		//setGeo();

            break;

            case _ALIGN_BOTTOM:

                setGeometry(0, (toggleButton)?(screenHeight-_BUTTON_SIZE):(screenHeight-_BUTTON_SIZE)+_BUTTON_SIZE, screenWidth, _BUTTON_SIZE);
                pbResize->setGeometry(0, 0, screenWidth, _BUTTON_SIZE);
                KWin::setStrut(winId(), 0, 0, 0, (toggleButton)?_BUTTON_SIZE:0);
		//setGeo();

            break;

            case _ALIGN_LEFT:

                setGeometry(0, 0, (toggleButton)?0:-_BUTTON_SIZE, screenHeight);
                pbResize->setGeometry(0, 0, _BUTTON_SIZE, screenHeight);
                KWin::setStrut(winId(), (toggleButton)?_BUTTON_SIZE:0, 0, 0, 0);
		//setGeo();

            break;

            case _ALIGN_RIGHT:

                setGeometry((toggleButton)?(screenWidth-_BUTTON_SIZE):(screenWidth-_BUTTON_SIZE)+_BUTTON_SIZE, 0, _BUTTON_SIZE, screenHeight);
                pbResize->setGeometry(0, 0, _BUTTON_SIZE, screenHeight);
                KWin::setStrut(winId(), 0, (toggleButton)?_BUTTON_SIZE:0, 0, 0);
		//setGeo();

            break;

        }
    }
}

/*void Kuake::windowActivationChange(bool)
{
    kdDebug() << "[ !!! ] windowActivationChange, isShown is " << isShown << ", isActiveWindow is " << isActiveWindow() << endl;
    if( isShown && !isActiveWindow() ) minimize( true );
}*/

void Kuake::slotActiveWindowChanged(WId w) 
{
  if (w != winId()) {
    // do not consider kuake focus
    oldActiveWindow = w;

    if (isShown && toggleAutoCollapse)
      minimize(true);
  }
}


void Kuake::readConfig()
{
    KConfig config( "kuakerc" );
    sizeRatio = config.readNumEntry("size_ratio", 30 );
    alignment = config.readNumEntry ("alignment", _ALIGN_BOTTOM);
    animation_steps = config.readNumEntry("animation", _ANIMATION_MEDIUM);
    tabcounter = config.readNumEntry("tabcounter", _TABCOUNT_NORMAL);
    toggleButton = config.readBoolEntry("toggleButton", true);
    toggleAutoCollapse = config.readBoolEntry("toggleAutoCollapse", true);
    toggleStartMinimized = config.readBoolEntry("toggleStartMinimized", true);
    costumsize = config.readBoolEntry("costumsize", false);
    TabAlignment = config.readNumEntry("TabAlignment", _TAB_ALIGNMENT_BOTTOM);
    setSizeRatio( sizeRatio );
    setAlignment( alignment );
    setAnimation( animation_steps );
    setTabCounter( tabcounter );
    setTabAlignment( TabAlignment );
    ctx->setItemChecked( ctxToggleButtonID, toggleButton );
    ctx->setItemChecked( ctxToggleAutoCollapseID, toggleAutoCollapse);
    ctx->setItemChecked( ctxToggleStartMinimizedID, toggleStartMinimized);
}

void Kuake::slotDestroyed ()
{
    emit slotQuit();
}

void Kuake::slotAbout()
{
    KAboutApplication* about = new KAboutApplication(this);
    about->show();
}

void Kuake::slotQuit()
{
    if ( isShown ) writeConfigEntry("state", "true");
    else writeConfigEntry("state", "false");
    int number = 0;
    int tabwidgetcount = tabwidget->count();
    for(number=0;number<=tabwidgetcount;number=number+1)
        {
        tabwidget->removePage(tabwidget->page(0));
        }
    qApp->quit();
}

void Kuake::setSizeRatio( int ratio )
{
    kdDebug() << "[ !!! ] setSizeRatio " << ratio << endl;
    if (costumsize) ctxSizeRatio->setItemChecked(0, true);
    if( ratio == 0 ) slotSizeRatioCustom();
    else 
    {
        ctxSizeRatio->setItemChecked(0 ,false);
        writeConfigEntry("size_ratio", QString::number( ratio ) );
        size = calcSize( ratio );
        writeConfigEntry("costumsize", "false" );
    }

    ctxSizeRatio->setItemChecked(sizeRatio,false);
    ctxSizeRatio->setItemChecked(ratio, true);
    sizeRatio = ratio;
    setGeo();
    resizeKeepingState();
}

void Kuake::setAlignment( int alignmentID  )
{
    KConfig config( "kuakerc" );
    kdDebug() << "[ !!! ] setAlignmentID " << alignmentID << endl;
    writeConfigEntry( "alignment", QString::number( alignmentID ) );
    ctxAlignment->setItemChecked( alignment, false );
    ctxAlignment->setItemChecked( alignmentID, true );
    alignment = alignmentID;
    size = calcSize( config.readNumEntry("size_ratio", 30 ) ); 
    setGeo();
    resizeKeepingState();
}

void Kuake::setAnimation( int steps )
{
    kdDebug() << "[ !!! ] setAnimation " << steps << endl;
    writeConfigEntry("animation", QString::number( steps ) );
    if( animation_steps ) ctxAnimation->setItemChecked( animation_steps, false );
    animation_steps = steps;
    ctxAnimation->setItemChecked( steps, true );
}

void Kuake::setTabCounter( int tabcounterID )
{
    KConfig config( "kuakerc" );
    ctxTabCounter->setItemChecked( tabcounter, false );
    tabcounter = tabcounterID;
    writeConfigEntry("tabcounter", QString::number( tabcounter ) );
    ctxTabCounter->setItemChecked( tabcounter, true );
}

void Kuake::setTabAlignment( int TabAlignmentID )
{
    switch ( TabAlignmentID )
    {
        case _TAB_ALIGNMENT_TOP:
            tabwidgetoffset = _BUTTON_SIZE;
            tabwidget->setTabPosition(QTabWidget::Top);
        break;

        case _TAB_ALIGNMENT_BOTTOM:
            tabwidgetoffset = 0;
            tabwidget->setTabPosition(QTabWidget::Bottom);
        break;

        default:
            tabwidgetoffset = 0;
            tabwidget->setTabPosition(QTabWidget::Bottom);
        break;
    }
    ctxTabAlignment->setItemChecked( TabAlignment, false);
    TabAlignment = TabAlignmentID;
    ctxTabAlignment->setItemChecked( TabAlignment, true);
    setGeo();
    writeConfigEntry("TabAlignment", QString::number( TabAlignment ));
}

void Kuake::slotSizeRatioCustom()
{
    ctxSizeRatio->setItemChecked(_SIZE_RATIO_FULL,false);
    ctxSizeRatio->setItemChecked(_SIZE_RATIO_HALF,false);
    ctxSizeRatio->setItemChecked(_SIZE_RATIO_THIRD,false);
    ctxSizeRatio->setItemChecked(_SIZE_RATIO_QUARTER,false);
    KuakeCustomSize* k = new KuakeCustomSize(this, 0, &sizeRatio);
    KWin::forceActiveWindow( k->winId() );
    if ( k->exec() == QDialog::Accepted ) setSizeRatio( k->input->value() );
    writeConfigEntry("costumsize", "true" );
    ctxSizeRatio->setItemChecked(0, true);
} 

void Kuake::slotToggleKeyDialog()
{
    KConfig config( "kuakerc" );
    KKeyDialog::configure(globalAccel);
    globalAccel->updateConnections();
    globalAccel->writeSettings( &config );
}

void Kuake::slotToggleButton()
{
    (toggleButton) ? toggleButton = false : toggleButton = true;
    if( toggleButton ) writeConfigEntry("toggleButton", "true" );
    else writeConfigEntry("toggleButton", "false" );
    
    ctx->setItemChecked(ctxToggleButtonID, toggleButton);
    resizeKeepingState();
}

void Kuake::slotToggleAutoCollapse()
{
    toggleAutoCollapse = !toggleAutoCollapse;
    ctx->setItemChecked(ctxToggleAutoCollapseID, toggleAutoCollapse);
  
    if( toggleAutoCollapse ) writeConfigEntry("toggleAutoCollapse", "true" );
    else writeConfigEntry("toggleAutoCollapse", "false" );
}

void Kuake::slotToggleStartMinimized()
{
  toggleStartMinimized = !toggleStartMinimized;
  ctx->setItemChecked(ctxToggleStartMinimizedID, toggleStartMinimized);

  if( toggleStartMinimized ) writeConfigEntry("toggleStartMinimized", "true" );
  else writeConfigEntry("toggleStartMinimized", "false" );
}

int Kuake::animate(int start, int end, int current_step, int total_steps)
{
    return (int) (start + (end - start) * sin((M_PI / 2) * ((double) current_step) / ((double) total_steps)));
}

int Kuake::calcSize( int ratio )
{
    switch ( alignment )
    {
        case _ALIGN_TOP:
            return (screenHeight * ratio / _SIZE_RATIO_FULL);
        break;
        case _ALIGN_BOTTOM:
            return (screenHeight * ratio / _SIZE_RATIO_FULL);
        break;
        case _ALIGN_RIGHT:
            return (screenWidth * ratio / _SIZE_RATIO_FULL);
        break;
        case _ALIGN_LEFT:
            return (screenWidth * ratio / _SIZE_RATIO_FULL);
        break;
        default:
            return (screenHeight * ratio / _SIZE_RATIO_FULL / 2);
        break;
    }
}

void Kuake::writeConfigEntry( QString item, QString value )
{
    KConfig config( "kuakerc" );
    config.writeEntry( item, value );
}


#include "kuake.moc"
