/***************************************************************************
*   Copyright (C) 2003 by Martin Galpin                                   *
*   martin@nemohackers.org                                                *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

/* 
Kuake Main Window. Embeds the KPart konsole and handles all window 
operations. 
For documentated functions see definition - kuake.cpp
*/

#ifndef _KUAKE_H_
#define _KUAKE_H_

#ifdef HAVE_CONFIG_H
    #include <config.h>
#endif

#include <kapplication.h>
#include <kparts/mainwindow.h>
#include "kuakeiface.h"

#define _BUTTON_SIZE 10
#define _ALIGN_TOP 0
#define _ALIGN_BOTTOM 1
#define _ALIGN_LEFT 2
#define _ALIGN_RIGHT 3
#define _SIZE_RATIO_FULL	100
#define _SIZE_RATIO_HALF	50
#define _SIZE_RATIO_THIRD	33
#define _SIZE_RATIO_QUARTER	25
#define _SIZE_RATIO_MIN		10	// Smaller than 10% of the screen doesn't make sense.
#define _ANIMATION_NONE		1
#define _ANIMATION_SLOW		100
#define _ANIMATION_MEDIUM	50
#define _ANIMATION_FAST		10
#define _TABCOUNT_NORMAL        1
#define _TABCOUNT_SMART         2
#define _TAB_ALIGNMENT_TOP      1
#define _TAB_ALIGNMENT_BOTTOM   2


class QWidgetStack;
class QString;
class KuakePushButton;
class KActionCollection;
class KLibFactory;
class KPopupMenu;
class KGlobalAccel;
class KWinModule;
class KTabWidget;
class QToolButton;
class QWidget;
class konsolewidgets
{
public:
    konsolewidgets() : kwn( 0 ) { }
    konsolewidgets( QWidget* konsolewidgetnumber)
        : kwn( konsolewidgetnumber )
    { }
    void setkonsolewidgetnumber( QWidget* konsolewidgetnumber ) { kwn = konsolewidgetnumber; }

    QWidget* konsolewidgetnumber() { return kwn; }
private:
    QWidget* kwn;
};
class Kuake : public KMainWindow, virtual public KuakeIface
//class Kuake : public KParts::MainWindow, virtual public KuakeIface
{
    Q_OBJECT
public:
    Kuake();
    virtual ~Kuake();
    
    virtual void setKuakeState();
    
    KPopupMenu* ctx;
    KPopupMenu* tabbarctx;
    KPopupMenu* tabctx;
    
protected:
    //virtual void windowActivationChange(bool oldActive);
    void readConfig();
    void resizeKuake();
    void resizeKeepingState();
    void changeState(bool);
    void expand(bool);
    void minimize(bool);
    void writeConfigEntry( QString, QString );
    
    
public slots:
    void slotActiveWindowChanged(WId w);
    void slotChangeState();
    void notifySize(int,int) {};
    void changeColumns(int) {};
    void changeTitle(int,const QString&) {};    
    void slotCreateKonsoleWidget();
    void slotDestroyed();
    void partDestroyed();
    void removeTab(QWidget*);
    void slotTabbarContextMenu(const QPoint&);
    void slotTabContextMenu(QWidget*, const QPoint&);
    
    void slotAbout();
    void slotQuit();
    void setSizeRatio(int);
    void slotSizeRatioCustom();
    
    void setAlignment(int);
    void setAnimation(int);
    void setTabCounter(int);
    
    void slotToggleKey();
    void slotToggleKeyDialog();
    void slotToggleButton();
    void ctxremoveTab();
    void disableremoveTabButtons();
    void slotToggleAutoCollapse();
    void slotToggleStartMinimized();
    void setTabAlignment(int);
    
private:
    unsigned int screenWidth, screenHeight;
    unsigned int oldRatio;	// if 0 use pixel value stored in size
    unsigned int sizeRatio;
    unsigned int size;
    unsigned int alignment;
    unsigned int tabcounter;
    unsigned int TabAlignment;
    bool toggleAutoCollapse;
    bool costumsize;
    bool toggleStartMinimized;
    QWidget* globalctxtabwidget;
    bool isShown;
    int tabCount;
    bool toggleButton;
    WId oldActiveWindow;        // WId of the window that was active
    KWinModule* kwinmodule;	// need to find out the above
    void setGeo();
    QString getTabNumber();
    QPtrList<konsolewidgets> konsolewidgetslist;
    
    unsigned int ctxAnimationCheckedID;
    //unsigned int ctxEnableTabsID;
    unsigned int ctxToggleButtonID;
    unsigned int tabctxCloseThisTab;
    unsigned int tabbarctxCloseTab;
    unsigned int ctxToggleAutoCollapseID;
    unsigned int ctxToggleStartMinimizedID;
    int tabwidgetoffset;
    
                            
    
    KTabWidget* tabwidget;
    KParts::ReadOnlyPart *k_part;
    QToolButton* removeTabButton;
    QWidget* konsolewidget;
    
    QWidgetStack* stack;
    KuakePushButton* pbResize;
        KActionCollection* actionCollection;
    KGlobalAccel* globalAccel;
    
    KPopupMenu* ctxSizeRatio;
    KPopupMenu* ctxAlignment;
    KPopupMenu* ctxAnimation;
    KPopupMenu* ctxTabCounter;
    KPopupMenu* ctxTabAlignment;
    
    void slotSizeRatio( int ratio );
    int animate(int, int, int, int);
    int animation_steps;
    void CreateKonsoleWidget();
    
    int calcSize( int );
    
};

#endif // _KUAKE_H_
