/***************************************************************************
 *   Copyright (C) 2003 by Martin Galpin                                   *
 *   martin@nemohackers.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kuakecustomsize.h"

#include <qgroupbox.h>
#include <qapplication.h>
#include <qlabel.h>
#include <qwidget.h>
#include <qlayout.h>

#include <knuminput.h>
#include <kconfig.h>
#include <qslider.h>

#include "kuake.h"


KuakeCustomSize::KuakeCustomSize(QWidget* parent, const char*, unsigned int* value)
  : KDialogBase (parent, "customdialog", true, 0, Ok|Cancel, Ok, true)
{
	setCaption ("Custom Kuake size");
	QGroupBox* frame = new QGroupBox (3, Qt::Horizontal, "Custom Kuake size", this);
	//QLabel* label = new QLabel ("Set the size (in percent of your screen) you would like Kuake to be below.", frame);


	KConfig conf ("kuakerc");
	
	input = new KIntNumInput (frame);
	input->setMinValue(_SIZE_RATIO_MIN);
	input->setMaxValue(_SIZE_RATIO_FULL);
        QSlider *slider = new QSlider(Qt::Horizontal, frame);
        slider->setRange(_SIZE_RATIO_MIN, _SIZE_RATIO_FULL);
        connect(input, SIGNAL(valueChanged(int)), slider, SLOT(setValue(int)));
        connect(slider, SIGNAL(valueChanged(int)), input, SLOT(setValue(int)));

	input->setValue(*value);
	
	//connect(this, SIGNAL(okClicked()), parent, SLOT(slotCustomSizeOkClicked()));
	connect(this, SIGNAL(okClicked()), this, SLOT(slotSave()));
	setMainWidget (frame);
	
	_value = value;
	show();
}


KuakeCustomSize::~KuakeCustomSize()
{
}

void
KuakeCustomSize::slotSave()
{
	(*_value) = input->value();
}

#include "kuakecustomsize.moc"
