/***************************************************************************
 *   Copyright (C) 2003 by Martin Galpin                                   *
 *   martin@nemohackers.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kuakepushbutton.h"

#include <qwidget.h>
#include <qevent.h>
#include <qcursor.h>
#include <qpainter.h>
#include <qpen.h>

#include <kpopupmenu.h>
#include "kuake.h"

KuakePushButton::KuakePushButton(Kuake* parent, const char* name)
  : KPushButton(parent, name),
    _parent(parent)
{
}


KuakePushButton::~KuakePushButton()
{
}

void
KuakePushButton::mousePressEvent(QMouseEvent* e)
{
	if (e->button() == RightButton)
		{
			_parent->ctx->exec(QCursor::pos());
		}
	else if (e->button() == LeftButton)
		{
			emit _parent->slotChangeState();
		}	
}

/*
void
KuakePushButton::mouseMoveEvent(QMouseEvent*)
{
    _paintBorder = true;
    //repaint();   
}

void
KuakePushButton::leaveEvent(QEvent*)
{
    _paintBorder = false;
    //repaint();
}

void
KuakePushButton::paintEvent(QPaintEvent*)
{
    if (_paintBorder) {
        QPainter p(this);
        p.setPen (QPen (QColor (255,255,255)));
        p.drawRect (0,0,width(),height());
    }
}*/
