/***************************************************************************
 *   Copyright (C) 2003 by Martin Galpin                                   *
 *   martin@nemohackers.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kuake.h"
#include <kapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char *description =
    I18N_NOOP("A KDE konsole which resembles those found in Quake.");

static const char *version = "0.4Beta2";

static KCmdLineOptions options[] =
  {
     { "state", I18N_NOOP("Change the state of Kuake. (Shown / Hidden)"), 0 },
     { 0, 0, 0 }
  };
  
int main(int argc, char **argv)
{
    KAboutData about("kuake", I18N_NOOP("Kuake"), version, description,
                     KAboutData::License_GPL, "(C) 2001 Martin Galpin", 0, 0, "martin@nemohackers.org");
    about.addAuthor("Martin Galpin", 0, "martin@nemohackers.org" );
    about.addAuthor("Thomas Tischler", 0, "Tischler123@t-online.de");
    about.addAuthor("Stefan Bogner", 0,  "bochi@kmobiletools.org");
    about.addAuthor("Saïd LANKRI", 0, "said.lankri@miaif.lip6.fr");
	 about.addCredit("Georg Wittenburg", "Many patches - great thanks!", "georg.wittenburg@gmx.net");
	 about.addCredit("Dominik Seichter", 0, "domseichter@web.de");
	 about.addCredit("Bert Speckels", 0, "bert@speckels.de");
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KApplication app;

    // register ourselves as a dcop client
    app.dcopClient()->registerAs(app.name(), false);

    // no session.. just start up normally
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    if (args->isSet("state"))
      {
			DCOPClient *client = app.dcopClient();
    		client->attach();
			QByteArray data;
    		QDataStream ds(data, IO_WriteOnly);
			ds << 1;
    		client->send("kuake", "KuakeIface", "setKuakeState(int)", data);
			client->detach();
			return 0;
      }
    else
      {
			Kuake *widget = new Kuake;
         widget->show();
      }
    args->clear();
    
    return app.exec();
}
