/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dion@rcom.zp.ua                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FRMFILEMANAGER_H
#define FRMFILEMANAGER_H

#include <stdlib.h>

#include "frmfilemanager_base.h"
#include "custmsg.h"

class PhoneMan;
class QListViewItem;
class appConfig;
class QString;
class fmPixmap;

/**
@author Dmitry Nezhevenko
*/
class frmFileManager : public frmFileManager_base
{
	Q_OBJECT
public:
	frmFileManager(QWidget *parent = 0, PhoneMan * phone =0, appConfig * cfg = 0, const char *name = 0);
	~frmFileManager();
	
private:
	PhoneMan * phone;
	appConfig * myCfg;
	P2kFile * fileList;
	int fileCount;
	QString lastFolder;
	QListViewItem * selItem;
	fmPixmap * pxMap;
	
	void rebuildTree();
	QListViewItem* addDir(QListViewItem * parent, const QString& dir);
	void addFile(P2kFile * fl);
public slots:
	void onUpdateList();
	void onDownload();
	void onUpload();
	void nfoFileList(P2kFile * fl, int fc);
	void onFolderChanged(QListViewItem * sel);
	void onFileSelChanged();
	void onDelete();
	void onChangeAttr();
	void onComplete(int act);
protected:
	void contextMenuEvent(QContextMenuEvent *event);
};

#endif
