/*
 * 	test for gtk layout 
 *
 */
#include <stdio.h>
#include <gtk/gtk.h>
#include "proc.h"
#include "misc.h"

enum
{
	BASIC_FIELD,
	MEMORY_FIELD,
	JOB_FIELD,
  	COL_COMMAND = 0,
  	COL_PCPU
};

struct st_category 
{
	int field;
	char *name;
} ;

//{F_PID, F_TTY, F_USER, F_NICE,
//	F_STAT,F_RSS, F_MEM, F_CPU, F_START, F_TIME,
//	F_CMDLINE, F_END};

st_category  category[]= {
	{ F_COMM,	"COMMAND"},
	{ F_PID,	"PID"},
	{ F_USER,	"USER"},
	{ F_TTY,	"TTY"},
	{ F_NICE,	"NICE"},
	{ F_STAT,	"STAT"},
	{ F_RSS,	"RSS"},
	{ F_MEM,	"MEM"},
	{ F_CPU,	"CPU"},
	{ F_START,	"START"},
	{ F_TIME,	"TIME"},
	{ F_CMDLINE,"COMMAND LINE"},
	{-1,0}
};

int basic_fields[] = 
	{F_PID, F_TTY, F_USER, F_NICE,
	F_STAT,F_RSS, F_MEM, F_CPU, // F_START, F_TIME,
	F_CMDLINE, F_END};

void init_fields()
{

}

// proc_field.cpp
char *getFieldValue(Procinfo *p,int field)
{
	static char buff[512];

	switch(field)
	{
		case F_COMM:
			return p->command;
		case F_PID:
			sprintf(buff,"%d",p->pid);
			return buff;
		case F_TTY:
			return getTttyName(p->tty);
		case F_USER:
			return p->username;
		case F_STAT:
			buff[0]=p->state;
			buff[1]=0;
			return buff;
		case F_CPU:
			sprintf(buff,"%1.2f",p->pcpu);
			return buff;
		case F_MEM:
			sprintf(buff,"%1.2f",p->pmem);
			return buff;
		case F_RSS:
			sprintf(buff,"%d",p->resident);
			return buff;
		case F_NICE:
			sprintf(buff,"%d",p->nice);
			return buff;	
		case F_CMDLINE:
			return p->cmdline;
		default:
			strcpy(buff,"not added field");
			return buff;
	}
}

/*
	if(p->uid == p->euid)
		return Uidstr::userName(p->uid);
	else {
		QString s = Uidstr::userName(p->uid);
		s.append(p->euid == 0 ? "*" : "+");
		return s;
	}
	*/


//#define G_N_ELEMENTS(arr)		(sizeof (arr) / sizeof ((arr)[0]))

static char *xxx="???";
char *getFieldName(int field)
{
	int idx=0;
	for(int i=0;category[i].field>=0;i++)
	{
		idx=category[i].field;
		//printf("name =%d %s  idx=%d\n",i, category[i].name,idx);
		if(idx==field) 
		{
			//printf("name =%s \n", category[i].name);
			return category[i].name;
		}
	}
	return xxx;
}


class Field 
{

};

//List<Field*> fields;
//char *get


// C style
int colums[32];
int	colums_num=0;

GtkWidget	*window;
GtkWidget	*menu_bar;
GtkWidget	*tool_bar;
GtkWidget	*graph_bar;
GtkWidget	*table,*statusbar,*scrolledwindow;
GtkWidget	*treeview; // table 
GtkListStore  *store;

int fields[48];

void add_row(char *cmd,float val)
{

	GtkTreeIter    iter;
	/* Append a row and fill in some data */
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, COL_COMMAND, cmd,COL_PCPU, (int)val*100, -1);
//	gtk_list_store_set_value()
}

void get_iter(GtkTreeIter *it)
{
	gtk_list_store_append (store, it);
}


void add_row(Procinfo *p,int flist[])
{
	GtkTreeIter    iter;
	int fid=0;
	gtk_list_store_append (store, &iter);
	for(int i=0;flist[i] >=0;i++)
	{
		fid=flist[i];
		gtk_list_store_set (store, &iter, fid,getFieldValue(p,fid), -1);
	}
}

void update_row(Procinfo *p,int flist[])
{
	GtkTreeIter    iter;
	int fid=0;
//	gtk_list_store_append (store, &iter);
	for(int i=0;flist[i] >=0;i++)
	{
		fid=flist[i];
		//if(fid==F_CMDLINE or fid==F_PID or fid==F_USER ) continue;
		//gtk_list_store_set (store, &iter, fid,getFieldValue(p,fid), -1);
		gtk_list_store_set (store, &p->iter, fid,getFieldValue(p,fid), -1);
	}
}

void add_col(int field)
{
//	field
}


void update_store()
{

}

void add_col(char *title)
{
	enum { TEXT_COLUMN, COLOR_COLUMN, N_COLUMNS };
	GtkTreeViewColumn *column;
	GtkCellRenderer   *renderer = gtk_cell_renderer_text_new ();
 
	column = gtk_tree_view_column_new_with_attributes 
		(title,  renderer, "text", TEXT_COLUMN, NULL);

	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
}


void GTK_set_fields_list(int flist[])
{
	GtkTreeViewColumn *column;
	GtkCellRenderer     *renderer;
	int fid=0;
	for(int i=0;flist[i]>=0;i++)
	{
		fid=flist[i];
		renderer = gtk_cell_renderer_text_new ();
		column=gtk_tree_view_column_new_with_attributes 
			(getFieldName(fid), renderer,"text", fid,	NULL);
			//("help", renderer,"text", fid,	NULL);
		gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
//		gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
//			-1, getFieldName(fid), renderer,"text", fid,	NULL);
	}
}


GtkWidget * create_view_and_model (void)
{
	GtkWidget           *treeview;
	GType	array[48];
	treeview = gtk_tree_view_new ();
	//list model
	//store = gtk_list_store_new (NUM_COLS, G_TYPE_STRING, G_TYPE_UINT);
	for(int i=0;i<NUM_COLS;i++)
			array[i]=G_TYPE_STRING;
	store = gtk_list_store_newv (NUM_COLS,array);


	gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), GTK_TREE_MODEL(store));
	/* The tree view has acquired its own reference to the
   *  model, so we can drop ours. That way the model will
   *  be freed automatically when the tree view is destroyed */
	g_object_unref (store);

	GtkTreeSelection* sel;
	sel=gtk_tree_view_get_selection(GTK_TREE_VIEW (treeview) );
	//gtk_tree_selection_set_mode (sel,GTK_SELECTION_BROWSE);
	gtk_tree_selection_set_mode (sel, GTK_SELECTION_MULTIPLE);
	// selection mode  GTK_SELECTION_SINGLE and GTK_SELECTION_BROWSE.
	//gtk_tree_view_set_hover_selection(GTK_TREE_VIEW(view),true);
	
#if GTK_CHECK_VERSION(2,10,0) 
	// GTK_MINOR_VERSION >=10
	// GTK 2.10 
	gtk_tree_view_set_grid_lines(GTK_TREE_VIEW(treeview),GTK_TREE_VIEW_GRID_LINES_HORIZONTAL);
#endif

	return treeview;
}


static void menuitem_response (int );

void init_menubar(GtkWidget *vbox)
{
	GtkWidget *menu;
	GtkWidget *root_menu;
	GtkWidget *menu_items;

	// menu 
	menu = gtk_menu_new ();
	menu_items = gtk_menu_item_new_with_label ("basic fields");
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_items);
	g_signal_connect_swapped (G_OBJECT (menu_items), "activate",
			G_CALLBACK (menuitem_response), 
			(gpointer) BASIC_FIELD);
	gtk_widget_show (menu_items);

	menu_items = gtk_menu_item_new_with_label ("memory fields");
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_items);
	g_signal_connect_swapped (G_OBJECT (menu_items), "activate",
			G_CALLBACK (menuitem_response), 
			(gpointer) MEMORY_FIELD);
	gtk_widget_show (menu_items);

	root_menu = gtk_menu_item_new_with_label ("Field");
	gtk_widget_show (root_menu);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (root_menu), menu);

	/* Create a menu-bar to hold the menus and add it to our main window */
	menu_bar = gtk_menu_bar_new ();
	gtk_box_pack_start (GTK_BOX (vbox), menu_bar, FALSE, FALSE, 1);
	gtk_widget_show (menu_bar);
	gtk_menu_shell_append (GTK_MENU_SHELL (menu_bar), root_menu);
}

void init_graphbar(GtkWidget *vbox)
{
	GdkPixmap* pixmap;
	pixmap=gdk_pixmap_new (NULL,640,52,24);
	graph_bar= gtk_image_new();
	gtk_image_set_from_pixmap(GTK_IMAGE(graph_bar),pixmap,NULL);
	gtk_box_pack_start (GTK_BOX (vbox), graph_bar, FALSE, FALSE, 1);
	gtk_widget_show (graph_bar);
}

void init_toolbar(GtkWidget *vbox)
{
	GtkWidget	*hbox;
	GSList		*treemode_group;

	tool_bar = gtk_toolbar_new ();
	gtk_widget_show (tool_bar);
	gtk_box_pack_start (GTK_BOX (vbox), tool_bar, FALSE, FALSE, 5);
	//gtk_toolbar_set_style (GTK_TOOLBAR (tool_bar), GTK_TOOLBAR_ICONS);
	//tmp_toolbar_icon_size = gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar1));
	
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (tool_bar), hbox);

	GtkWidget*  radio_linear;
	GtkWidget*  radio_tree;

	//radio_linear= gtk_radio_button_new_with_label (treemode_group,);
	//radio_tree= gtk_radio_button_new (treemode_group);
	radio_linear= gtk_radio_button_new_with_label (NULL,"linear");
	radio_tree= gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio_linear),"tree");
	gtk_box_pack_start (GTK_BOX (hbox), radio_linear, FALSE, FALSE, 5);
	gtk_box_pack_start (GTK_BOX (hbox), radio_tree, FALSE, FALSE, 5);

	gtk_widget_show_all(hbox);	
}


void make_mainwindow()
{
	GtkWidget *vbox;
	//  GtkWidget *graph_bar;
	char buf[128];
	int i;	

	/* create a new window */
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	//gtk_widget_set_size_request (GTK_WIDGET (window), 200, 100);
	gtk_window_resize(GTK_WINDOW(window),640, 480);
	gtk_window_set_title (GTK_WINDOW (window), "new qps");
	g_signal_connect ( window, "delete_event", gtk_main_quit, NULL);

	/* A vbox to put a menu and a button in: */
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), vbox);
	gtk_widget_show (vbox);


	init_menubar(vbox);	
	init_graphbar(vbox);
	init_toolbar(vbox);

	scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow);
	gtk_box_pack_start (GTK_BOX (vbox), scrolledwindow, TRUE, TRUE, 0);
	//gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_SHADOW_IN);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (scrolledwindow),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);

	///treeview = gtk_tree_view_new ();
	treeview = create_view_and_model ();
	gtk_widget_show (treeview);
	gtk_container_add (GTK_CONTAINER (scrolledwindow), treeview);
	gtk_container_set_border_width (GTK_CONTAINER (treeview), 1);
	
	statusbar = gtk_statusbar_new ();
	gtk_widget_show (statusbar);
	gtk_box_pack_start (GTK_BOX (vbox), statusbar, FALSE, FALSE, 0);

	gtk_widget_show (window);
}

#include "list.h"
extern List<Procinfo*> process;
Proc *proc;

static int num_frame=0;
// update basis
gboolean update(void)
{
	proc->refresh();
	//gtk_list_store_clear(store);
	//gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), NULL);
	for(process.begin(); process.current();process.next() ) {
		Procinfo *p = process.current();
		update_row(p,basic_fields);
		//add_row(p,basic_fields);
	}
	//	gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), GTK_TREE_MODEL(store));
	//	g_object_unref (store);
	printf("frame=%d\n",num_frame++);
	return true;
}


int main(int   argc, char *argv[] )
{
    gtk_init (&argc, &argv);
	make_mainwindow(); 
	GTK_set_fields_list(basic_fields);

	proc=new Proc();
	g_timeout_add(1000,(GtkFunction)update,NULL); // 100ms -> 4.95% 
	gtk_main (); //destory List
    return 0;
}



/* Print a string when a menu item is selected */
static void menuitem_response( int id )
{
    printf ("%d\n", id);
}
