/*
* This file is part of QTGZManager, an open-source GUI for Slackware pkgtools.
* Copyright (C) 2006  Alexandre Albuquerque Arnt
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* Contact e-mail : Alexandre Albuquerque Arnt <aaarnt@gmail.com>
* Program URL   : http://jtgzmanager.sf.net
*
*/
//#include <QtCore>
#include <QtGui>
#include <QObject>
#include "mainwindowimpl.h"


bool isAnInstanceRunning(){
	QStringList slParam;
	QProcess proc;  

	slParam << "-C";
	slParam << "qtgzmanager";

  proc.start("ps", slParam);
	proc.waitForStarted();
	proc.waitForFinished();

	//First, we verify if there is already a running instance of QTGZManager... 
	QString out = proc.readAll();
	if  (out.count("qtgzmanager")>1) 	return true;
	else return false;
}

int main(int argc, char ** argv)
{
	QApplication app( argc, argv );	

	QTranslator appTranslator;
	appTranslator.load(":/resources/translations/qtgzmanager_" +
		QLocale::system().name());
	//	app.applicationDirPath());
	app.installTranslator(&appTranslator);

	if ( isAnInstanceRunning() ){
		QMessageBox::critical( 0, QObject::tr("Attention"), QObject::tr("There is already one instance of this application running!"));
		return ( -1 );
	}

	MainWindowImpl win;
	win.show(); 

	QResource::registerResource("./images.qrc");
	app.setQuitOnLastWindowClosed( false );
  
  return app.exec();
}
