/*
* This file is part of QTGZManager, an open-source GUI for Slackware pkgtools.
* Copyright (C) 2006  Alexandre Albuquerque Arnt
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* Contact e-mail : Alexandre Albuquerque Arnt <aaarnt@gmail.com>
* Program URL   : http://jtgzmanager.sf.net
*
*/
#ifndef PACKAGE_H
#define PACKAGE_H

#include <QString>
#include <QDir>

#include "mainwindowimpl.h"

const QString er  				   	  = "([\\w._+]+[-])+";
const QString er3 				  	  = "[\\w._+]+[-]";
const QString PACKAGES_DIR   	  = "/var/log/packages";
const QString NO_MATCH      	  = "not found!";
const QString TGZ_PACKAGE_EXTENSION = ".tgz";
const QString RPM_PACKAGE_EXTENSION = ".rpm";
//const QString PATH_TEMP         = ".QTGZManagerApp";
const QString KNOWN_ARCHS[]     = {"noarch", "i386", "i486", "i586", "i686", "i786", "i886", "i986", "x86_64"};                   
const QString KNOWN_NAMES[]   	= {"cdparanoia", "libjpeg", "slib"};
const int KNOWN_ARCHS_LEN = 8;
const int KNOWN_NAMES_LEN = 3;

enum Classification { NOT_INSTALLED, 
	INSTALLED, INFERIOR_VERSION, SUPERIOR_VERSION, INTERNAL_ERROR, FROZEN, RPM };

class Result;

class Package  
{  
	private:

		QDir* scanPackages;
		QStringList m_lPackages;
		QString targetDir;
		QString showRegExp( const QString&, const QString& );		
		static QString makeURLClickable( const QString & );
	
	public:

		Package();
		~Package();
		
		static QMap<QString, QStringList> findFile( const QString& name );
	
		static QString getPackageBaseName( const QString& );    
		static QString getInfoPackage( SelectedPackage, bool installed = false );
		static QStringList getPackageContents( const QString& pkgName, bool installed = false );	
	
		Result verifyPackageInstallation( const QString&, const QStringList& );
		void setTargetDir( const QString& );
};

class Result{
	private:
		int classification; 
		QString installedPackage;
	
	public:
		Result(int c, const QString& p){
			classification = c;
			installedPackage = p;
		}
	
		int getClassification(){
			return classification;
		}
	
		QString getInstalledPackage(){
			return installedPackage;
		}
};


#endif
