/***************************************************************************
 *   Copyright (C) 2007 by Pavloudis Zisis   *
 *   djzet1@otenet.gr   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <fstream.h> //header for writing shell script file
#include <stdlib.h> // system() header
#include <string.h> //string header
#include <qregexp.h> //QRegExp header
#include <qprocess.h> //header for executing the createpkg shell script
#include <qtimer.h> //timer header
#include <kfiledialog.h> //includes the file and dir dialog header
#include <qinputdialog.h> //includes the package name dialog header
#include <kurl.h> //includes KURL header
#include <kmessagebox.h> //includes Msg Box header
#include <klocale.h> //translation header
#include <qlineedit.h> //include Line Edit widget header
#include <qfile.h> //header for reading the output file
#include <qlabel.h> //label header
#include <qtextedit.h> //console box header
#include <kcursor.h> //header for changing the cursor
#include <kaboutdata.h> //the about data header
#include <kaboutdialog.h> //the about dialog header
#include <qdialog.h> //convert dialog header
#include <qpushbutton.h> //header for the ok btn in the convert dialog
#include <qcheckbox.h> //header for the check boxes in the convert dialog
#include <qapplication.h>
#include <qlabel.h>

#include "slackpackwidget.h"

KURL FileName; //Declares "FileName"
QString FileNamePath; //Declares "FileNamePath"
QString InstallPkg; //Declares installpkg system command
QString InstallPkgPath; //connects "InstallPkg" with the path for the package
QString InstallPkgCom; //connects "InstallPkgPath" with the file that the console out will be redirected.
QString RemovePkg; //Declares removepkg system command
QString RemovePkgPath; //connects "RemovePkg" with the path for the package
QString RemovePkgCom; //connects "RemovePkgPath" with the file that the console out will be redirected.
QString UpgradePkg; //Declares upgradepkg system command
QString UpgradePkgPath; //connects "UpgradePkg" with the path for the package
QString UpgradePkgCom; //connects "UpgradePkgPath" with the file that the console out will be redirected.
QString ConvRpm2Tgz; //Declares rpm2tgz system command
QString ConvRpm2TgzPath; //connects "ConvRpm2Tgz" with the path for the package
QString ConvRpm2TgzCom; //connects "ConvRpm2TgzPath" with the file that the console out will be redirected.
QString ConvDeb2Tgz; //Declares deb2tgz system command
QString ConvDeb2TgzPath; //connects "ConvDeb2Tgz" with the path for the package
QString ConvDeb2TgzCom; //connects "ConvDeb2TgzPath" with the file that the console out will be redirected
QString MakePkg; //Declares MakePkg system command
QString MakePkgName; //connects "MakePkgName" with the name of the package
QString PkgName; //package name created through the MakePkg dialogs
QString MakePkgCom; //connects "MakePkgCom" with the file that the console out will be redirected
KURL Directory; //Declares "Directory"
QString DirectoryPath; //Declares "DirectoryPath"
QString MakePkgDlgAppText; //Declares "MakePkgDlgAppText"
QString MakePkgDlgAppVer; //Declares "MakePkgDlgAppVer"
QString MakePkgDlgAppArch; //Declares "MakePkgDlgAppArch"
QStringList MakePkgDlgAppArchList; //Declares "MakePkgDlgAppArchList"

QString cd; //the command
QString cdPath; //includes directory path
QString cdCom;  //appends 'cd' command with dir path

QString line; //read  output file lines



SlackpackWidget::SlackpackWidget(QWidget* parent, const char* name, WFlags fl)
        : SlackpackWidgetBase(parent,name,fl)
{
}

SlackpackWidget::~SlackpackWidget()
{
}

/*$SPECIALIZATION$*/
void SlackpackWidget::searchbutton_clicked() //search for the pkg the user want to install
{
FileName = KFileDialog::getOpenURL(); //Opens file dialog, gets file path.
FileNamePath = FileName.pathOrURL(); //converts "FileName" var, to "FileNamePath" string.
FileNameBox->setText(FileName.pathOrURL()); //sets FileNamePath to FileNameBox.
}

void SlackpackWidget::installbutton_clicked() //installs the pkg
{
	setCursor(KCursor::waitCursor()); //sets wait cursor


consolebox->clear(); //clears any remaing output text in the consolebox from previous action

            InstallPkg = "installpkg "; //system command to install the pkg(ATTENTION!: the 'space' after the command is nesecery!!!
            InstallPkgPath = InstallPkg.append(FileNamePath); //adds the path to InstallPkg
            InstallPkgCom = InstallPkgPath.append(" >/usr/local/Slackpack/outputs/InstallOutput.con"); //InstallPkg+InstallPkgPath with the file for redirection of the console output
 
	system (InstallPkgCom) ; //uses "InstallPkgCom" Qstring to install the package

//READ THE CONSOLE OUTPUT FILE
QFile outputfile("/usr/local/Slackpack/outputs/InstallOutput.con"); //the console output file
outputfile.open(IO_ReadOnly); //open the file
QTextStream file(&outputfile);

QString fileText;
fileText = (file.read());


/*BEGINING ERROR TESTING >*/
if( FileNamePath.isEmpty())
{
//if filenamepath is empty, msg box= choose package first
   KMessageBox::error( this, i18n("You must select a package first!")/*<-text content goes here*/, 
    i18n("Message")/*<-title goes here*/);

}
else if ( fileText.contains("Cannot install", FALSE) )
{
//inform user that there was an error with the installation
   KMessageBox::error( this, i18n("Error Installing the package\nSee the Console Output")/*<-text content goes here*/, 
    i18n("Error!")/*<-title goes here*/);
}
/*< ENDS ERROR TESTING*/
else
{
//PASTE OUTPUT'S FILE CONTENTS INTO THE CONSOLE BOX
consolebox->setText(fileText);
 //inform user that installation is complete
   KMessageBox::information( this, i18n("Installation Complete")/*<- text content goes here*/,
    i18n("Message")/*<-title goes here*/);
}

    setCursor(KCursor::arrowCursor()); //restores cursor



}



void SlackpackWidget::removebutton_clicked() //removes package
{
 	setCursor(KCursor::waitCursor()); //sets wait cursor

consolebox->clear(); //clears any remaing output text in the consolebox from previous action

            RemovePkg = "removepkg "; //system command to remove the pkg(ATTENTION!: the 'space' after the command is nesecery!!!
            RemovePkgPath = RemovePkg.append(FileNamePath); //adds the path to RemovePkg
            RemovePkgCom = RemovePkgPath.append(" >/usr/local/Slackpack/outputs/RemoveOutput.con"); //RemovePkg+RemovePkgPath with the file for redirection of the console output
 
	system (RemovePkgCom) ; //uses "RemovePkgCom" Qstring to remove the package

//READ THE CONSOLE OUTPUT FILE
QFile outputfile("/usr/local/Slackpack/outputs/RemoveOutput.con"); //the console output file
outputfile.open(IO_ReadOnly); //open the file
QTextStream file(&outputfile);

QString fileText;
fileText = (file.read());


/*BEGINNING ERROR TESTING >*/
if( FileNamePath.isEmpty())
{
//if filenamepath is empty, msg box= choose package first
   KMessageBox::error( this, i18n("You must select a package first!")/*<-text content goes here*/, 
    i18n("Message")/*<-title goes here*/);
}
else if ( fileText.contains("No such package", FALSE) )
{
//inform user that there was an error on removing
   KMessageBox::error( this, i18n("Error Removing the package\nSee the Console Output")/*<-text content goes here*/, 
    i18n("Error!")/*<-title goes here*/);
}
/*< ENDS ERROR TESTING*/
else
{
//PASTE OUTPUT'S FILE CONTENTS INTO THE CONSOLE BOX
consolebox->setText(fileText);
//inform user that package is removed
   KMessageBox::information( this, i18n("Package Removed")/*<-text content goes here*/, 
    i18n("Message")/*<-title goes here*/);
}

 	setCursor(KCursor::arrowCursor()); //restores cursor


}

void SlackpackWidget::upgradebutton_clicked()
{
 	setCursor(KCursor::waitCursor()); //sets wait cursor

consolebox->clear(); //clears any remaing output text in the consolebox from previous action

            UpgradePkg = "upgradepkg "; //system command to remove the pkg(ATTENTION!: the 'space' after the command is nesecery!!!
            UpgradePkgPath = UpgradePkg.append(FileNamePath); //adds the path to RemovePkg
            UpgradePkgCom = UpgradePkgPath.append(" >/usr/local/Slackpack/outputs/UpgradeOutput.con"); //RemovePkg+RemovePkgPath with the file for redirection of the console output
 
	system (UpgradePkgCom) ; //uses "RemovePkgCom" Qstring to remove the package

//READ THE CONSOLE OUTPUT FILE
QFile outputfile("/usr/local/Slackpack/outputs/UpgradeOutput.con"); //the console output file
outputfile.open(IO_ReadOnly); //open the file
QTextStream file(&outputfile);

QString fileText;
fileText = (file.read());


/*BEGINNING ERROR TESTING >*/
if( FileNamePath.isEmpty())
{
//if filenamepath is empty, msg box= choose package first
   KMessageBox::error( this, i18n("You must select a package first!")/*<-text content goes here*/, 
    i18n("Message")/*<-title goes here*/);
}
else if ( fileText.contains("Error:  there is no installed package named", FALSE) )
{
//inform user that there is no package installed
   KMessageBox::error( this, i18n("Error Upgrading the package\nSee the Console Output")/*<-text content goes here*/, 
    i18n("Error!")/*<-title goes here*/);
}
else if (fileText.contains("Skipping package", FALSE) )
{
//inform user that package is already upgraded
   KMessageBox::error( this, i18n("Selected package is up-to-date")/*<-text content goes here*/, 
    i18n("Error")/*<-title goes here*/);
}
/*< ENDS ERROR TESTING*/

else
{

//PASTE OUTPUT'S FILE CONTENTS INTO THE CONSOLE BOX
consolebox->setText(fileText);
//inform user that package is upgraded
   KMessageBox::information( this, i18n("Package Upgraded!")/*<-text content goes here*/, 
    i18n("Message")/*<-title goes here*/);
}

 	setCursor(KCursor::arrowCursor()); //restores cursor


}

void SlackpackWidget::makepkgbutton_clicked()
{

	setCursor(KCursor::waitCursor()); //sets wait cursor

consolebox->clear(); //clears any remaing output text in the consolebox from previous action
FileNameBox->clear(); //clears any text on FileNameBox

KMessageBox::information(this, i18n("Please choose the directory contains your application's source code.") );

//Directory choose Dialog
 Directory = KFileDialog::getExistingDirectory(); //Opens dir dialog, gets dir path.
 DirectoryPath = Directory.pathOrURL(); //converts "Directory" var, to "DirectoryPath" string.

//Package Creation Dialogs
//set package name dialog
    bool ok;
    MakePkgDlgAppText = QInputDialog::getText(
            "Set package name", "Enter the name of your application:\neg slackpack", QLineEdit::Normal,
            QString::null, &ok, this );
    if ( ok && !MakePkgDlgAppText.isEmpty() ) 
         {
//set version dialog
         bool ok;
         MakePkgDlgAppVer = QInputDialog::getText(
            "Set package version", "Enter the version of your application:\neg 1.1.0", QLineEdit::Normal,
            QString::null, &ok, this );
         if ( ok && !MakePkgDlgAppText.isEmpty() )
         {
//set arch dialog
                   MakePkgDlgAppArchList.append( "i486" );
                   MakePkgDlgAppArchList.append( "i686" );
                   MakePkgDlgAppArchList.append( "i386" );
                   MakePkgDlgAppArchList.append( "x86_64" );
                   MakePkgDlgAppArchList.append( "S390" );
                   MakePkgDlgAppArchList.append( "noarch" );

                   bool ok;
                   MakePkgDlgAppArch = QInputDialog::getItem(
                     "Choose package Arch", "Choose Arch for the package:\neg i386", MakePkgDlgAppArchList, 1, TRUE, &ok,
            this );
                     if ( ok ) {
                           // user selected an item and pressed OK
                     }
                     else
                     {
                      // user pressed Cancel
                     }
         }
         else
         {
        // user entered nothing or pressed Cancel
         }

    }
    else
    {
        // user entered nothing or pressed Cancel
    }
    
//BEGGING ERROR TESTING
//CHECK IF 'MakePkgDlgAppText-VerArch are empty.
if ( MakePkgDlgAppText.isEmpty() )
{
KMessageBox::error(this, "You must enter the name of your application!");
}
else if ( MakePkgDlgAppVer.isEmpty() )
{
KMessageBox::error(this, "You must enter the version of your application!");
}
else if( MakePkgDlgAppArch.isEmpty() )
{
KMessageBox::error(this, "You must select an arch for your application!");
}
//IF NO ERRORS FOUND CONTINUE WITH THE PACKAGE CREATION
else
{

//cd command-go to the dir were the app is
            cd = "cd ";
            cdPath = (DirectoryPath);
            cdCom = cd.append(cdPath); 
//connects MakePkgDlgAppText-ver-arch and gets the pkg name
PkgName = (MakePkgDlgAppText);
PkgName.append("-");
PkgName.append(MakePkgDlgAppVer);
PkgName.append("-");
PkgName.append(MakePkgDlgAppArch);
PkgName.append(".tgz");

//create MakePkgCom
            MakePkg = "makepkg -l y -c y "; //system command to create the pkg(ATTENTION!: the 'space' after the command is nesecery!!!
            MakePkgName = MakePkg.append(PkgName); //adds the pkg name to MakePkg
            MakePkgCom = MakePkgName.append(" >/usr/local/Slackpack/outputs/MakePkgOutput.con"); //MakePkg+MakelPkgPath with the file for redirection of the console output


//create the shell script 
ofstream shscript("/tmp/createpkg");
shscript <<"#!/bin/bash \n\n";
//Writes on the script the steps for compiling and installing the app from source
shscript << cdCom << " \n";
shscript << "./configure --prefix=/tmp/slackpack \n";
shscript << "make \n";
shscript << "make install \n\n";
//go to the dir where the app was installed and run makepkg
shscript << "cd /tmp/slackpack \n";
shscript << MakePkgCom << "";
//Close ofstream
shscript.close();

//Change shell script's permitions to read-write-execute by the current user using chmod command
system("chmod u=x /tmp/createpkg");

	setCursor(KCursor::waitCursor());

KMessageBox::information(this, "Now, please wait until package creation is complete");

//Execute the shell script
system("/tmp/createpkg");

       setCursor(KCursor::arrowCursor()); //restores cursor



//READ THE CONSOLE OUTPUT FILE
QFile outputfile("/usr/local/Slackpack/outputs/MakePkgOutput.con"); //the console output file
outputfile.open(IO_ReadOnly); //open the file
QTextStream file(&outputfile);

QString fileText;
fileText = (file.read());
//PASTE THE OUTPUT'S FILE CONTENTS INTO THE CONSOLE BOX
consolebox->setText(fileText);


/*BEGINING ERROR TESTING*/ 
if(  DirectoryPath.isEmpty())
{
//if filenamepath is empty, msg box= you must choose a dir first
   KMessageBox::error( this, i18n("You must select a directory contains your application's source code.")/*<-text content goes here*/, 
    i18n("Message")/*<-title goes here*/);

}
/*
else if ( fileText.contains("Cannot install", FALSE) )
{
//inform user that there was an error with the installation
   KMessageBox::error( this, i18n("Error Installing the package\nSee the Console Output")//<-text content goes here
    i18n("Error!")/*<-title goes here);
}
/* ENDS ERROR TESTING */
else
{

 //inform user that creation of the package is complete
   KMessageBox::information( this, i18n("Package Created Succesfully")/*<- text content goes here*/,
    i18n("Success!")/*<-title goes here*/);

}
}

    setCursor(KCursor::arrowCursor()); //restores cursor

}


void SlackpackWidget::rpm2tgzbutton_clicked()
{
if(FileNamePath.isEmpty())
{
KMessageBox::error(this, "You must choose a package to convert!");
}
else
{
	setCursor(KCursor::waitCursor()); //set wait cursor

consolebox->clear(); //clears any remaing output text in the consolebox from previous action

            ConvRpm2Tgz = "rpm2tgz "; //system command to install the pkg(ATTENTION!: the 'space' after the command is nesecery!!!
            ConvRpm2TgzPath = ConvRpm2Tgz.append(FileNamePath); //adds the path to ConvRpm2Tgz
            ConvRpm2TgzCom = ConvRpm2TgzPath.append(" >/usr/local/Slackpack/outputs/ConvertOutput.con"); //ConvRpm2Tgz+ConvRpm2TgzPath with the file for redirection of the console output
 
	system (ConvRpm2TgzCom) ; //uses "ConvRpm2TgzPkgCom" Qstring to install the package

//READ THE CONSOLE OUTPUT FILE AND PASTE THE CONTENTS INTO THE CONSOLE BOX
QFile outputfile("/usr/local/Slackpack/outputs/ConvertOutput.con"); //the console output file
outputfile.open(IO_ReadOnly); //open the file
QTextStream file(&outputfile);

QString fileText;
fileText = (file.read());
consolebox->setText(fileText);

 setCursor(KCursor::arrowCursor()); //restores cursor
}
}


void SlackpackWidget::deb2tgzbutton_clicked()
{

if(FileNamePath.isEmpty())
{
KMessageBox::error(this, "You must choose a package to convert!");
}
else
{
	setCursor(KCursor::waitCursor()); //set wait cursor

consolebox->clear(); //clears any remaing output text in the consolebox from previous action

            ConvDeb2Tgz = "deb2tgz "; //system command to install the pkg(ATTENTION!: the 'space' after the command is nesecery!!!
            ConvDeb2TgzPath = ConvDeb2Tgz.append(FileNamePath); //adds the path to DebRpm2Tgz
            ConvDeb2TgzCom = ConvDeb2TgzPath.append(" >/usr/local/Slackpack/outputs/ConvertOutput.con"); //ConvDeb2Tgz+ConvDeb2TgzPath with the file for redirection of the console output
 
	system (ConvDeb2TgzCom) ; //uses "ConvDeb2TgzPkgCom" Qstring to install the package

//READ THE CONSOLE OUTPUT FILE AND PASTE THE CONTENTS INTO THE CONSOLE BOX
QFile outputfile("/usr/local/Slackpack/outputs/ConvertOutput.con"); //the console output file
outputfile.open(IO_ReadOnly); //open the file
QTextStream file(&outputfile);

QString fileText;
fileText = (file.read());
consolebox->setText(fileText);

 setCursor(KCursor::arrowCursor()); //restores cursor

}
}


void SlackpackWidget::aboutbutton_clicked() //displays an 'about' KAboutDialog
{

QString aboutText; //declares text used in the about page
QString timelineText; //declares text used in the timeline page
QString licenseText;//declares text used in the license page
QString thankstoText;//declares text used in the Thanks To page

aboutText = i18n( "Slackpack is a package manager for Slackware Linux with GUI."
        "<br>"
    "(c) 2008 Pavloudis Zisis."
       "<br>"
       "<br>"
"Slackpack Home: <A HREF=\"http://slackpackpkgman.sourceforge.net\">http://slackpackpkgman.sourceforge.net</A>"
"<br>"
"<br>"
"Author Home: <A HREF=\"http://mysticalgr.co.cc\">http://mysticalgr.co.cc</A>");

thankstoText = i18n( 
"Matthew Bruenig"
"<br>"
"     Shell script for converting .deb to .tgz packages."
"<br>"
"Copyright (C) 2007 matthewbruenig@gmail.com"
"<br>"
"<br>"
"Plasma_GR"
"<br>"
"     Slackpack's Logo"
);

//READ THE LICENSE (COPYING) FILE AND COPY TEXT INTO licenseText var
QFile COPYINGfile("/usr/local/Slackpack/COPYING"); //the console output file
COPYINGfile.open(IO_ReadOnly); //open the file
QTextStream license(&COPYINGfile);
licenseText = (license.read());

//READ THE ChangeLog FILE AND COPY TEXT INTO timelineText var
QFile Changelogfile("/usr/local/Slackpack/ChangeLog"); //the console output file
Changelogfile.open(IO_ReadOnly); //open the file
QTextStream timeline(&Changelogfile);
timelineText = (timeline.read());

//construct the dialog
KAboutDialog *about = new KAboutDialog(
    KAboutDialog::AbtAppStandard | KAboutDialog::AbtKDEStandard,
    "KDE Standard Configuration",
    KDialogBase::Ok | KDialogBase::Help,
    KDialogBase::Ok,
    this,
    "about",
    TRUE);
//Sets information
about->setTitle(i18n("About Slackpack"));
about->setProduct("Slackpack", "1.0.2", "Pavloudis Zisis", "2008");
about->setAuthor("Pavloudis Zisis\n ", "djzet1@otenet.gr\n ", "http://mysticalgr.co.cc\n ", "Lead Programmer");
about->setCaption(i18n("About Slackpack"));
about->setImage("/usr/local/Slackpack/icons//hi90-app-slackpack.png");
about->setImageFrame(TRUE);

//Construct Tabbed pages, add text
about->addTextPage( i18n("&About"), aboutText, true );
about->addTextPage( i18n("Timeline"), timelineText, true);
about->addTextPage( i18n("Thanks To"), thankstoText, true);
about->addTextPage( i18n("License"), licenseText, true);

//set size, show the dialog
about->setInitialSize( QSize( 500, 350 ) );
about->show();
}


void SlackpackWidget::exitbutton_clicked() //exit the program
{
exit(0);
}


















#include "slackpackwidget.moc"

