#!/bin/sh

###
# Use rc.local to start virtualbox at boot.
###

# if rc.vboxdrv is executable, run it on startup
run=`grep ". /etc/rc.d/rc.vboxdrv" etc/rc.d/rc.local`
if [[ "${run}" == "" ]]; then
cat << EOF >> etc/rc.d/rc.local

#VirtualBox driver
# To disable VirtualBox driver, chmod rc.vboxdrv to 644
if [ -x /etc/rc.d/rc.vboxdrv ]; then
        sh /etc/rc.d/rc.vboxdrv start
fi
EOF
fi

# if rc.vboxnet is executable, run it on startup
run=`grep ". /etc/rc.d/rc.vboxnet" etc/rc.d/rc.local`
if [[ "${run}" == "" ]]; then
cat << EOF >> etc/rc.d/rc.local

#VirtualBox network
# To disable VirtualBox network, chmod rc.vboxnet to 644
if [ -x /etc/rc.d/rc.vboxnet ]; then
        sh /etc/rc.d/rc.vboxnet start
fi
EOF
fi

# if rc.vboxbridge is executable, run it on startup
run=`grep ". /etc/rc.d/rc.vboxbridge" etc/rc.d/rc.local`
if [[ "${run}" == "" ]]; then
cat << EOF >> etc/rc.d/rc.local

#VirtualBox bridge
# To enable VirtualBox network, chmod rc.vboxbridge to 755
if [ -x /etc/rc.d/rc.vboxbridge ]; then
        sh /etc/rc.d/rc.vboxbridge start 1 user
fi
EOF
fi

chroot . <<EOR 2>/dev/null
/usr/sbin/groupadd vboxusers 2> /dev/null

echo "********************************************************************************"
echo "* Remember to run:                                                             *"
echo "* '/etc/rc.d/rc.vboxdrv setup'                                                 *"
echo "* '/etc/rc.d/rc.vboxdrv start'                                                 *"
echo "* '/etc/rc.d/rc.vboxnet start'                                                 *"
echo "* after install                                                                *"
echo "*                                                                              *"
echo "* To enable bridged networking change the execution permissions of             *"
echo "* /etc/rc.d/rc.vboxbridge and modify rc.local line to match your number of     *"
echo "* machines and the user running virtualbox.                                    *"
echo "* rc.vboxbridge {start [number of virtual interfaces] [user] | stop}           *"
echo "*                                                                              *"
echo "* This version has a registration form that, if compiled and committed gives   *"
echo "* a segmentation fault. When you install or upgrade from version 1.5.0, open   *"
echo "* VirtualBox and close the registration form and VirtualBox two times. Then    *"
echo "* the registration form shouldn't appear again.                                *"
echo "********************************************************************************"
( cd usr/lib/virtualbox/components ; rm -rf VirtualBox_XPCOM.xpt )
( cd usr/lib/virtualbox/components ; ln -sf ../VirtualBox_XPCOM.xpt VirtualBox_XPCOM.xpt )
( cd usr/lib/virtualbox/components ; rm -rf VBoxC.so )
( cd usr/lib/virtualbox/components ; ln -sf ../VBoxC.so VBoxC.so )
( cd usr/lib/virtualbox/components ; rm -rf VBoxXPCOMBase.xpt )
( cd usr/lib/virtualbox/components ; ln -sf ../VBoxXPCOMBase.xpt VBoxXPCOMBase.xpt )
( cd usr/lib/virtualbox/components ; rm -rf VBoxSVCM.so )
( cd usr/lib/virtualbox/components ; ln -sf ../VBoxSVCM.so VBoxSVCM.so )
( cd usr/lib/virtualbox/components ; rm -rf VBoxXPCOMIPCC.so )
( cd usr/lib/virtualbox/components ; ln -sf ../VBoxXPCOMIPCC.so VBoxXPCOMIPCC.so )
( cd usr/lib/virtualbox/sdk/samples/API ; rm -rf tstVBoxAPILinux )
( cd usr/lib/virtualbox/sdk/samples/API ; ln -sf ../../../tstVBoxAPILinux tstVBoxAPILinux )
( cd usr/bin ; rm -rf vboxmanage )
( cd usr/bin ; ln -sf ../lib/virtualbox/VBox.sh vboxmanage )
( cd usr/bin ; rm -rf vboxsdl )
( cd usr/bin ; ln -sf ../lib/virtualbox/VBox.sh vboxsdl )
( cd usr/bin ; rm -rf virtualbox )
( cd usr/bin ; ln -sf ../lib/virtualbox/VBox.sh virtualbox )
