/*
	wav_id.c
	14.07.99 tn

	machine-independent (work both on big and little endian)
	code to check if we have valid wavheader that is configured
	for cd-quality (16 bit, stereo, 44.1kHz)
*/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "largefile.h"

#include <string.h>
#include <glib.h>
#include "xcdroast.h"

/* check if valid wav-header */
/* endian independent version */
/* return 1 if true, 0 if not */

gint is_std_wav_file(guchar *hdr) {
gchar tmp[MAXLINE];
guint wFormatTag;
guint fmtOffset;

	strncpy(tmp,(char *) hdr+0,4);
	if (strncmp(tmp,"RIFF",4) != 0) 
		return 0;

	strncpy(tmp,(char *) hdr+8,4);
	if (strncmp(tmp,(char *)"WAVE",4) != 0) 
		return 0;

	strncpy(tmp,(char *) hdr+12,4);
	if (strncmp(tmp,(char *)"fmt ",4) != 0) 
		return 0;

	fmtOffset = (hdr[19]<<24) + (hdr[18]<<16) + (hdr[17]<<8) + hdr[16];
	strncpy(tmp,(char *) hdr+20+fmtOffset,4);
	if (strncmp(tmp,(char *)"data",4) != 0) 
		return 0;

	wFormatTag = (hdr[21] << 8) + hdr[20];
	if (wFormatTag != 1) 
		return 0;

	return 1;
}


/* check if wav-file is in cd-quality */
/* endian independent version */
/* return 1 if true, 0 if not */

gint is_in_cd_quality(guchar *hdr) {
guint nChannels;
guint wBitsPerSample;
guint nSamplesPerSec;

	nChannels = (hdr[23] << 8) + hdr[22];
	wBitsPerSample = (hdr[35] << 8) + hdr[34];
	nSamplesPerSec = (hdr[27]<<24) + (hdr[26]<<16) + (hdr[25]<<8) + hdr[24];

	if (nChannels != 2 || wBitsPerSample != 16 || 
	    nSamplesPerSec != 44100)
		return 0;

	return 1; 
}


