#!/bin/sh

function config() {
	NEW="$1"
	OLD="`dirname $NEW`/`basename $NEW .new`"

	# If there's no config file by that name, mv it over:
	if [ ! -r $OLD ]; then
		echo "--- Renaming $NEW to $OLD"
		mv $NEW $OLD
	elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
		# toss the redundant copy
		echo "--- Deleting $NEW"
		rm $NEW
	else
		# Otherwise, we leave the .new copy for the admin to consider...
		echo "--- Leaving $NEW for you to replace $OLD"
	fi
	

}

for i in /etc/freetds/*.new
do
	if [ -f $i ]
	then
		config $i
	fi
done
( cd usr/lib ; rm -rf libct.so )
( cd usr/lib ; ln -sf libct.so.4.0.0 libct.so )
( cd usr/lib ; rm -rf libsybdb.so.5 )
( cd usr/lib ; ln -sf libsybdb.so.5.0.0 libsybdb.so.5 )
( cd usr/lib ; rm -rf libsybdb.so )
( cd usr/lib ; ln -sf libsybdb.so.5.0.0 libsybdb.so )
( cd usr/lib ; rm -rf libct.so.4 )
( cd usr/lib ; ln -sf libct.so.4.0.0 libct.so.4 )
