#ifndef _BIN_LISTVIEWITEM_H
#define _BIN_LISTVIEWITEM_H

#include <qlistview.h>
#include <string>
#include <map>

//! Special listview item
/*!
 * This QListViewItem is designed to hold the binary data cannot displayed
 * as clear text internal.
 */
class CBinListViewItem:public QListViewItem
{
    friend class QListViewItemIterator;
    friend class QListViewToolTip;
public:
    //! constructor
    /*!
     * \sa QListViewItem ( QListView * parent );
     */
    CBinListViewItem ( QListView * parent );
    CBinListViewItem ( QListViewItem * parent );
    CBinListViewItem ( QListView * parent, QListViewItem * after );
    CBinListViewItem ( QListViewItem * parent, QListViewItem * after );
    virtual ~CBinListViewItem();
    //! set displayable text
    /*!
     * Set a text to display. if this is done, than the binary content for the column is 
     * deleted.
     * \param column the column to set the text for
     * \param text the text to set
     * \sa QListViewItem::setText(int column, const QString & text)
     */
    virtual void setText(int column, const QString & text);
    //! Set the real content
    /*!
     * Stores the content not displayed as clear text.
     * \param column the columnt the content is assigned to
     * \param aContent the content to assign
     */
    virtual void setBinContent(int column, const std::string&aContent);
    //! Retrieves the not displayable content for a column
    /*!
     * \param column the columnt the content should returned
     * \return the content if stored, otherwise an empty string.
     */
    virtual const std::string&getBinContent(int column);

protected:
    void init_data();
    std::map<int,std::string> m_BinContent;
};

#endif
