#include "selectoutfile.h"

#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>

#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "kmysqladmin/stringres.h"

#define Inherited CSelectOutFileData

CSelectOutFile::CSelectOutFile(QWidget* parent,const char* name)
    :Inherited( parent, name,true )
{
    setCaption( GET_TEXT(72));
    OkButton->setDefault(false);
    OkButton->setEnabled(false);
    FileNameEdit->setFocus();
    currentName = "";
    CurrentSel = 0;
    m_type = SAVE_SQL;
    SelSQLButton->setChecked(true);
    SelTypeGroup->setTitle(GET_TEXT(73) );
    SelAsciiButton->setText(GET_TEXT(75) );
    CancelButton->setText(GET_TEXT(108) );
}

CSelectOutFile::~CSelectOutFile()
{
}

void CSelectOutFile::SearchFile()
{
    QString s;
    QString pat;
    switch (m_type) {
    case SAVE_ASCII:
        pat = "*.txt";
        break;
    case SAVE_HTML:
        pat = "*.html";
        break;
    case SAVE_LATEX:
        pat = "*.tex";
        break;
    case SAVE_CSV:
        pat = "*.csv";
        break;
    case SAVE_SQL:
        pat = "*.sql";
        break;
    default:
        pat = "*";
        break;
    }
    s = KFileDialog::getSaveFileName(0,pat);
    FileNameEdit->setText(s);
}

void CSelectOutFile::SelectionChanged(int i)
{
    CurrentSel = i;
    if (SelSQLButton->isChecked()) {
        m_type = SAVE_SQL;
    } else if (SelAsciiButton->isChecked()) {
        m_type = SAVE_ASCII;
    } else if (SelLatexButton->isChecked()) {
        m_type = SAVE_LATEX;
    } else if (SelCsvButton->isChecked()) {
        m_type = SAVE_CSV;
    } else if (SelHTMLButton->isChecked()) {
        m_type = SAVE_HTML;
    } else {
        m_type = SAVE_UNKNOWN;
    }
}

void CSelectOutFile::textchange(const QString&text)
{
    if (text.length() > 0) {
        OkButton->setDefault(true);
        OkButton->setEnabled(true);
        currentName = text;
    } else {
        OkButton->setDefault(false);
        OkButton->setEnabled(false);
        currentName = "";
    }
}
