// -*-Mode: C++;-*-
#ifndef CTableView_included
#define CTableView_included

#include "tableviewdata.h"
#include "kmysqladmin/tabledescr.h"
#include "kmysqladmin/PatternPair.h"
#include "kmysqladmin/helpers/stringlist.h"
#include "kmysqladmin/helpers/smart_pointer.h"

#include <qptrlist.h>
#include <qmessagebox.h>
#include <qpixmap.h>

class CMySql;
class QListViewItem;

class CTableView : public CTableViewData
{
    Q_OBJECT

public:
    CTableView (smart_pointer<CMySql> &_sql_server,QWidget* parent = NULL, const char* name = NULL);

    virtual ~CTableView();
    virtual bool close ( bool forceKill=FALSE );
    void standalone(bool how);

protected slots:
    virtual void sort_select(int);
    virtual void column_sel_change();
    virtual void MakeRequest();
    virtual void db_select(int);
    virtual void table_select(int);
    virtual void search_rows();
    virtual void addRow();
    virtual void modifyRow();
    virtual void delete_row();
    virtual void emptyTable();
    virtual void saveResult();
    virtual void FixFontChanged();
    virtual void OutputSelected(QListViewItem*);
    virtual void desc_box_toggled(bool);
    virtual void OutputMarked(QListViewItem*);
    virtual void showHelp();
    virtual void handleSettings();

public slots:
    void show();
    void RefreshLists();
    void hide_it();

protected:
    smart_pointer<CMySql> sql_server;
    ColumnList Current_Table_Fields;
    ColumnList Current_Displayed_Fields;
    KeyList CurrentKeys;
    stringlist SelectFields;
    QPixmap blob_image;
    bool m_BlobAsImage;
    bool m_ScaleBlob;
    int m_blob_width,m_blob_height;
    bool m_DisplayMultiline;
    bool binToImage(const std::string&aData, QImage&target,bool ignoreScale = false);
    QString escape_output(const std::string&what);
    bool m_first_init;

    void set_buttons(bool how);
    bool KeyDisplayed();
    ColumnList_iterator FindTableItem(const std::string&what,bool all_fields=true);
    //! Breaks and filters current item
    /*!
     */
    int BreakIntoParts(PatternList*BreakList,PatternList*KeyList=0,
               QListViewItem*item = 0,bool no_auto_filter = false,bool copy_bins = false, bool escape_bins = true);
    void saveAscii(const char*filename,const char*sep="\t");
    void saveHtml(const char*filename);
    void saveLatex(const char*filename);
    void saveSql(const char*filename);
    void build_relevant_keys();
    void _make_fetch_request(bool search_it=false);
};

#endif // CTableView_included

