/***************************************************************************
                          accessrights.cpp  -  description
                             -------------------
    begin                : Die Sep 23 2003
    copyright            : (C) 2003 by Rajko Albrecht
    email                : ral@alwins-world.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmysqladmin/setup/settings.h"
#include "kmysqladmin/globals.h"
#include "accessrightsdata.h"
#include "accessrights.h"
#include "kmysqladmin/helpers/tfunctions.h"
#include "kmysqladmin/helpers/stringhelper.h"
#include "kmysqladmin/helpers/qt_stl_string.h"
#include <qlistview.h>
#include <klistview.h>
#include <qtabwidget.h>
#include <qfont.h>
#include <ktextbrowser.h>
#include <kpushbutton.h>
#include <kmessagebox.h>
#include <string>
#include <iostream>
#include <sstream>
#include "addmysqluser.h"
#include "addmysqlhost.h"
#include "changemysqluser.h"
#include "kmysqladmin/PatternPair.h"
#include "kmysqladmin/stringres.h"
#include <klocale.h>
#include <kapp.h>

const std::string CAccessrights::DB_Table="db";
const std::string CAccessrights::DB_Name="mysql";
const std::string CAccessrights::User_Table="user";
const std::string CAccessrights::Host_Table="host";
const std::string CAccessrights::Tables_Table="tables_priv";
const std::string CAccessrights::Tables_Name ="Table_name";
const std::string CAccessrights::Tables_priv_col="Table_priv";
const std::string CAccessrights::Column_priv_col="Column_priv";
const std::string CAccessrights::Columns_Table = "columns_priv";
const std::string CAccessrights::Columns_Name = "Column_Name";

const std::string CAccessrights::MaxQuestions="max_questions";
const std::string CAccessrights::MaxUpdates="max_updates";
const std::string CAccessrights::MaxConnections="max_connections";

using namespace std;

#define HOCHKOMMA string("'")

CAccessrights::CAccessrights(smart_pointer<CMySql>& _sql_server,QWidget *parent, const char *name,  WFlags fl)
    : CAccessrightsData(parent,name,fl),sql_server(_sql_server)
{
    if (sql_server->master_version()>3) {
        // additional privileges for user table
        cols_user_table_ext.push_back("Show_db");
        cols_user_table_ext.push_back("Super");
        cols_user_table_ext.push_back("Create_tmp_table");
        cols_user_table_ext.push_back("Lock_tables");
        cols_user_table_ext.push_back("Execute");
        cols_user_table_ext.push_back("Repl_slave");
        cols_user_table_ext.push_back("Repl_client");
        // additional privileges for host table
        cols_host_table_ext.push_back("Create_tmp_table");
        cols_host_table_ext.push_back("Lock_tables");

        // special data of users stored as integer values. String values like the ssl
        // certificates may stored in another list for making differences.
        cols_user_table_data.push_back(MaxQuestions);
        cols_user_table_data.push_back(MaxConnections);
        cols_user_table_data.push_back(MaxUpdates);
    }
    connect(&GlobalSettings,SIGNAL(fixfont_changed()),this,SLOT(FontChanged()));
    RefreshLists();
    tabChanged(0);
}

CAccessrights::~CAccessrights()
{
}

void CAccessrights::RefreshLists()
{
    ReadHostTable();
    ReadUserTable();
    ReadDBTable();
    ReadTablesTable();
    ReadColumnTable();
}

/** No descriptions */
void CAccessrights::FontChanged()
{
    QFont font = GlobalSettings.get_fixed_font();
    hostsbox->setFont(font);
    usersbox->setFont(font);
    dbbox->setFont(font);
    tablesbox->setFont(font);
    columnsbox->setFont(font);
}

/** Read in the host table of mysql */
void CAccessrights::ReadHostTable()
{
    stringlist erg;
    int i = 0;

    hostsbox->clear();
    hostdetailtext->setText("");
    if (!sql_server)
        return;
    erg.push_back(std::string(Host_Table));
    erg.push_back(std::string(DB_Table));
    list_vector result;
    i = sql_server->fetch_rows(DB_Name,Host_Table,Host_Table,false,erg,result,0,0,0,true);
    if (result.size() > 0 && i==0) {
        QListViewItem * item = 0;
        list_vector::iterator result_iter = result.begin();
        stringlist::iterator iter;
        for (;result_iter!=result.end();++result_iter) {
            iter = result_iter->begin();
            item = new QListViewItem(hostsbox,item);
            int count = 0;
            for (;iter!=result_iter->end();++iter) {
                item->setText(count,STL_TO_QT_STRING(*iter));
                ++count;
                if (count == 2)break;
            }
        }
    }
    if (hostsbox->childCount()>0) {
        hostsbox->setCurrentItem(hostsbox->firstChild());
        hostsbox->setSelected(hostsbox->firstChild(),true);
    }
}

void CAccessrights::ReadUserTable()
{
    stringlist erg;
    PatternList Patterns;
    int i;

    usersbox->clear();
    userdetailtext->setText("");
    if (!sql_server)
        return;
    erg.push_back(Host_Table);
    erg.push_back(User_Table);
    list_vector result;

    i = sql_server->fetch_rows(DB_Name,User_Table,User_Table,false,erg,result,0,0,0,true);

    if (result.size()) {
        QListViewItem* item=0;
        list_vector::iterator result_iter=result.begin();
        stringlist::iterator iter;
        for (;result_iter!=result.end();++result_iter) {
            iter = result_iter->begin();
            item = new QListViewItem(usersbox,item);
            int count = 0;
            for (;iter!=result_iter->end();++iter) {
                item->setText(count,STL_TO_QT_STRING(*iter));
                ++count;
                if (count == 2)break;
            }
        }
    }
    if (usersbox->childCount()>0 && i == 0) {
        usersbox->setSelected(usersbox->firstChild(),true);
    }
}

void CAccessrights::ReadDBTable()
{
    stringlist erg;
    PatternList Patterns;
    int i;

    dbdetailtext->setText("");
    dbbox->clear();
    if (!sql_server)
        return;
    erg.push_back(Host_Table);
    erg.push_back(User_Table);
    erg.push_back(DB_Table);
    list_vector result;
    i = sql_server->fetch_rows(DB_Name,DB_Table,User_Table,false,erg,result,0,0,0,true);
    if (result.size()) {
        QListViewItem* item=0;
        list_vector::iterator result_iter=result.begin();
        stringlist::iterator iter;
        for (;result_iter!=result.end();++result_iter) {
            iter = result_iter->begin();
            item = new QListViewItem(dbbox,item);
            int count = 0;
            for (;iter!=result_iter->end();++iter) {
                item->setText(count,STL_TO_QT_STRING(*iter));
                ++count;
                if (count == 3)break;
            }
        }
    }
    if (dbbox->childCount()>0 && i == 0) {
        dbbox->setSelected(dbbox->firstChild(),true);
    }
}

void CAccessrights::ReadTablesTable()
{
    stringlist erg;
    PatternList Patterns;
    int i;

    tablesbox->clear();
    tabledetailtext->setText("");
    if (!sql_server)
        return;
    erg.push_back(Host_Table);
    erg.push_back(User_Table);
    erg.push_back(DB_Table);
    erg.push_back(Tables_Name);
    list_vector result;

    Patterns.push_back(CPatternPair(Tables_priv_col,"","!=",true));

    i = sql_server->fetch_rows(DB_Name,Tables_Table,User_Table,false,erg,result,0,0,&Patterns,true);
    if (result.size()) {
        QListViewItem* item=0;
        list_vector::iterator result_iter=result.begin();
        stringlist::iterator iter;
        for (;result_iter!=result.end();++result_iter) {
            iter = result_iter->begin();
            item = new QListViewItem(tablesbox,item);
            int count = 0;
            for (;iter!=result_iter->end();++iter) {
                item->setText(count,STL_TO_QT_STRING(*iter));
                ++count;
                if (count == 4)break;
            }
        }
    }
    if (tablesbox->childCount()>0 && i == 0) {
        tablesbox->setCurrentItem(tablesbox->firstChild());
    }
}

void CAccessrights::ReadColumnTable()
{
    stringlist erg;
    PatternList Patterns;
    int i;

    columndetailtext->setText("");
    columnsbox->clear();
    if (!sql_server)
        return;
    erg.push_back(Host_Table);
    erg.push_back(User_Table);
    erg.push_back(DB_Table);
    erg.push_back(Tables_Name);
    erg.push_back(Columns_Name);
    list_vector result;
    i = sql_server->fetch_rows(DB_Name,Columns_Table,User_Table,false,erg,result,0,0,&Patterns,true);
    if (result.size()) {
        QListViewItem* item=0;
        list_vector::iterator result_iter=result.begin();
        stringlist::iterator iter;
        for (;result_iter!=result.end();++result_iter) {
            iter = result_iter->begin();
            item = new QListViewItem(columnsbox,item);
            int count = 0;
            for (;iter!=result_iter->end();++iter) {
                item->setText(count,STL_TO_QT_STRING(*iter));
                ++count;
                if (count == 5)break;
            }
        }
    }
    if (columnsbox->childCount()>0 && i == 0) {
        columnsbox->setCurrentItem(columnsbox->firstChild());
        columnsbox->setSelected(columnsbox->firstChild(),true);
    }
}

void CAccessrights::tabChanged(QWidget*)
{
    KListView * view = 0;
    switch (accesstabs->currentPageIndex()) {
    case 0:
        view = hostsbox;
        break;
    case 1:
        view = usersbox;
        break;
    case 2:
        view = dbbox;
        break;
    case 3:
        view = tablesbox;
        break;
    case 4:
        view = columnsbox;
        break;
    default:
        break;
    }
    if (!view || view->currentItem()==0) {
        EditButton->setEnabled(false);
        deleteButton->setEnabled(false);
    } else {
        EditButton->setEnabled(true);
        deleteButton->setEnabled(true);
    }
}

void CAccessrights::RefreshCurrent()
{
    switch (accesstabs->currentPageIndex()) {
    case 0:
        ReadHostTable();
        break;
    case 1:
        ReadUserTable();
        break;
    case 2:
        ReadDBTable();
        break;
    case 3:
        ReadTablesTable();
        break;
    case 4:
        ReadColumnTable();
        break;
    default:
        break;
    }
}

void CAccessrights::tablehilighted(QListViewItem*aItem)
{
    stringlist erg;
    PatternList Patterns;
    list_vector result;

    if (!aItem) return;
    last_table_has_grant = false;
    Patterns.push_back(CPatternPair(Host_Table,QT_TO_STL_STRING(aItem->text(0))
        ,"=",true));
    Patterns.push_back(CPatternPair(User_Table,QT_TO_STL_STRING(aItem->text(1))
        ,"=",true));
    Patterns.push_back(CPatternPair(DB_Table,QT_TO_STL_STRING(aItem->text(2))
        ,"=",true));
    Patterns.push_back(CPatternPair(Tables_Name,QT_TO_STL_STRING(aItem->text(3))
        ,"=",true));
    Patterns.push_back(CPatternPair(Tables_priv_col,"","!=",true));
    erg.push_back("Grantor");erg.push_back("DATE_FORMAT(Timestamp,\'%d.%m. %H:%i\')");erg.push_back("Table_priv");
    int i = sql_server->fetch_rows(DB_Name,Tables_Table,User_Table,false,erg,result,0,0,&Patterns,true);
    QString msg = "<b>"+aItem->text(1)+"@"+aItem->text(0)+" on "+aItem->text(2)+"."+aItem->text(3)+":</b><br><hline><br>";
    if (i!=0 || result.size()<1 ) {
        msg +="<font color=\"red\">";
        msg += GET_TEXT(26);msg+="!</font></br>";
    } else {
        msg+="<table><tr><td><b>Privileges:</b></td><td>";
        msg+=STL_TO_QT_STRING(result[0][2]);
        if (strstr(result[0][2].c_str(),CAddmysqluser::GRANT)!=NULL) {
            last_table_has_grant = true;
        }
        msg+="</td></tr>";
        msg+="<tr><td><b>Grantor:</b></td><td>";
        msg+=STL_TO_QT_STRING(result[0][0]);
        msg+="</td></tr>";
        msg+="<tr><td><b>Date:</b></td><td>";
        msg+=STL_TO_QT_STRING(result[0][1]);
        msg+="</td></tr></table>\n";
    }
    tabledetailtext->setText(msg);
}

void CAccessrights::userhilighted(QListViewItem*aItem)
{
    stringlist erg;
    PatternList Patterns;
    list_vector result;

    userdetailtext->setText("");

    if (!aItem) return;
    Patterns.push_back(CPatternPair(Host_Table,QT_TO_STL_STRING(aItem->text(0))
        ,"=",true));
    Patterns.push_back(CPatternPair(User_Table,QT_TO_STL_STRING(aItem->text(1))
        ,"=",true));
    erg.push_back("password");

    const char**rlist = sql_server->user_rights();
    for (int i = 0; rlist[i]!=0;++i) {
        erg.push_back(string(rlist[i])+"_priv");
    }
    erg.insert(erg.end(),cols_user_table_data.begin(),cols_user_table_data.end());

    stringlist namelist = erg;
    int i = sql_server->fetch_rows(DB_Name,User_Table,User_Table,false,erg,result,0,0,&Patterns,true);
    Patterns.clear();
    QString msg = "<b>Grants for "+aItem->text(1)+"@"+aItem->text(0)+":</b><br>";
    if (i != 0 || result.size()==0) {
        msg+="<font color=\"red\">";
        msg+=GET_TEXT(26);msg+="!</font></br>";
    } else {
        msg+="<table><tr><td><b>";
        msg+=GET_TEXT(27);msg+="</b></td><td>";
        msg+=(result[0][0].size()?i18n("Yes"):i18n("No"));
        msg+="</td</tr><tr valign=\"top\"><td><b>Grants:</b></td><td><table>";
        for (unsigned j=1; j<result[0].size();++j) {
            if (result[0][j]=="Y") {
                msg+="<tr><td>"+STL_TO_QT_STRING(namelist[j])+"</td></tr>";
            } else if (cols_user_table_data.find_nocase(namelist[j])!=cols_user_table_data.end()) {
                Patterns.push_back(CPatternPair(namelist[j],result[0][j]));
            }
        }
        msg+="</table></td></tr></table>";
        if (Patterns.size()>0) {
            msg+="<table>";
            for (unsigned j=0; j<Patterns.size();++j) {
                msg+="<tr><td>"+STL_TO_QT_STRING(Patterns[j].std_entry())
                    +": </td><td>"+STL_TO_QT_STRING(Patterns[j].std_pattern())+"</td></tr>";
            }
            msg+="</table>";
        }
    }
    userdetailtext->setText(msg);
}

void CAccessrights::hosthilighted(QListViewItem*aItem)
{
    stringlist erg;
    PatternList Patterns;
    list_vector result;

    hostdetailtext->setText("");

    if (!aItem) return;
    Patterns.push_back(CPatternPair(Host_Table,QT_TO_STL_STRING(aItem->text(0))
        ,"=",true));
    Patterns.push_back(CPatternPair(DB_Table,QT_TO_STL_STRING(aItem->text(1))
        ,"=",true));

    const char**rlist = sql_server->host_rights();
    for (int i = 0; rlist[i]!=0;++i) {
        erg.push_back(string(rlist[i])+"_priv");
    }
    stringlist namelist = erg;
    int i = sql_server->fetch_rows(DB_Name,Host_Table,Host_Table,false,erg,result,0,0,&Patterns,true);

    QString msg = "<b>Grants for users on "+aItem->text(0)+" to Database '"+aItem->text(1)+"':</b><br>";

    if (i != 0 || result.size()==0) {
        msg+="<font color=\"red\">";
        msg+=GET_TEXT(27);msg+="!</font></br>";
    } else {
        msg+="<table><tr><td><b>Grants:</b></td><td>";
        for (unsigned j=0; j<result[0].size();++j) {
            if (result[0][j]=="Y") {
                msg+=STL_TO_QT_STRING(namelist[j]);
                msg+="<br>";
            }
        }
        msg+="</td></tr></table>";
    }
    hostdetailtext->setText(msg);
}

void CAccessrights::dbhilighted(QListViewItem*aItem)
{
    stringlist erg;
    PatternList Patterns;
    list_vector result;

    dbdetailtext->setText("");

    if (!aItem) return;
    const char**rlist = sql_server->db_rights();

    for (int i = 0; rlist[i]!=0;++i) {
        erg.push_back(string(rlist[i])+"_priv");
    }

    stringlist namelist = erg;
    Patterns.push_back(CPatternPair(Host_Table,QT_TO_STL_STRING(aItem->text(0)),"=",true));
    Patterns.push_back(CPatternPair(User_Table,QT_TO_STL_STRING(aItem->text(1)),"=",true));
    Patterns.push_back(CPatternPair(DB_Table,QT_TO_STL_STRING(aItem->text(2)),"=",true));
    int i = sql_server->fetch_rows(DB_Name,DB_Table,User_Table,false,erg,result,0,0,&Patterns,true);
    QString msg = "<b>Grants for "+aItem->text(1)+"@"+aItem->text(0)+" on Database '"+aItem->text(2)+"':</b><br>";
    if (i != 0 || result.size()==0) {
        msg+="<font color=\"red\">Could not get infos!</font></br>";
    } else {
        msg+="<table><tr><td><b>Grants:</b></td><td>";
        for (unsigned j=0; j<result[0].size();++j) {
            if (result[0][j]=="Y") {
                msg+=STL_TO_QT_STRING(namelist[j]);
                msg+="<br>";
            }
        }
        msg+="</td></tr></table>";
    }
    dbdetailtext->setText(msg);
}

void CAccessrights::columnhilighted(QListViewItem*aItem)
{
    stringlist erg;
    PatternList Patterns;
    list_vector result;

    columndetailtext->setText("");

    if (!aItem) return;
    erg.push_back("Column_priv");
    erg.push_back("DATE_FORMAT(Timestamp,\'%d.%m. %H:%i\')");

    Patterns.push_back(CPatternPair(Host_Table,QT_TO_STL_STRING(aItem->text(0))
        ,"=",true));
    Patterns.push_back(CPatternPair(DB_Table,QT_TO_STL_STRING(aItem->text(2))
        ,"=",true));
    QString m=aItem->text(2);m+=".";
    Patterns.push_back(CPatternPair(User_Table,QT_TO_STL_STRING(aItem->text(1))
        ,"=",true));
    Patterns.push_back(CPatternPair(Tables_Name,QT_TO_STL_STRING(aItem->text(3))
        ,"=",true));
    m+=aItem->text(3);m+=".";
    Patterns.push_back(CPatternPair(Columns_Name,QT_TO_STL_STRING(aItem->text(4))
        ,"=",true));
    m+=aItem->text(4);

    int i = sql_server->fetch_rows(DB_Name,Columns_Table,User_Table,false,erg,result,0,0,&Patterns,true);
    QString msg = "<b>Grants for "+aItem->text(1)+"@"+aItem->text(0)+" on "+m+":</b><br>";
    if (i != 0 || result.size()==0) {
        msg+="<font color=\"red\">";
        msg+=GET_TEXT(26);msg+="!</font></br>";
    } else {
        msg+="<table><tr><td>&nbsp;</td><td>";
        if (result[0][0].size())
            msg+=STL_TO_QT_STRING(result[0][0]);
        else
            msg+="Reference";
        msg+="</td></tr><tr><td><b>Granted on:</b></td><td>";
        msg+=STL_TO_QT_STRING(result[0][1]);
        msg+="</td></tr></table>";
    }
    columndetailtext->setText(msg);
}

void CAccessrights::DeleteButton_clicked()
{
    switch (accesstabs->currentPageIndex()) {
    case 0:
        delete_host_entry();
        break;
    case 1:
        delete_user_entry();
        break;
    case 2:
        delete_db_entry();
        break;
    case 3:
        delete_table_entry();
        break;
    case 4:
        delete_column_entry();
        break;
    default:
        break;
    }
}

void CAccessrights::delete_column_entry()
{
    QListViewItem * item = columnsbox->currentItem();
    if (!item) {
        KMessageBox::error(0,GET_TEXT(25));
        return;
    }
    string host = QT_TO_STL_STRING(item->text(0));
    string user = QT_TO_STL_STRING(item->text(1));
    string database = QT_TO_STL_STRING(item->text(2));
    string table = QT_TO_STL_STRING(item->text(3));
    string column = QT_TO_STL_STRING(item->text(4));
    stringlist erg;
    PatternList Patterns;
    list_vector result;

    Patterns.push_back(CPatternPair(Host_Table,host,"=",true));
    Patterns.push_back(CPatternPair(DB_Table,database,"=",true));
    Patterns.push_back(CPatternPair(User_Table,user,"=",true));
    Patterns.push_back(CPatternPair(Tables_Name,table,"=",true));
    Patterns.push_back(CPatternPair(Columns_Name,column,"=",true));
    erg.push_back("Column_priv");
    int i = sql_server->fetch_rows(DB_Name,Columns_Table,User_Table,false,erg,result,0,0,&Patterns,true);
    if (i!=0 || result.size()==0) {
        KMessageBox::error(0,i18n("Error getting real entry!"));
        return;
    }
    stringstream msg;
    msg << GET_TEXT(29) << " " << user<<"@"<< host << " on\n"
        << database<<"."<<table<<"."<<column<<"?";
    i = KMessageBox::questionYesNo(0,STL_TO_QT_STRING(msg.str()));
    if (i == KMessageBox::No) {
        return;
    }
    msg.str("");
    erg = tfunctions::Explode()(result[0][0],",",false);
    unsigned j = 0;
    msg << "("<<column<<")";
    for (; j < erg.size();++j) {
        erg[j]=erg[j]+msg.str();
    }
    msg.str("");
    msg<<"References("<<column<<")";
    erg.push_back(msg.str());
    if (!sql_server->revoke_right(host,user,database,table,erg,true)) {
        KMessageBox::error(0,GET_TEXT(28));
    }
    ReadColumnTable();
}

void CAccessrights::delete_table_entry()
{
    QListViewItem * item = tablesbox->currentItem();
    if (!item) {
        KMessageBox::error(0,GET_TEXT(25));
        return;
    }
    string host = QT_TO_STL_STRING(item->text(0));
    string user = QT_TO_STL_STRING(item->text(1));
    string database = QT_TO_STL_STRING(item->text(2));
    string table = QT_TO_STL_STRING(item->text(3));
    stringlist erg;
    PatternList Patterns;
    list_vector result;

    stringstream msg;
    msg << GET_TEXT(29) << "\n" << user<<"@"<< host << "\non\n"
        << database<<"."<<table<<"?";
    int i = KMessageBox::questionYesNo(0,STL_TO_QT_STRING(msg.str()));
    if (i == KMessageBox::No) {
        return;
    }
    msg.str("");
    erg.clear();
    erg.push_back(CAddmysqluser::ALL);

    if (!sql_server->revoke_right(host,user,database,table,erg,true)) {
        KMessageBox::error(0,GET_TEXT(28));
    } else if (last_table_has_grant) {
        erg.clear();
        erg.push_back("GRANT OPTION");
        if (!sql_server->revoke_right(host,user,database,table,erg,true)) {
            KMessageBox::error(0,GET_TEXT(28));
        }
    }
    ReadColumnTable();
    ReadTablesTable();
}

void CAccessrights::delete_db_entry()
{
    QListViewItem * item = dbbox->currentItem();
    if (!item) {
        KMessageBox::error(0,GET_TEXT(25));
        return;
    }
    string host = QT_TO_STL_STRING(item->text(0));
    string user = QT_TO_STL_STRING(item->text(1));
    string database = QT_TO_STL_STRING(item->text(2));

    stringlist erg;
    PatternList Patterns;
    list_vector result;

    Patterns.push_back(CPatternPair(Host_Table,host,"=",true));
    Patterns.push_back(CPatternPair(DB_Table,database,"=",true));
    Patterns.push_back(CPatternPair(User_Table,user,"=",true));

    stringstream msg;

    msg << GET_TEXT(29) << "\n" << user<<"@"<< host << "\non\n"
        << database<<"."<<"*?";
    int i = KMessageBox::questionYesNo(0,STL_TO_QT_STRING(msg.str()));
    if (i == KMessageBox::No) {
        return;
    }
    sql_server->delete_row(DB_Name,DB_Table,&Patterns);
    sql_server->refresh_grants();
    ReadDBTable();
}

void CAccessrights::delete_user_entry()
{
    QListViewItem * item = usersbox->currentItem();
    if (!item) {
        KMessageBox::error(0,GET_TEXT(25));
        return;
    }
    string host = QT_TO_STL_STRING(item->text(0));
    string user = QT_TO_STL_STRING(item->text(1));

    stringlist erg;
    PatternList Patterns;
    list_vector result;

    Patterns.push_back(CPatternPair(Host_Table,host,"=",true));
    Patterns.push_back(CPatternPair(User_Table,user,"=",true));

    stringstream msg;

    msg << GET_TEXT(29) << "\n" << user<<"@"<< host << "\non all databases and tables?";
    int i = KMessageBox::questionYesNo(0,STL_TO_QT_STRING(msg.str()));
    if (i == KMessageBox::No) {
        return;
    }
    sql_server->delete_row(DB_Name,DB_Table,&Patterns);
    sql_server->delete_row(DB_Name,Tables_Table,&Patterns);
    sql_server->delete_row(DB_Name,Columns_Table,&Patterns);
    sql_server->delete_row(DB_Name,User_Table,&Patterns);
    sql_server->refresh_grants();
    RefreshLists();
}

void CAccessrights::delete_host_entry()
{
    QListViewItem * item = hostsbox->currentItem();
    if (!item) {
        KMessageBox::error(0,GET_TEXT(25));
        return;
    }
    string host = QT_TO_STL_STRING(item->text(0));
    string database = QT_TO_STL_STRING(item->text(1));

    stringlist erg;
    PatternList Patterns;
    list_vector result;

    Patterns.push_back(CPatternPair(Host_Table,host,"=",true));
    Patterns.push_back(CPatternPair(DB_Table,database,"=",true));
    QString s = i18n("<center>Do you realy want to delete the rights for all users on<br><b>%1</b><br>to database<br><b>%2</b>?</center>");
    int i = KMessageBox::questionYesNo(0,
        s.arg(STL_TO_QT_STRING(host)).arg(STL_TO_QT_STRING(database)));
    if (i == KMessageBox::No) {
        return;
    }
    sql_server->delete_row(DB_Name,Host_Table,&Patterns);
    sql_server->refresh_grants();
    ReadHostTable();
}

void CAccessrights::AddButton_clicked()
{
    switch (accesstabs->currentPageIndex()) {
    case 0:
        add_host();
        break;
    case 1:
    default:
        add_user();
        break;
    }
}

void CAccessrights::add_user()
{
    CAddmysqluser adduser(sql_server,0,"adduser");
    if (adduser.exec()) {
        string user = adduser.user();
        string host =adduser.host();
        string password=adduser.password();
        string database = adduser.database();
        string table = adduser.table();
        stringlist rights = adduser.set_rights();
        stringlist*extra_rights = 0;
        stringstream cmd,out;
        PatternList update_patterns;

        if (database==CAddmysqluser::JOKER) {
            extra_rights=&cols_user_table_ext;
        } else if (table==CAddmysqluser::JOKER) {
            extra_rights=&cols_host_table_ext;
        }

        cmd << "GRANT ";
        for (unsigned int c=0; c < rights.size();++c) {
            if (extra_rights && extra_rights->find_nocase(rights[c])!=extra_rights->end()) {
                update_patterns.push_back(CPatternPair(rights[c]+"_priv","Y"));
                continue;
            }
            if (c!=0) cmd << ",";
            cmd << rights[c];
        }
        if (update_patterns.size()==rights.size()) {
            cmd << "USAGE";
        }
        cmd << " ON " << database << "." << table << " TO '" << user << "'@'"<<host<<"' ";
        out << cmd.str();
        if (password.size()>0) {
            cmd << "identified by '"<<password<<"'";
            out << "identified by '******'";
        }
        if (adduser.grant() ||
            (sql_server->master_version()>3 && database==CAddmysqluser::JOKER && table==CAddmysqluser::JOKER)) {
            cmd << " WITH ";
            out << " WITH ";
            if (adduser.grant()) {
                cmd << " GRANT OPTION";
                out << " GRANT OPTION";
            }
            if (sql_server->master_version()>3&& database==CAddmysqluser::JOKER && table==CAddmysqluser::JOKER) {
                cmd << " MAX_QUERIES_PER_HOUR " << adduser.maxQueries()
                << " MAX_UPDATES_PER_HOUR " << adduser.maxUpdates()
                << " MAX_CONNECTIONS_PER_HOUR " << adduser.maxConnections();
                out << " MAX_QUERIES_PER_HOUR " << adduser.maxQueries()
                << " MAX_UPDATES_PER_HOUR " << adduser.maxUpdates()
                << " MAX_CONNECTIONS_PER_HOUR " << adduser.maxConnections();
            }
        }
        list_vector target;
        stringlist headers;
        if (sql_server->do_statement(cmd.str(),target,headers,true)) {
            sql_server->do_message(out.str());
            if (update_patterns.size()) {
                PatternList KeyList;
                KeyList.push_back(CPatternPair("User",user,"="));
                KeyList.push_back(CPatternPair("Host",host,"="));
                if (database!=CAddmysqluser::JOKER) {
                    KeyList.push_back(CPatternPair("Db",database,"="));
                    table = CAccessrights::DB_Table;
                }else{
                    table = CAccessrights::User_Table;
                }
                sql_server->update_row("mysql",table,&update_patterns,&KeyList);
                sql_server->refresh_grants();
            }
        }
        RefreshLists();
    }
}

void CAccessrights::add_host()
{
    CAddmysqlhost addhost(sql_server,0,"addhost");
    if (addhost.exec()) {
        string host = addhost.host();
        string db = addhost.db();
        stringlist rights = addhost.rights();
        PatternList pats;
        pats.push_back(CPatternPair("Db",db));
        pats.push_back(CPatternPair("Host",host));
        for (unsigned int c=0; c<rights.size();++c) {
            pats.push_back(CPatternPair(rights[c]+"_priv","y"));
        }
        if (!sql_server->insert_row("mysql","host",&pats)) {
            KMessageBox::error(0,"<center>Error while inserting</center>");
        } else {
            sql_server->refresh_grants();
        }
        ReadHostTable();
    }
}

void CAccessrights::EditButton_clicked()
{
    switch (accesstabs->currentPageIndex()) {
    case 0:
        modify_host();
        break;
    case 1:
    case 2:
    case 3:
    case 4:
        modify_user(accesstabs->currentPageIndex());
        break;
    default:
        KMessageBox::error(0,"<H2>Sorry</h2>But not yet implemented. Please delete and reenter for edit user with this box.");
        break;
    }
}

/** No descriptions */
void CAccessrights::modify_host()
{
    QListViewItem * item = hostsbox->currentItem();
    if (!item) {
        KMessageBox::error(0,GET_TEXT(25));
        return;
    }
    string host = QT_TO_STL_STRING(item->text(0));
    string database = QT_TO_STL_STRING(item->text(1));
    stringlist erg;
    PatternList Patterns;
    list_vector result;

    Patterns.push_back(CPatternPair(Host_Table,host,"=",true));
    Patterns.push_back(CPatternPair(DB_Table,database,"=",true));

    const char**rlist = sql_server->host_rights();
    for (int i = 0; rlist[i]!=0;++i) {
        erg.push_back(string(rlist[i])+"_priv");
    }
    stringlist namelist = erg;
    int i = sql_server->fetch_rows(DB_Name,Host_Table,Host_Table,false,erg,result,0,0,&Patterns,true);
    if (i != 0 || result.size()==0) {
        KMessageBox::error(0,GET_TEXT(26));
        return;
    }
    erg.clear();
    size_t pos;
    bool cgrant=false;
    for (unsigned j=0; j<result[0].size();++j) {
        if (result[0][j]=="Y") {
            pos = namelist[j].find("_");
            if (pos != string::npos) {
                if (Caseequ()(namelist[j].substr(0,pos),CAddmysqluser::GRANT)) {
                    cgrant = true;
                } else {
                    erg.push_back(namelist[j].substr(0,pos));
                }
            } else {
                erg.push_back(namelist[j]);
            }
        }
    }
    CAddmysqlhost addhost(sql_server,host,database,erg,cgrant,0,"modifyhost");
    if (addhost.exec()) {
        Patterns.clear();
        Patterns.push_back(CPatternPair(Host_Table,host,"=",true));
        Patterns.push_back(CPatternPair(DB_Table,database,"=",true));

        PatternList what;
        stringlist::iterator p;
        stringlist rights = addhost.rights();
        string d;
        unsigned c;
        for (c=0; c<rights.size();++c) {
            d = rights[c]+"_priv";
            what.push_back(CPatternPair(d,"y"));
            p = find_if(namelist.begin(),namelist.end(),Caseequif(d));
            if (p!=namelist.end()) namelist.erase(p);
        }
        for (c=0; c < namelist.size(); ++c) {
            what.push_back(CPatternPair(namelist[c],"n"));
        }
        if (!sql_server->update_row("mysql","host",&what,&Patterns)) {
            KMessageBox::error(0,"<center>Error while update</center>");
        } else {
            sql_server->refresh_grants();
        }
        ReadHostTable();
    }
}

void CAccessrights::modify_user(int type)
{
    stringlist erg,revoke_list,grant_list;
    stringlist * special_rights = 0;
    PatternList Patterns;
    list_vector result;
    string database,table,oldpw,stable,column;
    const char**rlist;

    QListViewItem * item = 0;

    switch (type) {
    case 1:
        item = usersbox->currentItem();
        stable = User_Table;
        rlist = sql_server->user_rights();
        erg.push_back("password");
        special_rights = &cols_user_table_ext;
        break;
    case 2:
        item = dbbox->currentItem();
        stable = DB_Table;
        rlist = sql_server->db_rights();
        special_rights = &cols_host_table_ext;
        break;
    case 3:
        item = tablesbox->currentItem();
        stable = Tables_Table;
        erg.push_back("Table_priv");
        rlist = sql_server->table_rights();
        break;
    case 4:
        item = columnsbox->currentItem();
        stable = Columns_Table;
        erg.push_back("Column_priv");
        rlist = sql_server->column_rights();
        break;
    default:
        /* avoid compiler warnings */
        rlist = 0;
        KMessageBox::error(0,GET_TEXT(25));
        return;
        break;
    }

    if (type < 3) {
        for (int i = 0; rlist[i]!=0;++i) {
            erg.push_back(string(rlist[i])+"_priv");
        }
    }
    if (type==1) {
        erg.insert(erg.end(),cols_user_table_data.begin(),cols_user_table_data.end());
    }

    string host = QT_TO_STL_STRING(item->text(0));
    string user = QT_TO_STL_STRING(item->text(1));
    database = CAddmysqluser::JOKER;
    table = CAddmysqluser::JOKER;
    column = "";

    if (type>1) {
        database = QT_TO_STL_STRING(item->text(2));
    }
    if (type>2) {
        table = QT_TO_STL_STRING(item->text(3));
    }
    if (type>3) {
        column = QT_TO_STL_STRING(item->text(4));
    }

    Patterns.push_back(CPatternPair(Host_Table,host
        ,"=",true));
    Patterns.push_back(CPatternPair(User_Table,user
        ,"=",true));
    if (type>1) {
        Patterns.push_back(CPatternPair(DB_Table,database
            ,"=",true));
    }
    if (type>2) {
        Patterns.push_back(CPatternPair(Tables_Name,table
            ,"=",true));
    }
    if (type>3) {
        Patterns.push_back(CPatternPair(Columns_Name,column
            ,"=",true));
    }
    stringlist namelist = erg;
    int i = sql_server->fetch_rows(DB_Name,stable,User_Table,false,erg,result,0,0,&Patterns,false);
    if (i != 0 || result.size()==0) {
        KMessageBox::error(0,GET_TEXT(26));
        return;
    }
    erg.resize(0);
    size_t pos;
    string sub;
    bool had_grant = false;
    int old_max_connections,old_max_queries,old_max_updates;
    old_max_connections=old_max_queries=old_max_updates=0;

    if (type>2) {
        string r = result[0][0];
        result[0]=tfunctions::Explode()(r,",",false);
        for (unsigned j=0; j<result[0].size();++j) {
            sub = result[0][j];
            if (Caseequ()(sub,CAddmysqluser::GRANT) == 1) {
                had_grant = true;
            } else {
                erg.push_back(sub);
            }
        }
    } else {
        unsigned j = (type==1?1:0);
        for (; j<result[0].size();++j) {
            if (result[0][j]=="Y") {
                pos = namelist[j].find("_priv");
                sub = namelist[j];
                if (pos != string::npos) {
                    sub.erase(pos,5);
                }
                if (Caseequ()(sub,CAddmysqluser::GRANT) == 1) {
                    had_grant = true;
                } else {
                    erg.push_back(sub);
                }
            } else if (type==1 && cols_user_table_data.find_nocase(namelist[j])!=cols_user_table_data.end()) {
                //qDebug("Habe %s entdeckt.",namelist[j].c_str());
                if (Caseequ()(namelist[j],MaxQuestions)) {
                    old_max_queries=::atoi(result[0][j].c_str());
                } else if (Caseequ()(namelist[j],MaxConnections)) {
                    old_max_connections = ::atoi(result[0][j].c_str());
                } else if (Caseequ()(namelist[j],MaxUpdates)) {
                    old_max_updates = ::atoi(result[0][j].c_str());
                }
            }
        }
    }
    if (type == 1) {
        oldpw = result[0][0];
    } else {
        oldpw = "";
    }
    CChangemysqluser cuser(user,host,oldpw,database,table,column,erg,had_grant,sql_server,0,"changeuser");
    if (type==1 && sql_server->master_version()>3) {
        cuser.setMaxConnections(old_max_connections);
        cuser.setMaxQueries(old_max_queries);
        cuser.setMaxUpdates(old_max_updates);
    }
    if (!cuser.exec()) {
        return;
    }
    string password=cuser.password();
    stringlist rights = cuser.set_rights();

    PatternList extra_rights;

    database = cuser.database();
    table = cuser.table();

    bool has_grant = cuser.grant();
    int max_updates, max_questions, max_connections;
    max_updates=max_questions=max_connections=0;
    if (type==1 && sql_server->master_version()>3) {
        max_updates = cuser.maxUpdates();
        max_questions = cuser.maxQueries();
        max_connections= cuser.maxConnections();
    }
    if (rights.size()==1 && Caseequ()(rights[0],CAddmysqluser::ALL) && erg.size()!=0) {
        rights.clear();
        for (unsigned j=0; rlist[j]!=0;++j) {
            if (Caseequ()(rlist[j],CAddmysqluser::GRANT))
                continue;
            rights.push_back(rlist[j]);
        }
    }
    stringlist::const_iterator it = rights.begin();
    for (;it!=rights.end();++it) {
        if (erg.find_nocase(*it)==erg.end()) {
            if (special_rights && special_rights->find_nocase(*it)!=special_rights->end()) {
                extra_rights.push_back(CPatternPair(*it+"_priv","Y"));
            } else {
                grant_list.push_back(*it);
            }
        }
    }
    it = erg.begin();
    for (;it!=erg.end();++it) {
        if (rights.find_nocase(*it)==rights.end()) {
            if (special_rights && special_rights->find_nocase(*it)!=special_rights->end()) {
                extra_rights.push_back(CPatternPair(*it+"_priv","N"));
            } else {
                revoke_list.push_back(*it);
            }
        }
    }
    if (grant_list.size()==0 && (oldpw!=password ||
            old_max_connections!=max_connections ||
            old_max_queries!=max_questions||
            old_max_updates!=max_updates)) {
            grant_list.push_back("Usage");
    }
    erg.clear();
    stringstream cmd("");
    bool pwswitched = false;

    if (column.size()) {
        column = string("(")+column+string(")");
    }
    /* first: create the grant statement */
    if (grant_list.size()>0) {
        cmd << CAddmysqluser::GRANT << " ";
        for (unsigned int c=0; c < grant_list.size();++c) {
            if (c!=0) cmd << ",";
            cmd << grant_list[c] << column;
        }
        cmd << " ON " << database << "." << table << " TO '" << user << "'@'"<<host<<"'";
        if (old_max_connections!=max_connections ||
            old_max_queries!=max_questions||
            old_max_updates!=max_updates) {
            cmd << " WITH MAX_QUERIES_PER_HOUR "<<max_questions
                << " MAX_UPDATES_PER_HOUR "<< max_updates
                << " MAX_CONNECTIONS_PER_HOUR "<< max_connections;
        }
        erg.push_back(cmd.str());
    }
    if (revoke_list.size()>0) {
        cmd.str("");
        cmd << "REVOKE ";
        for (unsigned int c= 0; c < revoke_list.size();++c) {
            if (c!=0) cmd << ",";
            cmd << revoke_list[c] << column;
        }
        cmd << " ON " << database << "." << table << " FROM '" << user << "'@'"<<host<<"'";
        erg.push_back(cmd.str());
    }
    if (had_grant && !has_grant) {
        cmd.str("");
        cmd << "REVOKE GRANT OPTION ON " << database << "." << table << " FROM '" << user
            << "'@'" << host << "'";
        erg.push_back(cmd.str());
    } else if (!had_grant && has_grant) {
        cmd.str("");
        cmd << "GRANT GRANT OPTION ON " << database << "." << table << " TO '" << user
            << "'@'" << host << "'";
        erg.push_back(cmd.str());
    }
    if (password!=oldpw) {
        pwswitched = true;
        cmd.str("");
        cmd << "SET PASSWORD for '"<<user<<"'@'"<<host<<"' = PASSWORD('"<<password<<"')";
        erg.push_back(cmd.str());
    }
    if (erg.size()) {
        list_vector target;
        stringlist headers;
        for (unsigned int c=0; c < erg.size();++c) {
            if (sql_server->do_statement(erg[c],target,headers,true)) {
                //sql_server->do_message(erg[c]);
            }
        }
    }
    if (extra_rights.size()) {
        pwswitched = true;
        PatternList KeyList;
        KeyList.push_back(CPatternPair("User",user,"="));
        KeyList.push_back(CPatternPair("Host",host,"="));
        if (database!=CAddmysqluser::JOKER) {
            KeyList.push_back(CPatternPair("Db",database,"="));
            table = CAccessrights::DB_Table;
        }else{
            table = CAccessrights::User_Table;
        }
        sql_server->update_row("mysql",table,&extra_rights,&KeyList);
    }

    if (pwswitched) {
        sql_server->refresh_grants();
    }
    switch (type) {
    case 1:
        userhilighted(item);
        break;
    case 2:
        dbhilighted(item);
        break;
    case 3:
        tablehilighted(item);
        break;
    case 4:
        columnhilighted(item);
        break;
    default:
        break;
    }
 }

void CAccessrights::showHelp()
{
    KApplication::kApplication()->invokeHelp("kmysqladmin-userrights");
}

void CAccessrights::standalone(bool how)
{
    if (how) {
        closeButton->show();
        help_button->show();
    } else {
        closeButton->hide();
        help_button->hide();
    }
}
