#include "connection_profiles.h"
#include "profiles_input.h"
#include "kmysqladmin/setup/settings.h"
#include "kmysqladmin/setup/settings_defines.h"
#include <klistbox.h>
#include <klocale.h>
#include <qlabel.h>
#include <kmessagebox.h>

ConnectionProfiles::ConnectionProfiles( QWidget* parent, const char* name, WFlags fl )
    : ConnectionProfilesData( parent, name, true, fl )
{
    initList();
}

void ConnectionProfiles::initList()
{
    m_Profiles = GlobalSettings.getConnectProfilesList();
    m_ProfileList->clear();
    m_ProfileList->insertStringList(m_Profiles);
}

/*
 *  Destroys the object and frees any allocated resources
 */
ConnectionProfiles::~ConnectionProfiles()
{
    
}


/*!
    \fn ConnectionProfiles::addProfile
 */
void ConnectionProfiles::addProfile()
{
    CProfilesInput dlg(m_Profiles);
    if (dlg.exec() == QDialog::Accepted ) {
        GlobalSettings.addConnectProfile(dlg.values());
        initList();
    }
}


/*!
    \fn ConnectionProfiles::changeProfile
 */
void ConnectionProfiles::changeProfile()
{
    QString current = m_ProfileList->currentText();
    if (current.isEmpty()) return;
    QMap<QString,QString> vals = GlobalSettings.getConnectProfile(current);
    vals[Settings_defines::_PROFILES_name]=current;
    CProfilesInput dlg(vals,m_Profiles);
    if (dlg.exec() == QDialog::Accepted ) {
        vals = dlg.values();
        if (vals[Settings_defines::_PROFILES_name]!=current) {
            GlobalSettings.deleteConnectProfile(current);
        }
        GlobalSettings.addConnectProfile(vals);
        initList();
    }
}
/*!
    \fn ConnectionProfiles::deleteProfile
 */
void ConnectionProfiles::deleteProfile()
{
    QString current = m_ProfileList->currentText();
    if (current.isEmpty()) return;
    QString msg = i18n("Realy delete profile %1").arg("\""+current+"\"")+"?";
    if (KMessageBox::questionYesNo(0,msg)==KMessageBox::Yes) {
        GlobalSettings.deleteConnectProfile(current);
        initList();
    }
}
/*!
    \fn ConnectionProfiles::itemExecuted(QListBoxItem*aItem)
 */
void ConnectionProfiles::itemExecuted(QListBoxItem*)
{
    changeProfile();
}


/*!
    \fn ConnectionProfiles::selChange(QListBoxItem*aItem)
 */
void ConnectionProfiles::selChange(QListBoxItem*aItem)
{
    QString current = aItem->text();
    QMap<QString,QString> vals = GlobalSettings.getConnectProfile(current);
    QString msg = vals[Settings_defines::_PROFILES_user]+"@"+
        vals[Settings_defines::_PROFILES_host]+":"+
        vals[Settings_defines::_PROFILES_port]+"\n"+
        i18n("Password")+": "+(vals[Settings_defines::_PROFILES_pass].length()>0?i18n("Yes"):i18n("No"));
    m_details->setText(msg);
}
