//
// C++ Interface: kpggroup
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGGROUP_H
#define KPGGROUP_H

#include "kpgtreeitem.h"

#include <qstringlist.h> 

class KPGGroupsFolder;

/**
  * Group of users
  *
  * @author Lumir Vanek
  */
class KPGGroup : public KPGTreeItem
{
public:
    KPGGroup(KPGGroupsFolder *, const QString);
	KPGGroup(KPGGroupsFolder *, KPGGroup *, const QString);
    ~KPGGroup();

	virtual eNodeType type() const { return nodeGroup; }
	
	void setProperties(const pqxx::result::tuple &);
	
	QStringList & getListOfUsers() { return m_strListOfUsers; }
	
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return; }
	
	/*
	 * Functions for accessing properties
	 */
	int sysId() const { return m_iSysId; }
	const QStringList & listOfUsers() const { return m_strListOfUsers; }
		
protected:

	/*
	 * Properties
	 */
	int m_iSysId; 
	QStringList m_strListOfUsers;
};

#endif
