//
// C++ Implementation: kpgoperatorsfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgoperatorsfolder.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgschema.h"
#include "kpgoperator.h"
#include "kpgserver.h"


KPGOperatorsFolder::KPGOperatorsFolder(KPGSchema *parent, pqxx::oid oidNameSpace)
	: KPGItemsFolder(parent, i18n("Operators"), m_pIconFolderYellowClosed, m_pIconFolderYellowOpen)
{
	m_oidNameSpace = oidNameSpace;
}


KPGOperatorsFolder::~KPGOperatorsFolder()
{
}

void KPGOperatorsFolder::refresh() throw(const KPGSqlException &)
{
    // delete all child items 
    while (QListViewItem * pItem = firstChild())
        delete pItem;
    
    // Get pointer to server for version info
    KPGServer *pServer = static_cast <KPGServer *> (parent()->parent()->parent());
    
    bool bVersion83_OrNewer = false;
    
    // Is it 8.1 or newer ?
	if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 3)) || ((pServer->versionMajor() > 8))) 
	{
		bVersion83_OrNewer = true;
	}
    
    // obtain list of operators
    QString strQuery("SELECT op.oid, op.oprname, description, op.oprkind, op.oprcanhash, op.oprleft, lt.typname as lefttype, op.oprright, rt.typname as righttype, op.oprresult, \
ret.typname as resulttype, op.oprcom, co.oprname as compop, op.oprnegate, ne.oprname as negop, op.oprcode::oid AS oprcodeoid, op.oprcode as \
    operproc, op.oprrest::oid AS oprrestoid, op.oprrest as restrproc, op.oprjoin::oid AS oprjoinoid, op.oprjoin as joinproc, pg_get_userbyid(op.oprowner) as opowner ");
            
    if(bVersion83_OrNewer == false)
    {
    	strQuery.append(", op.oprlsortop, lso.oprname as leftsortop, op.oprrsortop, rso.oprname as rightsortop, op.oprltcmpop, lco.oprname as lessthancmpop, op.oprgtcmpop, gco.oprname as greatherthancmpop ");
    }        
            
	strQuery.append("FROM pg_catalog.pg_operator op ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_type lt ON lt.oid=op.oprleft ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_type rt ON rt.oid=op.oprright ");
	strQuery.append("JOIN pg_catalog.pg_type ret on ret.oid=op.oprresult ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=op.oid ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_operator co ON co.oid=op.oprcom ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_operator ne ON ne.oid=op.oprnegate ");
	
	if(bVersion83_OrNewer == false)
    {
		strQuery.append("LEFT OUTER JOIN pg_catalog.pg_operator lso ON lso.oid=op.oprlsortop ");
		strQuery.append("LEFT OUTER JOIN pg_catalog.pg_operator rso ON rso.oid=op.oprrsortop ");
		strQuery.append("LEFT OUTER JOIN pg_catalog.pg_operator lco ON lco.oid=op.oprltcmpop ");
		strQuery.append("LEFT OUTER JOIN pg_catalog.pg_operator gco ON gco.oid=op.oprgtcmpop ");
	}
	
	strQuery.append("WHERE op.oprnamespace = " + QString("%1").arg(m_oidNameSpace) + " ");
	strQuery.append("ORDER BY op.oprname");
			
    try
    {
        m_pqxxResultOperators = connection()->runQuery(strQuery);
    
        KPGOperator *pOperator = 0;
            
        for (result::size_type i = 0; i != m_pqxxResultOperators.size(); ++i)
        {
            pqxx::oid oid;
            m_pqxxResultOperators[i][0].to(oid);
            
            if(pOperator == 0)
                pOperator = new KPGOperator(this, m_pqxxResultOperators[i]["oprname"].c_str(), oid);
            else
                pOperator = new KPGOperator(this, pOperator, m_pqxxResultOperators[i]["oprname"].c_str(), oid);
                        
            pOperator->setProperties(m_pqxxResultOperators[i], bVersion83_OrNewer);
        }
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(e.what(), strQuery);
    } 
}
