//
// C++ Interface: kpgsequence
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGSEQUENCE_H
#define KPGSEQUENCE_H

#include "kpgobject.h"

class KPGSequencesFolder;

/**
  * Sequence
  *
  * @author Lumir Vanek
  */
class KPGSequence : public KPGObject
{
public:
    KPGSequence(KPGSequencesFolder *, const QString, pqxx::oid);
	KPGSequence(KPGSequencesFolder *, KPGSequence *, const QString, pqxx::oid);
    ~KPGSequence();
	
	virtual eNodeType type() const { return nodeSequence; }
	
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "SEQUENCE"; }
  	
	void setProperties(const pqxx::result::tuple &);
	void setSeqValues(const pqxx::result::tuple &);
		
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return refreshItem(); }
  	
  	// Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &);
	
	const pqxx::result queryIoStatistics() throw(const KPGSqlException &);
	
	/*
	 * Functions for accessing properties
	 */
	const QString & acl() const { return m_strACL; }
	const QString & owner() const { return m_strOwner; }
	long long lastValue() const { return m_llLastValue; }
	long long minValue() const { return m_llMinValue; }
	long long maxValue() const { return m_llMaxValue; }
	long long cacheValue() const { return m_llCacheValue; }
	bool isCycled() const { return m_bIsCycled; }
	int incrementBy() const { return m_iIncrementBy; }
	
protected:

	/*
	 * Properties
	 */
	QString m_strOwner;
	QString m_strACL;
	
	long long m_llLastValue;
	long long m_llMinValue; 
	long long m_llMaxValue; 
	long long m_llCacheValue; 
	bool m_bIsCycled; 
	int m_iIncrementBy;
};

#endif
