/***************************************************************************
                          kpgtablecolumn  -  description
                             -------------------
    begin                : So no 7 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kpgtablecolumn.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgdatabase.h"
#include "kpgtablecolumnsfolder.h"


KPGTableColumn::KPGTableColumn(KPGTableColumnsFolder *parent, const QString name)
  : KPGTreeItem(parent, name)
{
 	setPixmap(0, *m_pIconColumnOther);
}

KPGTableColumn::KPGTableColumn(KPGTableColumnsFolder *parent, KPGTableColumn *after, const QString name)
  : KPGTreeItem(parent, after, name)
{
 	setPixmap(0, *m_pIconColumnOther);
}

KPGTableColumn::~KPGTableColumn()
{
}

// Refresh only column info, without childs objects
void KPGTableColumn::refreshItem() throw(const KPGSqlException &)
{
	// Get pointer to owner table and database
	KPGTable *pTable = static_cast <KPGTable *> (parent()->parent());
	
	QString strQuery("SELECT a.attname, atttypid, ty.typname, ty.typbasetype, a.attlen, ");
		
	strQuery.append("a.attstattarget, a.attnum, a.attndims, a.atttypmod, a.attbyval, a.attnotnull, a.atthasdef, a.attisdropped, a.attislocal, CASE WHEN a.attstorage = 'p' THEN 'PLAIN' WHEN a.attstorage = 'e' THEN 'EXTERNAL' WHEN a.attstorage = 'm' THEN 'MAIN' WHEN a.attstorage = 'x' THEN 'EXTENDED' END AS attstorage, a.attinhcount, ");
	
	strQuery.append("def.adsrc, tn.nspname, description");
	
	strQuery.append(" FROM pg_catalog.pg_attribute a");
	strQuery.append(" JOIN pg_catalog.pg_type ty ON ty.oid=a.atttypid");
	strQuery.append(" JOIN pg_catalog.pg_namespace tn ON tn.oid=ty.typnamespace");
	strQuery.append(" JOIN pg_catalog.pg_class cl ON cl.oid=a.attrelid");
	//strQuery.append(" JOIN pg_catalog.pg_namespace na ON na.oid=cl.relnamespace");
	strQuery.append(" LEFT OUTER JOIN pg_catalog.pg_type et ON et.oid=ty.typelem");
	strQuery.append(" LEFT OUTER JOIN pg_catalog.pg_attrdef def ON adrelid=a.attrelid AND adnum=a.attnum");
	strQuery.append(" LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=attrelid AND des.objsubid=attnum");
	strQuery.append(" WHERE attrelid = ");
	strQuery.append(QString("%1").arg(pTable->oid()));
	strQuery.append(" AND a.attname='" + text(0) + "'");
	
	try
	{
    	pqxx::result pqxxResultColumns = connection()->runQuery(strQuery);

		if(pqxxResultColumns.size() != 1)
		{
			kdError() << k_funcinfo "Expect one row in result !" <<  endl;
			return;
		}
		
		setProperties(pqxxResultColumns[0]);
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
}

void KPGTableColumn::setProperties(const pqxx::result::tuple &pqxxTuple)
{
	pqxxTuple["atttypid"].to(m_oidType);
	pqxxTuple["typbasetype"].to(m_oidBaseType);
	pqxxTuple["attbyval"].to(m_bByVal);
	pqxxTuple["attnotnull"].to(m_bNotNull);
	pqxxTuple["atthasdef"].to(m_bHasDef);
	pqxxTuple["attisdropped"].to(m_bIsDropped);
	pqxxTuple["attislocal"].to(m_bIsLocal);
	pqxxTuple["attstattarget"].to(m_lStatTarget);
	pqxxTuple["attlen"].to(m_iAttLen);
	pqxxTuple["attnum"].to(m_iAttNum);
	pqxxTuple["attndims"].to(m_iAttNdims);
	pqxxTuple["atttypmod"].to(m_iAttTypmod);
	pqxxTuple["attinhcount"].to(m_iInhCount);
			
	m_strTypName = pqxxTuple["typname"].c_str();
	m_strDescription = pqxxTuple["description"].c_str();
	m_strStorage = pqxxTuple["attstorage"].c_str();
	m_strAdSrc = pqxxTuple["adsrc"].c_str();
	m_strNspName = pqxxTuple["nspname"].c_str();
	
	//--- Set column type icon ---------------------------------------------------
	if((m_strTypName == "bpchar") || (m_strTypName == "varchar") || (m_strTypName == "text"))
	{
		setPixmap(0, *m_pIconColumnChar);
		return;
	}
	
	if((m_strTypName == "int") || (m_strTypName == "int2") || (m_strTypName == "int4") || (m_strTypName == "int8") || (m_strTypName == "float4") || (m_strTypName == "float8") || (m_strTypName == "numeric") || (m_strTypName == "serial4") || (m_strTypName == "serial8") || (m_strTypName == "money"))
	{
		setPixmap(0, *m_pIconColumnNum);
		return;
	}
			
	if((m_strTypName == "bool"))
	{
		setPixmap(0, *m_pIconColumnBool);
		return;
	}
	
	if((m_strTypName == "time") || (m_strTypName == "timetz") || (m_strTypName == "interval"))
	{
		setPixmap(0, *m_pIconColumnTime);
		return;
	}
	
	if((m_strTypName == "date") || (m_strTypName == "timestamp") || (m_strTypName == "timestamptz"))
	{
		setPixmap(0, *m_pIconColumnDate);
		return;
	}
	
	if((m_strTypName == "point") || (m_strTypName == "line") || (m_strTypName == "lseg") || (m_strTypName == "box") || (m_strTypName == "path") || (m_strTypName == "polygon") || (m_strTypName == "circle"))
	{
		setPixmap(0, *m_pIconColumnGeo);
		return;
	}
	
	if((m_strTypName == "bit") || (m_strTypName == "varbit"))
	{
		setPixmap(0, *m_pIconColumnBit);
		return;
	}
	
	if((m_strTypName == "bytea"))
	{
		setPixmap(0, *m_pIconColumnBin);
		return;
	}
	
	if((m_strTypName == "cidr") || (m_strTypName == "inet") || (m_strTypName == "macaddr"))
	{
		setPixmap(0, *m_pIconColumnNet);
		return;
	}
	
	if((m_strTypName == "xml"))
	{
		setPixmap(0, *m_pIconColumnXml);
		return;
	}
	
	if((m_strTypName == "uuid"))
	{
		setPixmap(0, *m_pIconColumnUuid);
		return;
	}
	
	//----------------------------------------------------------------------------
	
	if((m_strTypName == "oid"))
	{
		setPixmap(0, *m_pIconColumnOid);
		return;
	}
	
	if((m_strTypName == "xid"))
	{
		setPixmap(0, *m_pIconColumnXid);
		return;
	}
	
	if((m_strTypName == "tid"))
	{
		setPixmap(0, *m_pIconColumnTid);
		return;
	}
	
	if((m_strTypName == "cid"))
	{
		setPixmap(0, *m_pIconColumnCid);
		return;
	}
  
    if(m_oidBaseType != 0)
    {
        setPixmap(0, *m_pIconDomain);
    }
}

QPixmap *KPGTableColumn::getPixmapForType(const QString &strTypName)
{
	//--- Set column type icon ---------------------------------------------------
	if((strTypName == "bpchar") || (strTypName == "varchar") || (strTypName == "text"))
	{
		return m_pIconColumnChar;
	}
	
	if((strTypName == "xml"))
	{
		return m_pIconColumnXml;
	}
	
	if((strTypName == "int") || (strTypName == "int2") || (strTypName == "int4") || (strTypName == "int8") || (strTypName == "float4") || (strTypName == "float8") || (strTypName == "numeric") || (strTypName == "serial4") || (strTypName == "serial8") || (strTypName == "money"))
	{
		return m_pIconColumnNum;
	}
	
	if((strTypName == "uuid"))
	{
		return m_pIconColumnUuid;
	}
			
	if((strTypName == "bool"))
	{
		return m_pIconColumnBool;
	}
	
	if((strTypName == "time") || (strTypName == "timetz") || (strTypName == "interval"))
	{
		return m_pIconColumnTime;
	}
	
	if((strTypName == "date") || (strTypName == "timestamp") || (strTypName == "timestamptz"))
	{
		return m_pIconColumnDate;
	}
	
	if((strTypName == "point") || (strTypName == "line") || (strTypName == "lseg") || (strTypName == "box") || (strTypName == "path") || (strTypName == "polygon") || (strTypName == "circle"))
	{
		return m_pIconColumnGeo;
	}
	
	if((strTypName == "bit") || (strTypName == "varbit"))
	{
		return m_pIconColumnBit;
	}
	
	if((strTypName == "bytea"))
	{
		return m_pIconColumnBin;
	}
	
	if((strTypName == "cidr") || (strTypName == "inet") || (strTypName == "macaddr"))
	{
		return m_pIconColumnNet;
	}
	
	//----------------------------------------------------------------------------
	
	if((strTypName == "oid"))
	{
		return m_pIconColumnOid;
	}
	
	if((strTypName == "xid"))
	{
		return m_pIconColumnXid;
	}
	
	if((strTypName == "tid"))
	{
		return m_pIconColumnTid;
	}
	
	if((strTypName == "cid"))
	{
		return m_pIconColumnCid;
	}
  
  	//kdDebug() << "KPGTableColumn::getPixmapForType - Unknown column type: " + strTypName << endl;
	return m_pIconColumnOther;
}

const QString KPGTableColumn::createdAs() const
{
	QString strType(m_strTypName);
	
	if(m_iAttNdims > 0)
		strType = strType.mid(1, strType.length() - 1); // remove trailing _
	
	if(strType == "bpchar") 
	{
		strType = QString("char(%1)").arg(m_iAttTypmod - 4);
	}
	else if(strType == "varchar") 
	{
		strType = QString("varchar(%1)").arg(m_iAttTypmod - 4);
	}	
	else if(strType == "int2") 
	{
		strType = "smallint";
	}
	else if(strType == "int4") 
	{
		strType = "int";
	}
	else if(strType == "int8") 
	{
		strType = "bigint";
	}
	else if(strType == "float4") 
	{
		strType = "real";
	}
	if(strType == "float8") 
	{
		strType = "float";
	}
	else if(strType == "numeric") 
	{
		strType = QString("decimal(%1, %2)").arg((m_iAttTypmod - 4)  / 65536).arg((m_iAttTypmod - 4)  % 65536);
	}	
	else if(strType == "serial") 
	{
		strType = "serial";
	} 
	else if(strType == "serial8") 
	{
		strType = "bigserial";
	}
	else if(strType == "bit") 
	{
		strType = QString("bit(%1)").arg(m_iAttTypmod);
	}
	else if(strType == "varbit") 
	{
		strType = QString("varbit(%1)").arg(m_iAttTypmod);
	}	
	
	if(m_iAttNdims > 0)
	{
	  for(int i = 0; i < m_iAttNdims; i++)
			strType.append(" [?]");
	}
	
	return strType;
}

