//
// C++ Implementation: kpgtypeattribute
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtypeattribute.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgtype.h"


KPGTypeAttribute::KPGTypeAttribute(KPGType *parent, const QString name)
  : KPGTreeItem(parent, name)
{
  	setPixmap(0, *m_pIconColumnOther);
}


KPGTypeAttribute::KPGTypeAttribute(KPGType *parent, KPGTypeAttribute *after, const QString name)
  : KPGTreeItem(parent, after, name)
{
  	setPixmap(0, *m_pIconColumnOther);
}


KPGTypeAttribute::~KPGTypeAttribute()
{
}

void KPGTypeAttribute::setProperties(const pqxx::result::tuple &pqxxTuple)
{
	pqxxTuple["atttypid"].to(m_oidType);
	pqxxTuple["attlen"].to(m_iAttLen);
	pqxxTuple["attnum"].to(m_iAttNum);
	pqxxTuple["attndims"].to(m_iAttNdims);
	pqxxTuple["atttypmod"].to(m_iAttTypmod);
			
	m_strTypName = pqxxTuple["typname"].c_str();
	m_strNspName = pqxxTuple["nspname"].c_str();
	m_strDescription = pqxxTuple["description"].c_str();

	//--- Set column type icon ---------------------------------------------------
	if((m_strTypName == "bpchar") || (m_strTypName == "varchar") || (m_strTypName == "text"))
	{
		setPixmap(0, *m_pIconColumnChar);
		return;
	}
	
	if((m_strTypName == "int") || (m_strTypName == "int2") || (m_strTypName == "int4") || (m_strTypName == "int8") || (m_strTypName == "float4") || (m_strTypName == "float8") ||
(m_strTypName == "numeric") || (m_strTypName == "serial4") || (m_strTypName == "serial8") || (m_strTypName == "money"))
	{
		setPixmap(0, *m_pIconColumnNum);
		return;
	}
			
	if((m_strTypName == "bool"))
	{
		setPixmap(0, *m_pIconColumnBool);
		return;
	}
	
	if((m_strTypName == "time") || (m_strTypName == "timetz") || (m_strTypName == "interval"))
	{
		setPixmap(0, *m_pIconColumnTime);
		return;
	}
	
	if((m_strTypName == "date") || (m_strTypName == "timestamp") || (m_strTypName == "timestamptz"))
	{
		setPixmap(0, *m_pIconColumnDate);
		return;
	}
	
	if((m_strTypName == "point") || (m_strTypName == "line") || (m_strTypName == "lseg") || (m_strTypName == "box") || (m_strTypName == "path") || (m_strTypName == "polygon") ||
(m_strTypName == "circle"))
	{
		setPixmap(0, *m_pIconColumnGeo);
		return;
	}
	
	if((m_strTypName == "bit") || (m_strTypName == "varbit"))
	{
		setPixmap(0, *m_pIconColumnBit);
		return;
	}
	
	if((m_strTypName == "bytea"))
	{
		setPixmap(0, *m_pIconColumnBin);
		return;
	}
	
	if((m_strTypName == "cidr") || (m_strTypName == "inet") || (m_strTypName == "macaddr"))
	{
		setPixmap(0, *m_pIconColumnNet);
		return;
	}
	
	if((m_strTypName == "xml"))
	{
		setPixmap(0, *m_pIconColumnXml);
		return;
	}
	
	if((m_strTypName == "uuid"))
	{
		setPixmap(0, *m_pIconColumnUuid);
		return;
	}
	
	//----------------------------------------------------------------------------
	
	if((m_strTypName == "oid"))
	{
		setPixmap(0, *m_pIconColumnOid);
		return;
	}
	
	if((m_strTypName == "xid"))
	{
		setPixmap(0, *m_pIconColumnXid);
		return;
	}
	
	if((m_strTypName == "tid"))
	{
		setPixmap(0, *m_pIconColumnTid);
		return;
	}
	
	if((m_strTypName == "cid"))
	{
		setPixmap(0, *m_pIconColumnCid);
		return;
	}
}

QPixmap *KPGTypeAttribute::getPixmapForType(const QString &strTypName)
{
	//--- Set column type icon ---------------------------------------------------
	if((strTypName == "bpchar") || (strTypName == "varchar") || (strTypName == "text"))
	{
		return m_pIconColumnChar;
	}
	
	if((strTypName == "int") || (strTypName == "int2") || (strTypName == "int4") || (strTypName == "int8") || (strTypName == "float4") || (strTypName == "float8") || (strTypName ==
"numeric") || (strTypName == "serial4") || (strTypName == "serial8") || (strTypName == "money"))
	{
		return m_pIconColumnNum;
	}
			
	if((strTypName == "bool"))
	{
		return m_pIconColumnBool;
	}
	
	if((strTypName == "time") || (strTypName == "timetz") || (strTypName == "interval"))
	{
		return m_pIconColumnTime;
	}
	
	if((strTypName == "date") || (strTypName == "timestamp") || (strTypName == "timestamptz"))
	{
		return m_pIconColumnDate;
	}
	
	if((strTypName == "point") || (strTypName == "line") || (strTypName == "lseg") || (strTypName == "box") || (strTypName == "path") || (strTypName == "polygon") || (strTypName ==
"circle"))
	{
		return m_pIconColumnGeo;
	}
	
	if((strTypName == "bit") || (strTypName == "varbit"))
	{
		return m_pIconColumnBit;
	}
	
	if((strTypName == "bytea"))
	{
		return m_pIconColumnBin;
	}
	
	if((strTypName == "cidr") || (strTypName == "inet") || (strTypName == "macaddr"))
	{
		return m_pIconColumnNet;
	}
	
	//----------------------------------------------------------------------------
	
	if((strTypName == "oid"))
	{
		return m_pIconColumnOid;
	}
	
	if((strTypName == "xid"))
	{
		return m_pIconColumnXid;
	}
	
	if((strTypName == "tid"))
	{
		return m_pIconColumnTid;
	}
	
	if((strTypName == "cid"))
	{
		return m_pIconColumnCid;
	}
  
  	//kdDebug() << "KPGTypeAttribute::getPixmapForType - Unknown column type: " + strTypName << endl;
	return m_pIconColumnOther;
}

