//
// C++ Interface: kpgtypeattribute
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGTYPEATTRIBUTE_H
#define KPGTYPEATTRIBUTE_H

#include "kpgtreeitem.h"

class KPGType;

/**
  * Type attribute
  *
  * @author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPGTypeAttribute : public KPGTreeItem
{
public:
	KPGTypeAttribute(KPGType *, const QString);
	KPGTypeAttribute(KPGType *, KPGTypeAttribute *, const QString);
  	~KPGTypeAttribute();
  
	virtual eNodeType type() const { return nodeTypeAttribute; }
  	void setProperties(const pqxx::result::tuple &);
  	
  	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return refreshItem(); }
	
	// Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &) { return; }
  	
  	static QPixmap *getPixmapForType(const QString &);
  	
	/*
	 * Functions for accessing properties
	 */
	pqxx::oid oidType() const { return m_oidType; }
  	const QString & typName() const { return m_strTypName; }
  	int attLen() const { return m_iAttLen; }
	int attNum() const { return m_iAttNum; }
	int attNdims() const { return m_iAttNdims; }
	int attTypmod() const { return m_iAttTypmod; }
	const QString & nspName() const { return m_strNspName; }
	const QString & description() const { return m_strDescription; }

protected:
	
	/*
	 * Properties
	 */
	pqxx::oid m_oidType;
  	QString m_strTypName;
	int m_iAttLen;
	int m_iAttNum; 
	int m_iAttNdims;
	int m_iAttTypmod;
	QString m_strNspName;
	QString m_strDescription;
};

#endif
