//
// C++ Interface: kpgdebugger
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGDEBUGGER_H
#define KPGDEBUGGER_H

#include "kpgdebuggerbase.h"

#include <kparts/factory.h> // KPart Factory
#include <kate/view.h>      // Katepart view

#include "../kpgconnectioninthread.h"

class KFind;
class KXMLGUIFactory;

class KPGConnection;
class KPGDatabase;
class KPGFunction;
class KPGDebuggerChildView;
class KPoGreView;

/**
  * PL pg/SQL debugger window
  *
  * @author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPGDebugger : public KPGDebuggerBase, virtual public KXMLGUIClient
{
	Q_OBJECT
public:
	KPGDebugger(KPGDebuggerChildView *, KPoGreView *, KParts::Factory *, KXMLGUIFactory *, const PGSTD::string &, const QString &, KPGFunction *);
    ~KPGDebugger();

	// Add yourself and Kate view to GUI factory
    void addToGuiFactory();
    
    // Remove yourself and Kate view from GUI factory
    void removeFromGuiFactory();
    
	// Debugger states
	enum EState 
	{ 	
		prepared = 0,
  		waitingForDebuggerPort,
  		obtainedDebuggerPort,
		attached,
  		attachFailed
	};
	
    // Set function source code
    void setEditorText(const QString &);
    
    // Get function source code
    const QString editorText() const;
    
	// Returns true, if breakpoint is set to given line
	bool isBreakpointSet(unsigned int) const;
	
protected:	
	
	// Create Kate part view
	Kate::View* createKatePart(KParts::Factory*);
	
	// Display SQL result
	void displayResult();  
	
	// Receive event from KPGConnectionInThread
	virtual void customEvent(QCustomEvent *);
	
	// Prepare SQL statement
	void prepareSelectStatement(const std::string &);
             
    // Run SQL to debug function on DB server
	bool runSql(KPGConnection::ETransType);
	
	/*
	 * Functions for communicate with server-side debugger
	 */
	int getProxyInfo();
	bool oidDebug();
	void executeFunction();
	void attachToDebugger();
	void stopDebugging();
	void setBreakpoint(uint);
	void clearBreakpoint(uint);
			
signals:

	// Fired when debugger need update actions
	void sigDebuggerStateChanged(KPGDebugger *);
	
protected:
	    
	// Debugger actions
    KAction* m_pActRun;
	KAction* m_pActStop;
	KAction* m_pActStepOver;
	KAction* m_pActStepInto;
	KAction* m_pActToggleBreakPoint;

	// XML GUI factory
    KXMLGUIFactory * m_pXmlGuiFactory;
    
    // True, if this is in GUI factory
    bool m_bIsAddedToGuiFactory;

	// Debugger state
	EState m_state;
	
    // Connection options
	PGSTD::string m_strConnectionOptions;
    
    // Database function to execute
    QString m_strFunctionName;
    
    // Function namespace
    QString m_strNamespaceName;
        	
	// List of argument informations, available since PostgreSQL 8.1
	KPGFunction::ListArguments m_listArguments;
	   
	// Kate part editor
    Kate::View* m_pKateView;
	
	// Thread that run queries on background
	KPGConnectionInThread m_connectionInThread;
	
	// Resultset to display
	pqxx::result m_pqxxResult;
	
	// TCP/IP Port number for attach to remote debugger
	QString m_strDebuggerPort;
	
	// Version of debugger API
	int m_iProxyApiVersion;
	
	// Number of rows in result
	unsigned int m_nTotalRows; 
	
	// Number of fetched rows from result
	unsigned int m_nFetchedRows; 
	
	// Number of columns in result
	unsigned int m_nTotalCols; 
	
	// Debugger session handle
	QString m_strSessionHandle;
	
	// PostgreSQL row identifier of debugged function
	pqxx::oid m_oidFunction;
	
	// Timer, that ensure some periodically actions
	QTimer *m_pTimer;
	
	// Mutex for synchronizing acces with m_connectionInThread
	QMutex mutex;
    
private:
	int max(int a, int b) { return a > b ? a : b; }
	int min(int a, int b) { return a < b ? a : b; }
		
protected slots:
	
	// Process notice from connection in thread
	void slotProcessNotice(QString);
	
	// Fired from m_pTimer
	void slotTimer();
	
	//--- Debugger actions
    void slotExecute();
    void slotStop();
    void slotStepOver();
	void slotStepInto();
	void slotToggleBreakPoint();
};

#endif
