//
// C++ Implementation: kpgfunctionproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgfunctionproppage.h"

// include files for Qt
#include <qiconset.h>
#include <qlineedit.h>
#include <qtable.h>

// include files for KDE
#include <ktabwidget.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <klistview.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <ktextedit.h>
#include <kdebug.h>
#include <klocale.h>

// application specific includes
#include "../QueryResult/kpgsyntaxhighlighter.h"
#include "../kpogreview.h"
#include "../kpgconfiguration.h"
#include "../QueryResult/kpgsqleditorsettings.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgtablecolumn.h"
#include "../kpglinklabel.h"
#include "../kpgutil.h"


KPGFunctionPropPage::KPGFunctionPropPage(QWidget *parent, KPGFunction *pFunction)
 : KPGFunctionPropPageBase(parent, "KPGFunctionPropPage")
{
	m_pFunction = pFunction;
    m_pSyntaxHighlighter = new KPGSyntaxHighlighter(m_pTextEditSource);
	
	// Apply current configuration
	slotSqlEditorSettingsChanged();
 	// and make sure to be informed about its changes.
	connect( KPoGreView::configuration()->sqleditor(), SIGNAL(sigChanged()), this, SLOT(slotSqlEditorSettingsChanged()) );
  
    m_pTabWidget->setTabIconSet(tabACL, QIconSet(QPixmap(UserIcon("group"))));
    m_pTabWidget->setTabIconSet(tabArguments, QIconSet(QPixmap(UserIcon("argument"))));
    
    m_pListViewArguments->setSortColumn(-1);
    
    displayProperties();
}


KPGFunctionPropPage::~KPGFunctionPropPage()
{
	disconnect( KPoGreView::configuration()->sqleditor(), SIGNAL(sigChanged()), this, SLOT(slotSqlEditorSettingsChanged()) );
  
  delete m_pSyntaxHighlighter;
}

void KPGFunctionPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

  	pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pFunction->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
  	m_pTableProperties->setText(iRow, 1, m_pFunction->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Function name"));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
  	m_pTableProperties->setText(iRow, 1, m_pFunction->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the function"));
		
	//--- Is Aggregate
	m_pTableProperties->setText(iRow, 0, i18n("Is Aggregate"));
  	m_pTableProperties->setPixmap(iRow, 1, m_pFunction->isAggregate() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("True if function is an aggregate function)"));
	
	//--- Is Security definer
	m_pTableProperties->setText(iRow, 0, i18n("Is Security definer"));
  	m_pTableProperties->setPixmap(iRow, 1, m_pFunction->isSecdef() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("Function is a security definer (i.e., a \"setuid\" function"));
			
	//--- Is Strict
	m_pTableProperties->setText(iRow, 0, i18n("Is Strict"));
  	m_pTableProperties->setPixmap(iRow, 1, m_pFunction->isStrict() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("Function returns null if any call argument is null. In that case the \
	function won't actually be called at all. Functions that are not \"strict\" must be prepared to handle null inputs."));
	
	//--- Return Set
	m_pTableProperties->setText(iRow, 0, i18n("Return Set"));
  	m_pTableProperties->setPixmap(iRow, 1, m_pFunction->returnSet() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("Function returns a set (i.e., multiple values of the specified data type)"));
	
	//--- Volatile
	m_pTableProperties->setText(iRow, 0, i18n("Volatile"));
  	m_pTableProperties->setText(iRow, 1, m_pFunction->getVolatile());
	m_pTableProperties->setText(iRow++, 2, i18n("Tells whether the function's result depends only on its input arguments, or is affected by outside factors. It is i for \"immutable\" functions, which always deliver the same result for the same inputs. It is s for \"stable\" functions, whose results (for fixed inputs) do not change within a scan. It is v for \"volatile\" functions, whose results may change at any time. (Use v also for functions with side-effects, so that calls to them cannot get optimized away.) "));
	
	//--- Number of argument
	m_pTableProperties->setText(iRow, 0, i18n("Number of arguments"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pFunction->nArgs()));
	m_pTableProperties->setText(iRow++, 2, i18n("Number of arguments"));
	
	//--- Bin
	m_pTableProperties->setText(iRow, 0, i18n("Bin"));
  	m_pTableProperties->setText(iRow, 1, m_pFunction->bin());
	m_pTableProperties->setText(iRow++, 2, i18n("Additional information about how to invoke the function. Again, the interpretation is language-specific."));
	
	//--- Type name
	m_pTableProperties->setText(iRow, 0, i18n("Type name"));
  	KPGLinkLabel *pLabel = new KPGLinkLabel( m_pTableProperties, "Type name" );
	pLabel->setValues(m_pFunction->oidReturnType(), m_pFunction->returnTypName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Return data type name"));
	
	//--- Language name
	m_pTableProperties->setText(iRow, 0, i18n("Language name"));
  	m_pTableProperties->setText(iRow, 1, m_pFunction->langName());
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the language (to be specified when creating a function)"));
	
	//--- Owner
	m_pTableProperties->setText(iRow, 0, i18n("Owner"));
  	m_pTableProperties->setText(iRow, 1, m_pFunction->owner());
	m_pTableProperties->setText(iRow++, 2, i18n("Function owner"));
	
	//--- Namespace
	/*m_pTableProperties->setText(iRow, 0, i18n("Namespace"));
	m_pTableProperties->setText(iRow, 1, m_strNameSpace);
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the namespace"));
	*/
	
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}
	
	m_pLineEditArgTypes->setText(m_pFunction->argTypes());
	m_pTextEditSource->setText(m_pFunction->source());

	//--- Access privileges
	displayACL();
	
	//--- Arguments list
	displayArgumentsList();
}


void KPGFunctionPropPage::slotSqlEditorSettingsChanged()
{
    m_pTextEditSource->setFont( KPoGreView::configuration()->sqleditor()->font() );
    
	m_pSyntaxHighlighter->setColorDefaultText( KPoGreView::configuration()->sqleditor()->colorDefaultText() );
	m_pSyntaxHighlighter->setColorKeyWords( KPoGreView::configuration()->sqleditor()->colorKeyWords() );
	m_pSyntaxHighlighter->setColorDataTypes( KPoGreView::configuration()->sqleditor()->colorDataTypes() );
	m_pSyntaxHighlighter->setColorOperators( KPoGreView::configuration()->sqleditor()->colorOperators() );
	m_pSyntaxHighlighter->setColorQuotedStrings( KPoGreView::configuration()->sqleditor()->colorQuotedStrings() );
	m_pSyntaxHighlighter->setColorNumbers( KPoGreView::configuration()->sqleditor()->colorNumbers() );
    m_pSyntaxHighlighter->setColorComments( KPoGreView::configuration()->sqleditor()->colorComments() );
	
	m_pSyntaxHighlighter->rehighlight();
}

void KPGFunctionPropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGFunctionPropPage::displayACL()
{
	QString strACL(m_pFunction->acl());
	
	m_pListViewACL->clear();
	m_listOfAclItems.clear();
	m_pLineEditACL->setText(strACL);
	
	QString strAclItem; // string for one ACL item, e.g. miriam=arwdRxt/miriam
	for(unsigned int i = 0; i < strACL.length(); i++)
	{
		if(strACL[i] == '{')
		continue;
		
		if((strACL[i] == ',') || (strACL[i] == ','))
		{
			m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
			strAclItem.truncate(0); // clear ACL string
		}
		else
		{
			strAclItem.append(strACL[i]);
		}
	}
	
	if(!strAclItem.isEmpty())
		m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
	
	// Traverse list of ACL items
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		QListViewItem * pItem = new QListViewItem( m_pListViewACL, 0 );
		(*it).setListViewItem(pItem);
		
		pItem->setText(0, (*it).grantee());
		pItem->setText(1, (*it).grantor());
		
		pItem->setPixmap(2, UserIcon((*it).canExecute() ? "box_checked" : "box_clear"));
		
		if((*it).canPassGrantToOther())
		pItem->setPixmap(3, UserIcon((*it).canGrantExecute() ? "box_checked" : "box_clear"));
	} 
}

void  KPGFunctionPropPage::displayArgumentsList()
{
	m_pListViewArguments->clear();
	const KPGFunction::ListArguments & listArguments = m_pFunction->listArguments();
	
	QListViewItem * pItemAfter = 0;
	for(KPGFunction::ListArguments::const_iterator cit = listArguments.begin(); cit != listArguments.end(); ++cit)
	{ 
		
		QListViewItem * pItem = new QListViewItem( m_pListViewArguments, pItemAfter);
		
		if((*cit).typName().length() > 0)
		{
			QPixmap *pTypePixmap = KPGTableColumn::getPixmapForType((*cit).typName());
			pItem->setPixmap(0, *pTypePixmap);
		}
		
		pItem->setText(0, (*cit).typName());
		pItem->setText(1, (*cit).name());
		
		if((*cit).mode() == "i") pItem->setText(2, "IN");
		else if((*cit).mode() == "o") pItem->setText(2, "OUT");
		else if((*cit).mode() == "b") pItem->setText(2, "INOUT");
		
		pItemAfter = pItem;
    }
}

void KPGFunctionPropPage::slotAclListViewClicked(QListViewItem *pItem, const QPoint &, int iColumn)
{
  // Find KPGAclItem using pItem value
  KPGAclItemList::iterator it;
  for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
  {   
    if(pItem == (*it).getListViewItem())
    {
      // found ...
      
      switch(iColumn)
      {
        case 0:
        case 1: // do nothing on first 2 columns
            break;
        
        case 2:
            pItem->setPixmap(2, UserIcon((*it).toggleExecute() ? "box_checked" : "box_clear"));
            break;
       
        case 3:
            if((*it).canPassGrantToOther())
              pItem->setPixmap(3, UserIcon((*it).toggleGrantExecute() ? "box_checked" : "box_clear"));
            
            break;
            
        default:
                kdError() << k_funcinfo << " Unexpected column !" << endl;
                break;      
      }
    
      m_pPushButtonUpdateACL->setEnabled(true);
      return;
    }
  }
}

void KPGFunctionPropPage::slotUpdateACL()
{
  QString strSQL;
  
  KPGSchema *pSchema = static_cast <KPGSchema *> (m_pFunction->parent()->parent());
    
  // Traverse all items and get their SQL's
  KPGAclItemList::iterator it;
  for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
  {   
    strSQL.append((*it).getSQL("FUNCTION " + KPGUtil::fullyQualifiedName(pSchema->text(0), m_pFunction->text(0)) + m_pFunction->argumentTypes()));
  }
  
  if(!strSQL.isEmpty())
    emit sigRunWizard(strSQL);
}


// Consumes request for context menu for property table
void KPGFunctionPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgfunctionproppage.moc"
