//
// C++ Implementation: kpgprimarykeyproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgprimarykeyproppage.h"

// include files for Qt
#include <qiconset.h>
#include <qtable.h>  

// include files for KDE
#include <ktabwidget.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <kdebug.h>
#include <klocale.h>
#include <ktextedit.h>

#include "../kpglinklabel.h"
#include "../kpgutil.h"
#include "../QueryResult/kpgsyntaxhighlighter.h"
#include "../kpogreview.h"
#include "../kpgconfiguration.h"
#include "../QueryResult/kpgsqleditorsettings.h"
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgprimarykey.h"
#include "../kpgsqldialog.h"


KPGPrimaryKeyPropPage::KPGPrimaryKeyPropPage(QWidget *parent, KPGPrimaryKey *pIndex)
 : KPGPrimaryKeyPropPageBase(parent, "KPGPrimaryKeyPropPage")
{
  m_pIndex = pIndex;
  m_pSyntaxHighlighter = new KPGSyntaxHighlighter(m_pTextEditDefinition);
  
  // Apply current configuration
  slotSqlEditorSettingsChanged();
  // and make sure to be informed about its changes.
  connect( KPoGreView::configuration()->sqleditor(), SIGNAL(sigChanged()), this, SLOT(slotSqlEditorSettingsChanged()) );
  
  m_pTabWidget->setTabIconSet(tabStatistics, QIconSet(QPixmap(SmallIcon("ksysguard.png")))); 
  m_pButtonRefresh->setIconSet(QIconSet(QPixmap(BarIcon("reload.png")))); 
  
  displayProperties();
}


KPGPrimaryKeyPropPage::~KPGPrimaryKeyPropPage()
{
}

void KPGPrimaryKeyPropPage::displayProperties()
{
	KPGServer *pServer = static_cast <KPGServer*> (m_pIndex->parent()->parent()->parent()->parent()->parent()->parent());

	bool bVersion80_OrNewer = false;
	bool bVersion81_OrNewer = false;

	//Is it 8.0 ornewer ?
	if(pServer->versionMajor() > 7)
	{
		bVersion80_OrNewer = true;
	}

	//Isit 8.1 or newer ?
	if(((pServer->versionMajor() == 8 ) && (pServer->versionMiddle() >= 1 ))||((pServer->versionMajor() > 8 )))
	{
		bVersion81_OrNewer = true;
	}

	QHeader* pHeader = m_pTableProperties->horizontalHeader();

	pHeader->setLabel(0,i18n("Name"));
	pHeader->setLabel(1,i18n("Value"));
	pHeader->setLabel(2,i18n("Description"));

	int iRow=0;

	//---OID
	m_pTableProperties->setText(iRow,0,i18n("OID"));
	m_pTableProperties->setText(iRow,1,QString("%1").arg(m_pIndex->oid()));
	m_pTableProperties->setText(iRow++,2,i18n("PostgreSQL row identifier"));

	//---Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
	m_pTableProperties->setText(iRow, 1, m_pIndex->text(0));
	m_pTableProperties->setText(iRow++,2, i18n("Name of the index"));

	//---Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
	m_pTableProperties->setText(iRow, 1 , m_pIndex->description());
	m_pTableProperties->setText(iRow++,2, i18n("Description of the index"));

	//---Indexkey
	m_pTableProperties->setText(iRow, 0, i18n("Indexkey"));
	m_pTableProperties->setText(iRow, 1, m_pIndex->indKey());
	m_pTableProperties->setText(iRow++, 2, i18n("This is an array of indnatts(up to INDEX_MAX_KEYS) values \
	that indicate which table columns this indexindexes. For example \
 a value of 1 3 would mean that the first and the third table columns make up the indexkey. A \
 zero in thisarray indicates that the corresponding index attribute is an expression \
 overthetablecolumns,ratherthanasimplecolumnreference."));

	//---IsUnique
	m_pTableProperties->setText(iRow, 0, i18n("Is Unique"));
	m_pTableProperties->setPixmap(iRow, 1 , m_pIndex->isUnique() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++,2, i18n("If true,this is a unique index."));

	//---IsPrimary
	m_pTableProperties->setText(iRow,0, i18n("Is Primary"));
	m_pTableProperties->setPixmap(iRow,1 , m_pIndex->isPrimary() ? *KPGUtil::m_pIconTrue :  *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("If true, this index representst he primary key of the table. (indisunique should always be true when this is true.)"));

	//---IsClustered
	m_pTableProperties->setText(iRow, 0, i18n("Is Clustered"));
	m_pTableProperties->setPixmap(iRow, 1, m_pIndex->isClustered() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("If true, the table was last clustered on this index."));

	//---Tablespace
	m_pTableProperties->setText(iRow, 0, i18n("Tablespace"));
	KPGLinkLabel*pLabel= new KPGLinkLabel(m_pTableProperties, "Tablespace");
	pLabel->setValues(m_pIndex->oidTablespace(), m_pIndex->tablespace());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Tablespace name"));

	//---Prettysizeofindex
	m_pTableProperties->setText(iRow, 0, i18n("Rounded size"));
	if(bVersion81_OrNewer)
		m_pTableProperties->setText(iRow, 1, m_pIndex->prettySize());
	else
		m_pTableProperties->setText(iRow, 1,"N/A");
	m_pTableProperties->setText(iRow++, 2, i18n("Disk space used by the index"));

	//---Exactsizeofindex
	m_pTableProperties->setText(iRow, 0, i18n("Exactsize"));
	if(bVersion81_OrNewer)
		m_pTableProperties->setText(iRow, 1, QString("%L1B").arg(m_pIndex->size()));
	else
		m_pTableProperties->setText(iRow, 1,"N/A");
	m_pTableProperties->setText(iRow++, 2, i18n("Disk space used by the index"));


	for(int nCol=0; nCol<3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}

	m_pTextEditDefinition->setText(m_pIndex->indexdef());

	displayStatistics();
	displayIoStatistics();
}

void KPGPrimaryKeyPropPage::displayStatistics()
{
	QHeader* pHeader = m_pTableStatistics->horizontalHeader();
	
	pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	try
	{
		pqxx::result pqxxResultStatistics = m_pIndex->queryStatistics();
	
		if(pqxxResultStatistics.size() != 1)
		{
			kdError() << k_funcinfo "Expect one row in result !" <<  endl;
			return;
		}
		
		if(m_pIndex->text(0) != pqxxResultStatistics[0]["indexrelname"].c_str())
		{
		kdDebug() << "KPGTable::displayStatistics(): table name not match" << endl;
		return;
		}
		
		int iRow = 0;
		
		//--- seq_scan
		m_pTableStatistics->setText(iRow, 0, i18n("idx_scan"));
		m_pTableStatistics->setText(iRow, 1, pqxxResultStatistics[0]["idx_scan"].c_str());
		m_pTableStatistics->setText(iRow++, 2, i18n("Total number of index scans"));
		
		//--- seq_scan
		m_pTableStatistics->setText(iRow, 0, i18n("idx_tup_read"));
		m_pTableStatistics->setText(iRow, 1, pqxxResultStatistics[0]["idx_tup_read"].c_str());
		m_pTableStatistics->setText(iRow++, 2, i18n("Total number of tuples read"));
		
		//--- idx_tup_fetch
		m_pTableStatistics->setText(iRow, 0, i18n("idx_tup_fetch"));
		m_pTableStatistics->setText(iRow, 1, pqxxResultStatistics[0]["idx_tup_fetch"].c_str());
		m_pTableStatistics->setText(iRow++, 2, i18n("Total number of sucessfully fetched heap tuples"));
	}
	catch (const KPGSqlException &e)
	{
	   KPGSqlDialog dlg(this, e.getSql(), e.what());
	   dlg.exec();
	} 
	
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableStatistics->adjustColumn(nCol);
	}
}

void KPGPrimaryKeyPropPage::displayIoStatistics()
{
	QHeader* hHeader = m_pTableIoStatistics->horizontalHeader();
	
	hHeader->setLabel(0, i18n("Name"));
	hHeader->setLabel(1, i18n("Value"));
	hHeader->setLabel(2, i18n("Description"));
	
	try
	{
		pqxx::result pqxxResultStatistics = m_pIndex->queryIoStatistics();
	
		if(pqxxResultStatistics.size() != 1)
		{
			kdError() << k_funcinfo "Expect one row in result !" <<  endl;
			return;
		}
		
		if(m_pIndex->text(0) != pqxxResultStatistics[0]["indexrelname"].c_str())
		{
			kdDebug() << "KPGTable::displayStatistics(): table name not match" << endl;
			return;
		}
		
		int iRow = 0;
		
		//--- seq_scan
		m_pTableIoStatistics->setText(iRow, 0, i18n("idx_blks_read"));
		m_pTableIoStatistics->setText(iRow, 1, pqxxResultStatistics[0]["idx_blks_read"].c_str());
		m_pTableIoStatistics->setText(iRow++, 2, i18n("Total number of disc blocks read"));
		
		//--- heap_blks_hit
		m_pTableIoStatistics->setText(iRow, 0, i18n("idx_blks_hit"));
		m_pTableIoStatistics->setText(iRow, 1, pqxxResultStatistics[0]["idx_blks_hit"].c_str());
		m_pTableIoStatistics->setText(iRow++, 2, i18n("Number of buffer hits"));
	}
	catch (const KPGSqlException &e)
	{
	   KPGSqlDialog dlg(this, e.getSql(), e.what());
	   dlg.exec();
	}
	
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableIoStatistics->adjustColumn(nCol);
	}
}

void KPGPrimaryKeyPropPage::slotSqlEditorSettingsChanged()
{
  m_pTextEditDefinition->setFont( KPoGreView::configuration()->sqleditor()->font() );
  
  m_pSyntaxHighlighter->setColorDefaultText( KPoGreView::configuration()->sqleditor()->colorDefaultText() );
  m_pSyntaxHighlighter->setColorKeyWords( KPoGreView::configuration()->sqleditor()->colorKeyWords() );
  m_pSyntaxHighlighter->setColorDataTypes( KPoGreView::configuration()->sqleditor()->colorDataTypes() );
  m_pSyntaxHighlighter->setColorOperators( KPoGreView::configuration()->sqleditor()->colorOperators() );
  m_pSyntaxHighlighter->setColorQuotedStrings( KPoGreView::configuration()->sqleditor()->colorQuotedStrings() );
  m_pSyntaxHighlighter->setColorNumbers( KPoGreView::configuration()->sqleditor()->colorNumbers() );
  m_pSyntaxHighlighter->setColorComments( KPoGreView::configuration()->sqleditor()->colorComments() );
  
  m_pSyntaxHighlighter->rehighlight();
}

void KPGPrimaryKeyPropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
    if(w == 0)
      return;
          
    KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
    pqxx::oid _oid = pLabel->oid();
      
    if(_oid != 0)
      emit sigSearchObject(_oid);
}

void KPGPrimaryKeyPropPage::slotRefreshStatistics()
{
  displayStatistics();
  displayIoStatistics();
}

// Consumes request for context menu for property table
void KPGPrimaryKeyPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgprimarykeyproppage.moc"
