//
// C++ Implementation: kpgviewsfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgviewsfolderproppage.h"

#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgviewsfolder.h"


KPGViewsFolderPropPage::KPGViewsFolderPropPage(QWidget* parent, KPGViewsFolder * pViewsFolder)
	: KPGPropertyPage(parent, "KPGViewsFolderPropPage")
{
	m_pViewsFolder = pViewsFolder;
	displayProperties();
}


KPGViewsFolderPropPage::~KPGViewsFolderPropPage()
{
}

void KPGViewsFolderPropPage::displayProperties()
{
	setLabelText(i18n("Views &list:"));
	
	QHeader* pHeader = m_pTableItems->horizontalHeader();

  	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
  	pHeader->setLabel(nCol++, i18n("Description"));
	pHeader->setLabel(nCol++, i18n("Owner"));
  	pHeader->setLabel(nCol++, i18n("ACL"));

	KPGUtil::fillPropertiesTable(m_pViewsFolder->resultViews(), m_pTableItems);
}


